/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.security.PrivateKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class HomeNA {
    public static void main(String[] argv) {
        if (argv.length < 5) {
            System.err.println("usage: java net.handle.apps.simple.HomeNA <auth hdl> <privkey> <server ip> <server tcp port> <NA handle1> [<NA handle2>...]");
            System.exit(-1);
        }
        String authHdl = argv[0];
        String privKeyFile = argv[1];
        String serverIp = argv[2];
        int port = Integer.parseInt(argv[3]);
        String[] nas = new String[argv.length - 4];
        System.arraycopy(argv, 4, nas, 0, nas.length);
        byte[] key = null;
        try {
            File f = new File(privKeyFile);
            FileInputStream fs = new FileInputStream(f);
            key = new byte[(int)f.length()];
            int n = 0;
            while (n < key.length) {
                key[n++] = (byte)fs.read();
            }
            fs.read(key);
        }
        catch (Throwable t) {
            System.err.println("Cannot read private key " + privKeyFile + ": " + t);
            System.exit(-1);
        }
        HandleResolver resolver = new HandleResolver();
        resolver.traceMessages = true;
        PrivateKey privkey = null;
        byte[] secKey = null;
        try {
            if (Util.requiresSecretKey(key)) {
                secKey = Util.getPassphrase("passphrase: ");
            }
            key = Util.decrypt(key, secKey);
            privkey = Util.getPrivateKeyFromBytes(key, 0);
        }
        catch (Throwable t) {
            System.err.println("Can't load private key in " + privKeyFile + ": " + t);
            System.exit(-1);
        }
        try {
            PublicKeyAuthenticationInfo auth = new PublicKeyAuthenticationInfo(authHdl.getBytes("UTF8"), 300, privkey);
            InetAddress svrAddr = InetAddress.getByName(serverIp);
            GenericRequest siReq = new GenericRequest(Common.BLANK_HANDLE, 2, null);
            siReq.certify = true;
            resolver.setCheckSignatures(false);
            AbstractResponse response = resolver.sendHdlTcpRequest(siReq, svrAddr, port);
            SiteInfo siteInfo = null;
            if (response == null || response.responseCode != 1) {
                throw new Exception("Unable to retrieve site information from server");
            }
            siteInfo = ((GetSiteInfoResponse)response).siteInfo;
            if (!siteInfo.isPrimary) {
                throw new Exception("Given server is not a primary server.");
            }
            resolver.setCheckSignatures(true);
            resolver.traceMessages = true;
            for (int naIdx = 0; naIdx < nas.length; ++naIdx) {
                GenericRequest req = new GenericRequest(Util.encodeString(nas[naIdx]), 300, auth);
                req.majorProtocolVersion = (byte)2;
                req.minorProtocolVersion = 0;
                req.certify = true;
                for (int i = 0; i < siteInfo.servers.length; ++i) {
                    response = resolver.sendRequestToServer(req, siteInfo.servers[i]);
                    if (response.responseCode == 1) continue;
                    throw new Exception(String.valueOf(response));
                }
            }
        }
        catch (Throwable t) {
            System.err.println("\nError: " + t);
        }
    }
}

