/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.handle.apps.gui.jutil.FileOpt;

public class ZipFile {
    public static boolean ZIP(File dir, String[] infiles, String outName) {
        File file = new File(outName);
        if (file.exists() || !FileOpt.getParent(file).canWrite()) {
            System.err.println("zip error: Can not write file: " + outName);
            return false;
        }
        ZipOutputStream zout = null;
        try {
            zout = new ZipOutputStream(new FileOutputStream(file));
            zout.setMethod(0);
            FileInputStream in = null;
            for (int i = 0; i < infiles.length; ++i) {
                try {
                    int n;
                    File f1 = new File(dir, infiles[i]);
                    if (!(f1.exists() && f1.isFile() && f1.canRead())) {
                        return false;
                    }
                    CRC32 crc32 = new CRC32();
                    in = new FileInputStream(f1);
                    byte[] bf = new byte[(int)f1.length()];
                    in.read(bf);
                    crc32.update(bf);
                    ZipEntry zent = new ZipEntry(infiles[i]);
                    zent.setTime(file.lastModified());
                    zent.setSize(f1.length());
                    zent.setCrc(crc32.getValue());
                    zout.putNextEntry(zent);
                    in = new FileInputStream(f1);
                    byte[] buffer = new byte[1024];
                    while ((n = in.read(buffer)) > -1) {
                        zout.write(buffer, 0, n);
                    }
                    in.close();
                    zout.closeEntry();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e1) {
                            return false;
                        }
                    }
                    return false;
                }
            }
            zout.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            if (zout != null) {
                try {
                    zout.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static boolean UNZIP(File dir, String zipfile) {
        File file = new File(zipfile);
        if (!file.exists() || !file.canRead()) {
            System.err.println("unzip error: Can not read Zip file:" + zipfile);
            return false;
        }
        ZipInputStream zin = null;
        try {
            zin = new ZipInputStream(new FileInputStream(file));
            FileOutputStream fout = null;
            try {
                ZipEntry zent;
                while ((zent = zin.getNextEntry()) != null) {
                    String fname = zent.getName();
                    File f2 = new File(dir, fname);
                    if (f2.exists()) {
                        System.err.println("unzip error: Can not write Zip file: " + f2.getName());
                        return false;
                    }
                    fout = new FileOutputStream(f2);
                    System.err.println(fname);
                    if (zent != null) {
                        int n;
                        byte[] buffer = new byte[1024];
                        while ((n = zin.read(buffer)) > -1) {
                            fout.write(buffer, 0, n);
                        }
                        fout.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                return false;
            }
            zin.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (Exception e1) {
                    return false;
                }
            }
            return false;
        }
    }

    public static boolean unzipToDir(String zipfile, File[] files) {
        if (!zipfile.endsWith(".zip")) {
            return false;
        }
        files[0] = null;
        String unzipName = new String(zipfile);
        int ind = unzipName.indexOf(".zip");
        unzipName = unzipName.substring(0, ind);
        System.err.println("unzip message: Unzip " + zipfile + " to directory " + unzipName + "...");
        File f1 = new File(unzipName);
        if (f1.exists()) {
            System.err.println("unzip error: " + unzipName + " already existed");
            return false;
        }
        if (FileOpt.getParent(f1).canWrite()) {
            f1.mkdir();
            try {
                ZipFile.UNZIP(f1, zipfile);
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
                return false;
            }
            files[0] = f1;
            return true;
        }
        return false;
    }
}

