/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilTableCell;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.ui.ArbilFieldViewTable;
import nl.mpi.arbil.ui.ArbilFieldViews;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilTableCellEditor;
import nl.mpi.arbil.ui.ArbilTableCellRenderer;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.ui.JListToolTip;
import nl.mpi.arbil.ui.fieldeditors.ArbilLongFieldEditor;
import nl.mpi.arbil.ui.menu.TableContextMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTable
extends JTable {
    public static final int MIN_COLUMN_WIDTH = 50;
    public static final int MAX_COLUMN_WIDTH = 300;
    private ArbilTableModel arbilTableModel;
    private JListToolTip listToolTip = new JListToolTip();
    private int lastColumnCount = -1;
    private int lastRowCount = -1;
    private int lastColumnPreferedWidth = 0;
    protected boolean allowNodeDrop = true;

    public ArbilTable(ArbilTableModel localArbilTableModel, String frameTitle) {
        this.arbilTableModel = localArbilTableModel;
        this.arbilTableModel.setShowIcons(true);
        this.setModel(this.arbilTableModel);
        this.setName(frameTitle);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(2);
        this.setGridColor(Color.LIGHT_GRAY);
        this.initHeaderMouseListener();
        this.initTableMouseListener();
    }

    private void initTableMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ArbilTable.this.checkPopup(evt, true);
            }

            public void mouseReleased(MouseEvent evt) {
                ArbilTable.this.checkPopup(evt, true);
            }
        });
    }

    private void initHeaderMouseListener() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                this.checkTableHeaderPopup(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                this.checkTableHeaderPopup(evt);
            }

            public void mouseClicked(MouseEvent evt) {
                System.out.println("mouseClicked");
                System.out.println("table header click");
                if (evt.getButton() == 1) {
                    ArbilTable.this.arbilTableModel.sortByColumn(ArbilTable.this.convertColumnIndexToModel(((JTableHeader)evt.getComponent()).columnAtPoint(new Point(evt.getX(), evt.getY()))));
                }
                this.checkTableHeaderPopup(evt);
            }

            private void checkTableHeaderPopup(MouseEvent evt) {
                ArbilTable.this.handleTableHeaderPopup(evt);
            }
        });
    }

    private void handleTableHeaderPopup(MouseEvent evt) {
        if (!this.arbilTableModel.hideContextMenuAndStatusBar && evt.isPopupTrigger()) {
            final int targetColumn = this.convertColumnIndexToModel(((JTableHeader)evt.getComponent()).columnAtPoint(new Point(evt.getX(), evt.getY())));
            final String targetColumnName = this.arbilTableModel.getColumnName(targetColumn);
            System.out.println("columnIndex: " + targetColumn);
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem saveViewMenuItem = new JMenuItem("Save Current Column View");
            saveViewMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        String fieldViewName = JOptionPane.showInputDialog(null, "Enter a name to save this Column View as", "Save Column View", -1);
                        if (fieldViewName != null) {
                            ArbilTable.this.updateStoredColumnWidhts();
                            if (!ArbilFieldViews.getSingleInstance().addArbilFieldView(fieldViewName, ArbilTable.this.arbilTableModel.getFieldView())) {
                                ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("A Column View with the same name already exists, nothing saved", "Save Column View");
                            }
                        }
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                }
            });
            JMenuItem editViewMenuItem = new JMenuItem("Edit this Column View");
            editViewMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ArbilTable.this.updateStoredColumnWidhts();
                    try {
                        ArbilFieldViewTable fieldViewTable = new ArbilFieldViewTable(ArbilTable.this.arbilTableModel);
                        JDialog editViewsDialog = new JDialog(JOptionPane.getFrameForComponent(ArbilWindowManager.getSingleInstance().linorgFrame), true);
                        editViewsDialog.setTitle("Editing Current Column View");
                        JScrollPane js = new JScrollPane(fieldViewTable);
                        editViewsDialog.getContentPane().add(js);
                        editViewsDialog.setBounds(50, 50, 600, 400);
                        editViewsDialog.setVisible(true);
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                }
            });
            JMenuItem showOnlyCurrentViewMenuItem = new JMenuItem("Limit View to Current Columns");
            showOnlyCurrentViewMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        ArbilTable.this.arbilTableModel.showOnlyCurrentColumns();
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                }
            });
            JMenu fieldViewsMenuItem = new JMenu("Column View for this Table");
            ButtonGroup viewMenuButtonGroup = new ButtonGroup();
            Enumeration savedViewsEnum = ArbilFieldViews.getSingleInstance().getSavedFieldViewLables();
            while (savedViewsEnum.hasMoreElements()) {
                String currentViewLabel = savedViewsEnum.nextElement().toString();
                JMenuItem viewLabelMenuItem = new JMenuItem();
                viewMenuButtonGroup.add(viewLabelMenuItem);
                viewLabelMenuItem.setText(currentViewLabel);
                viewLabelMenuItem.setName(currentViewLabel);
                viewLabelMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            ArbilTable.this.arbilTableModel.setCurrentView(ArbilFieldViews.getSingleInstance().getView(((Component)evt.getSource()).getName()));
                            ArbilTable.this.doResizeColumns();
                        }
                        catch (Exception ex) {
                            GuiHelper.linorgBugCatcher.logError(ex);
                        }
                    }
                });
                fieldViewsMenuItem.add(viewLabelMenuItem);
            }
            JMenuItem copyEmbedTagMenuItem = new JMenuItem("Copy Table For Website");
            copyEmbedTagMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ArbilTable sizedComponent = ArbilTable.this;
                    Container currentComponent = ArbilTable.this;
                    while (currentComponent.getParent() != null) {
                        if (!((currentComponent = currentComponent.getParent()) instanceof ArbilSplitPanel)) continue;
                        sizedComponent = currentComponent;
                    }
                    ArbilTable.this.arbilTableModel.copyHtmlEmbedTagToClipboard(((Component)sizedComponent).getHeight(), ((Component)sizedComponent).getWidth());
                }
            });
            JMenuItem setAllColumnsSizeFromColumn = new JMenuItem("Make all columns the size of \"" + targetColumnName + "\"");
            setAllColumnsSizeFromColumn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int targetWidth = ArbilTable.this.getColumnModel().getColumn(targetColumn).getWidth();
                    for (int i = 0; i < ArbilTable.this.getColumnCount(); ++i) {
                        TableColumn column = ArbilTable.this.getColumnModel().getColumn(i);
                        ArbilTable.this.arbilTableModel.getFieldView().setColumnWidth(column.getHeaderValue().toString(), targetWidth);
                    }
                    ArbilTable.this.doResizeColumns();
                }
            });
            JMenuItem setAllColumnsSizeAuto = new JMenuItem("Make all columns fit contents");
            setAllColumnsSizeAuto.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ArbilTable.this.arbilTableModel.getFieldView().resetColumnWidths();
                    ArbilTable.this.doResizeColumns();
                }
            });
            JMenuItem setColumnSizeAuto = new JMenuItem("Make column fit contents");
            setColumnSizeAuto.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ArbilTable.this.arbilTableModel.getFieldView().setColumnWidth(targetColumnName, null);
                    ArbilTable.this.doResizeColumns(Arrays.asList(targetColumn));
                }
            });
            final JCheckBoxMenuItem setFixedColumnSize = new JCheckBoxMenuItem("Fixed column size");
            setFixedColumnSize.setSelected(this.arbilTableModel.getPreferredColumnWidth(targetColumnName) != null);
            setFixedColumnSize.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ArbilTable.this.arbilTableModel.getFieldView().setColumnWidth(targetColumnName, setFixedColumnSize.isSelected() ? Integer.valueOf(ArbilTable.this.getColumnModel().getColumn(targetColumn).getWidth()) : null);
                }
            });
            if (this.arbilTableModel.isHorizontalView()) {
                JMenu thisColumnMenu = new JMenu("This column (" + (targetColumnName.trim().length() == 0 ? "nameless" : targetColumnName) + ")");
                thisColumnMenu.add(setFixedColumnSize);
                thisColumnMenu.add(setColumnSizeAuto);
                if (targetColumn != 0) {
                    thisColumnMenu.add(new JSeparator());
                    thisColumnMenu.add(this.createHideColumnMenuItem(targetColumn));
                }
                JMenu allColumnsMenu = new JMenu("All columns");
                allColumnsMenu.add(setAllColumnsSizeFromColumn);
                allColumnsMenu.add(setAllColumnsSizeAuto);
                popupMenu.add(thisColumnMenu);
                popupMenu.add(allColumnsMenu);
                popupMenu.add(this.createShowChildNodesMenuItem(targetColumn));
                popupMenu.add(new JSeparator());
            }
            popupMenu.add(fieldViewsMenuItem);
            popupMenu.add(saveViewMenuItem);
            popupMenu.add(editViewMenuItem);
            popupMenu.add(showOnlyCurrentViewMenuItem);
            popupMenu.add(new JSeparator());
            popupMenu.add(copyEmbedTagMenuItem);
            popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private JMenuItem createHideColumnMenuItem(final int targetColumn) {
        JMenuItem hideColumnMenuItem = new JMenuItem("Hide Column");
        hideColumnMenuItem.setActionCommand("" + targetColumn);
        hideColumnMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ArbilTable.this.arbilTableModel.hideColumn(targetColumn);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        return hideColumnMenuItem;
    }

    private JMenuItem createShowChildNodesMenuItem(int targetColumn) {
        JMenuItem showChildNodesMenuItem = new JMenuItem();
        showChildNodesMenuItem.setText("Show Child Nodes");
        showChildNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilTable.this.showRowChildData();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        return showChildNodesMenuItem;
    }

    public void checkPopup(MouseEvent evt, boolean checkSelection) {
        if (!this.arbilTableModel.hideContextMenuAndStatusBar && evt.isPopupTrigger()) {
            Point p = evt.getPoint();
            int clickedRow = this.rowAtPoint(p);
            int clickedColumn = this.columnAtPoint(p);
            boolean clickedRowAlreadySelected = this.isRowSelected(clickedRow);
            if (!(!checkSelection || evt.isShiftDown() || evt.isControlDown() || evt.isPopupTrigger() && clickedRowAlreadySelected || !(clickedRow > -1 & clickedRow > -1))) {
                this.getSelectionModel().clearSelection();
                this.changeSelection(clickedRow, clickedColumn, false, evt.isShiftDown());
            }
        }
        if (evt.isPopupTrigger()) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            new TableContextMenu(this).show(evt.getX(), evt.getY());
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    @Override
    public JToolTip createToolTip() {
        this.listToolTip.updateList();
        return this.listToolTip;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int viewcolumn) {
        return new ArbilTableCellEditor();
    }

    @Override
    public ArbilTableCellRenderer getCellRenderer(int row, int viewcolumn) {
        int modelcolumn = this.convertColumnIndexToModel(viewcolumn);
        ArbilTableCellRenderer arbilCellRenderer = new ArbilTableCellRenderer();
        arbilCellRenderer.setBackground(this.arbilTableModel.getCellColour(row, modelcolumn));
        return arbilCellRenderer;
    }

    public void showRowChildData() {
        Object[] possibilities = this.getArbilTableModel().getChildNames();
        String selectionResult = (String)JOptionPane.showInputDialog(ArbilWindowManager.getSingleInstance().linorgFrame, "Select the child node type to display", "Show child nodes", -1, null, possibilities, null);
        if (selectionResult != null && selectionResult.length() > 0) {
            this.getArbilTableModel().addChildTypeToDisplay(selectionResult);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.setColumnWidths();
    }

    @Override
    public int getRowHeight() {
        try {
            if (this.getGraphics() != null) {
                FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
                int requiredHeight = fontMetrics.getHeight();
                return requiredHeight;
            }
        }
        catch (Exception exception) {
            System.out.println("getRowHeight could not get the font metrics, using the default row height");
        }
        return super.getRowHeight();
    }

    public void setColumnWidths() {
        boolean resizeColumns = this.arbilTableModel.isWidthsChanged() || this.lastColumnCount != this.getModel().getColumnCount() || this.lastRowCount != this.getModel().getRowCount();
        this.lastColumnCount = this.getModel().getColumnCount();
        this.lastRowCount = this.getModel().getRowCount();
        int parentWidth = this.getParent().getWidth();
        if (this.getRowCount() > 0 && this.getColumnCount() > 2) {
            if (resizeColumns) {
                this.doResizeColumns();
            } else if (this.getParent() != null) {
                boolean lastcolumnSquished;
                int lastColumnWidth = this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1).getWidth();
                int totalColWidth = this.getColumnModel().getTotalColumnWidth();
                boolean bl = lastcolumnSquished = lastColumnWidth < 50;
                if (parentWidth > totalColWidth) {
                    this.setAutoResizeMode(2);
                } else if (parentWidth < totalColWidth) {
                    this.setAutoResizeMode(0);
                } else if (lastcolumnSquished) {
                    this.setAutoResizeMode(0);
                    this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1).setPreferredWidth(this.lastColumnPreferedWidth);
                }
            }
        } else {
            this.setAutoResizeMode(4);
        }
    }

    private void doResizeColumns() {
        this.doResizeColumns(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResizeColumns(Collection<Integer> columnsToResize) {
        this.setAutoResizeMode(0);
        ArbilTableCellRenderer arbilCellRenderer = new ArbilTableCellRenderer();
        int totalColumnWidth = 0;
        int columnCount = this.getColumnModel().getColumnCount();
        Graphics g = this.getGraphics();
        try {
            FontMetrics fontMetrics = g.getFontMetrics();
            for (int columnCounter = 0; columnCounter < columnCount; ++columnCounter) {
                int currentWidth;
                TableColumn tableColumn = this.getColumnModel().getColumn(columnCounter);
                if (columnsToResize == null || columnsToResize.contains(columnCounter)) {
                    currentWidth = 50;
                    Integer storedColumnWidth = this.arbilTableModel.getPreferredColumnWidth(tableColumn.getHeaderValue().toString());
                    if (storedColumnWidth != null) {
                        currentWidth = storedColumnWidth;
                    } else {
                        for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
                            arbilCellRenderer.setValue(this.arbilTableModel.getTableCellAt(rowCounter, this.convertColumnIndexToModel(columnCounter)));
                            int requiredWidth = arbilCellRenderer.getRequiredWidth(fontMetrics);
                            if (currentWidth >= requiredWidth) continue;
                            currentWidth = requiredWidth;
                        }
                        if (currentWidth > 300) {
                            currentWidth = 300;
                        }
                    }
                } else {
                    currentWidth = tableColumn.getWidth();
                }
                tableColumn.setPreferredWidth(currentWidth);
                tableColumn.setWidth(currentWidth);
                totalColumnWidth += tableColumn.getWidth();
                this.lastColumnPreferedWidth = currentWidth;
            }
            if (this.getParent().getWidth() > totalColumnWidth) {
                this.setAutoResizeMode(2);
            } else {
                this.setAutoResizeMode(0);
            }
        }
        finally {
            g.dispose();
            this.arbilTableModel.setWidthsChanged(false);
        }
    }

    public void updateStoredColumnWidhts() {
        ArbilFieldView fieldView = this.arbilTableModel.getFieldView();
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            String columnName = column.getHeaderValue().toString();
            if (!fieldView.hasColumnWidthForColumn(columnName)) continue;
            fieldView.setColumnWidth(columnName, column.getWidth());
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tip = null;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        if (rowIndex >= 0 && colIndex >= 0) {
            tip = this.getTableCellContentAt(rowIndex, colIndex).toString();
            this.listToolTip.setTartgetObject(this.getTableCellContentAt(rowIndex, colIndex));
        } else {
            this.listToolTip.setTartgetObject(null);
        }
        return tip;
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.arbilTableModel.isHorizontalView()) {
            boolean rowSelection = this.arbilTableModel.getTableCellContentAt(rowIndex, columnIndex) instanceof ArbilDataNode;
            if (!this.arbilTableModel.isHorizontalView()) {
                this.setRowSelectionAllowed(true);
                this.setColumnSelectionAllowed(false);
            } else if (rowSelection) {
                this.getSelectionModel().setSelectionMode(2);
                this.setRowSelectionAllowed(true);
                this.setColumnSelectionAllowed(false);
            } else {
                this.setRowSelectionAllowed(true);
                this.setColumnSelectionAllowed(true);
                this.getSelectionModel().setSelectionMode(1);
            }
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        } else {
            KeyEvent nextPress;
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            Toolkit.getDefaultToolkit().getSystemEventQueue();
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof KeyEvent && currentEvent != null && (nextPress = (KeyEvent)currentEvent).isShiftDown() && --rowIndex < 0) {
                rowIndex = this.getRowCount() - 1;
            }
            super.changeSelection(rowIndex, 1, toggle, extend);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            public String getToolTipText(MouseEvent e) {
                Object tip = null;
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                return ArbilTable.this.getColumnName(index);
            }
        };
    }

    public void copySelectedTableRowsToClipBoard() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length > 0) {
            boolean allCellsSelected;
            System.out.println("coll select mode: " + this.getColumnSelectionAllowed());
            System.out.println("cell select mode: " + this.getCellSelectionEnabled());
            boolean bl = allCellsSelected = this.getSelectedRowCount() == this.getRowCount() && this.getSelectedColumnCount() == this.getColumnCount();
            if (this.getCellSelectionEnabled() && !allCellsSelected) {
                System.out.println("cell select mode");
                ArbilField[] selectedFields = this.getSelectedFields();
                if (selectedFields != null) {
                    this.arbilTableModel.copyArbilFields(selectedFields);
                }
            } else {
                System.out.println("row select mode");
                this.arbilTableModel.copyArbilRows(selectedRows);
            }
        } else {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Nothing selected to copy", "Table Copy");
        }
    }

    public void startLongFieldEditorForSelectedFields() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length > 0) {
            int[] selectedCols;
            if (this.getCellSelectionEnabled()) {
                selectedCols = this.getSelectedColumns();
            } else {
                selectedCols = new int[this.getColumnCount()];
                for (int colCounter = 0; colCounter < selectedCols.length; ++colCounter) {
                    selectedCols[colCounter] = colCounter;
                }
            }
            for (int currentRow : selectedRows) {
                if (this.arbilTableModel.isHorizontalView() && this.getSelectionModel().getSelectionMode() == 2 && this.getSelectedColumnCount() > 0) {
                    ArbilDataNode node;
                    Object currentCellValue = this.getTableCellContentAt(currentRow, this.getSelectedColumns()[0]);
                    if (!(currentCellValue instanceof ArbilDataNode) || (node = (ArbilDataNode)currentCellValue).getFields().size() <= 0) continue;
                    List<ArbilField[]> fieldArrays = node.getFieldsSorted();
                    new ArbilLongFieldEditor(this).showEditor(fieldArrays.get(0), fieldArrays.get(0)[0].getFieldValue(), 0);
                    continue;
                }
                for (int currentCol : selectedCols) {
                    Object currentCellValue = this.getTableCellContentAt(currentRow, currentCol);
                    if (!(currentCellValue instanceof ArbilField) && !(currentCellValue instanceof ArbilField[])) continue;
                    new ArbilTableCellEditor().startLongfieldEditor(this, this.getTableCellAt(currentRow, currentCol), false, currentRow, currentCol);
                }
            }
        }
    }

    public ArbilField[] getSelectedFields() {
        HashSet<ArbilField> selectedFields = new HashSet<ArbilField>();
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length > 0) {
            int[] selectedCols;
            if (this.getCellSelectionEnabled()) {
                selectedCols = this.getSelectedColumns();
            } else {
                selectedCols = new int[this.getColumnCount()];
                for (int colCounter = 0; colCounter < selectedCols.length; ++colCounter) {
                    selectedCols[colCounter] = colCounter;
                }
            }
            for (int currentRow : selectedRows) {
                for (int currentCol : selectedCols) {
                    if (this.getTableCellContentAt(currentRow, currentCol) instanceof ArbilField) {
                        selectedFields.add((ArbilField)this.getTableCellContentAt(currentRow, currentCol));
                        continue;
                    }
                    if (!(this.getTableCellContentAt(currentRow, currentCol) instanceof ArbilField[])) continue;
                    for (ArbilField currentField : (ArbilField[])this.getTableCellContentAt(currentRow, currentCol)) {
                        selectedFields.add(currentField);
                    }
                }
            }
            return selectedFields.toArray(new ArbilField[0]);
        }
        return null;
    }

    public void pasteIntoSelectedTableRowsFromClipBoard() {
        ArbilField[] selectedFields = this.getSelectedFields();
        if (selectedFields != null) {
            String pasteResult = this.arbilTableModel.pasteIntoArbilFields(selectedFields);
            if (pasteResult != null) {
                ArbilWindowManager.getSingleInstance().addMessageDialogToQueue(pasteResult, "Paste into Table");
            }
        } else {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("No rows selected", "Paste into Table");
        }
    }

    public void viewSelectedTableRows() {
        int[] selectedRows = this.getSelectedRows();
        ArbilWindowManager.getSingleInstance().openFloatingTableOnce(this.arbilTableModel.getSelectedDataNodes(selectedRows), null);
    }

    public ArbilDataNode getDataNodeForSelection() {
        Object cellValue = this.arbilTableModel.getTableCellContentAt(this.getSelectedRow(), this.getSelectedColumn());
        ArbilDataNode cellDataNode = null;
        if (cellValue instanceof ArbilField) {
            cellDataNode = ((ArbilField)cellValue).getParentDataNode();
        } else if (cellValue instanceof ArbilField[]) {
            cellDataNode = ((ArbilField[])cellValue)[0].getParentDataNode();
        } else if (cellValue instanceof ArbilDataNode) {
            cellDataNode = (ArbilDataNode)cellValue;
        } else if (cellValue instanceof ArbilDataNode[]) {
            cellDataNode = ((ArbilDataNode[])cellValue)[0];
        }
        return cellDataNode;
    }

    public ArbilDataNode[] getSelectedRowsFromTable() {
        int[] selectedRows = this.getSelectedRows();
        return this.arbilTableModel.getSelectedDataNodes(selectedRows);
    }

    public void hideSelectedColumnsFromTable() {
        int[] selectedColumns = this.getSelectedColumns();
        Integer[] selectedModelColumns = new Integer[selectedColumns.length];
        for (int columnCounter = 0; columnCounter < selectedColumns.length; ++columnCounter) {
            selectedModelColumns[columnCounter] = this.convertColumnIndexToModel(selectedColumns[columnCounter]);
        }
        Arrays.sort(selectedModelColumns, Collections.reverseOrder());
        Integer[] arr$ = selectedModelColumns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int selectedModelCol = arr$[i$];
            this.arbilTableModel.hideColumn(selectedModelCol);
        }
    }

    public void removeSelectedRowsFromTable() {
        int[] selectedRows = this.getSelectedRows();
        this.arbilTableModel.removeArbilDataNodeRows(selectedRows);
    }

    public void highlightMatchingRows() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("No rows have been selected", "Highlight Matching Rows");
            return;
        }
        Vector foundRows = this.arbilTableModel.getMatchingRows(selectedRow);
        this.getSelectionModel().setSelectionMode(2);
        this.getSelectionModel().clearSelection();
        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Found " + foundRows.size() + " matching rows", "Highlight Matching Rows");
        for (int foundCount = 0; foundCount < foundRows.size(); ++foundCount) {
            for (int coloumCount = 0; coloumCount < this.getColumnCount(); ++coloumCount) {
                this.getSelectionModel().addSelectionInterval((Integer)foundRows.get(foundCount), (Integer)foundRows.get(foundCount));
            }
        }
    }

    public ArbilTableModel getArbilTableModel() {
        return this.arbilTableModel;
    }

    public ArbilTableCell getTableCellAt(int row, int col) {
        Object object = this.getValueAt(row, col);
        if (object instanceof ArbilTableCell) {
            return (ArbilTableCell)object;
        }
        return null;
    }

    public Object getTableCellContentAt(int row, int col) {
        ArbilTableCell cell = this.getTableCellAt(row, col);
        return cell != null ? cell.getContent() : null;
    }

    public boolean isAllowNodeDrop() {
        return this.allowNodeDrop;
    }

    public void setAllowNodeDrop(boolean allowNodeDrop) {
        this.allowNodeDrop = allowNodeDrop;
    }
}

