/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Container;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Hashtable;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilRootNode;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.templates.ArbilFavourites;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.ui.ImportExportDialog;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;

public class ArbilDragDrop {
    private static ArbilDragDrop singleInstance = null;
    private DataFlavor dataNodeFlavour = new DataFlavor(ArbilDataNode.class, "ArbilDataNode");
    private ArbilNodeSelection arbilNodeSelection = new ArbilNodeSelection();

    public static synchronized ArbilDragDrop getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilDragDrop();
        }
        return singleInstance;
    }

    private ArbilDragDrop() {
    }

    public void addDrag(JTable tableSource) {
        tableSource.setDragEnabled(true);
        this.setTransferHandlerOnComponent(tableSource);
    }

    public void addDrag(JTree treeSource) {
        treeSource.setDragEnabled(true);
        this.setTransferHandlerOnComponent(treeSource);
        treeSource.addTreeSelectionListener(this.arbilNodeSelection);
        DropTarget target = treeSource.getDropTarget();
        try {
            target.addDropTargetListener(new DropTargetAdapter(){

                public void dragOver(DropTargetDragEvent dtdEvent) {
                    System.out.println("arbilNodeSelection.dropAllowed: " + ((ArbilDragDrop)ArbilDragDrop.this).arbilNodeSelection.dropAllowed);
                    if (((ArbilDragDrop)ArbilDragDrop.this).arbilNodeSelection.dropAllowed) {
                        dtdEvent.acceptDrag(dtdEvent.getDropAction());
                    } else {
                        dtdEvent.rejectDrag();
                    }
                }

                public void drop(DropTargetDropEvent e) {
                }
            });
        }
        catch (TooManyListenersException ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    public void addDrag(JList listSource) {
        listSource.setDragEnabled(true);
        this.setTransferHandlerOnComponent(listSource);
    }

    public void setTransferHandlerOnComponent(JComponent targetComponent) {
        targetComponent.setTransferHandler(this.arbilNodeSelection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArbilNodeSelection
    extends TransferHandler
    implements Transferable,
    TreeSelectionListener {
        long dragStartMilliSeconds;
        DataFlavor[] flavors;
        ArbilDataNode[] draggedArbilNodes;
        DefaultMutableTreeNode[] draggedTreeNodes;
        private boolean selectionDraggedFromLocalCorpus;
        private boolean selectionContainsArchivableLocalFile;
        private boolean selectionContainsLocalFile;
        private boolean selectionContainsLocalDirectory;
        private boolean selectionContainsArbilResource;
        private boolean selectionContainsArbilCorpus;
        private boolean selectionContainsImdiCatalogue;
        private boolean selectionContainsImdiSession;
        private boolean selectionContainsCmdiMetadata;
        private boolean selectionContainsArbilChild;
        private boolean selectionContainsLocal;
        private boolean selectionContainsRemote;
        private boolean selectionContainsFavourite;
        private JComponent currentDropTarget;
        protected boolean dropAllowed;

        private ArbilNodeSelection() {
            this.flavors = new DataFlavor[]{ArbilDragDrop.this.dataNodeFlavour};
            this.selectionDraggedFromLocalCorpus = false;
            this.selectionContainsArchivableLocalFile = false;
            this.selectionContainsLocalFile = false;
            this.selectionContainsLocalDirectory = false;
            this.selectionContainsArbilResource = false;
            this.selectionContainsArbilCorpus = false;
            this.selectionContainsImdiCatalogue = false;
            this.selectionContainsImdiSession = false;
            this.selectionContainsCmdiMetadata = false;
            this.selectionContainsArbilChild = false;
            this.selectionContainsLocal = false;
            this.selectionContainsRemote = false;
            this.selectionContainsFavourite = false;
            this.currentDropTarget = null;
            this.dropAllowed = false;
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            if (evt.getSource() == this.currentDropTarget) {
                System.out.println("Drag target selection change: " + evt.getSource().toString());
                if (evt.getSource() instanceof ArbilTree) {
                    this.dropAllowed = this.canDropToTarget((ArbilTree)evt.getSource());
                }
            }
        }

        private boolean canDropToTarget(ArbilTree dropTree) {
            ArbilNode currentLeadSelection = dropTree.getLeadSelectionNode();
            if (currentLeadSelection instanceof ArbilRootNode) {
                if (ArbilTreeHelper.getSingleInstance().componentIsTheFavouritesTree(this.currentDropTarget)) {
                    System.out.println("favourites tree check");
                    return !this.selectionContainsFavourite;
                }
                if (ArbilTreeHelper.getSingleInstance().componentIsTheLocalCorpusTree(this.currentDropTarget)) {
                    System.out.println("local corpus tree check");
                    return this.selectionContainsFavourite && !this.draggedNodesContainsChildNode() || this.selectionContainsArbilCorpus || this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession || this.selectionContainsCmdiMetadata;
                }
                System.out.println("no tree check");
            } else if (currentLeadSelection instanceof ArbilDataNode) {
                System.out.println("currentLeadSelection: " + currentLeadSelection.toString());
                if (ArbilTreeHelper.getSingleInstance().componentIsTheLocalCorpusTree(this.currentDropTarget)) {
                    if (currentLeadSelection.isCmdiMetaDataNode()) {
                        return ((ArbilDataNode)currentLeadSelection).canHaveResource();
                    }
                    if (((ArbilDataNode)currentLeadSelection).isDirectory) {
                        return false;
                    }
                    if (currentLeadSelection.isCorpus()) {
                        if ((this.selectionContainsArbilCorpus || this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession) && !this.selectionContainsCmdiMetadata) {
                            return true;
                        }
                    } else {
                        if (currentLeadSelection.isCatalogue()) {
                            return false;
                        }
                        if (currentLeadSelection.isSession() ? this.selectionContainsArchivableLocalFile || this.selectionContainsArbilChild : (currentLeadSelection.isEmptyMetaNode() ? this.selectionContainsArbilChild : currentLeadSelection.isChildNode() && (this.selectionContainsLocalFile || this.selectionContainsArbilChild && this.selectionContainsFavourite))) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            System.out.println("exportToClipboard: " + comp);
            this.createTransferable(null);
            if (comp instanceof ArbilTree) {
                ArbilTree sourceTree = (ArbilTree)comp;
                ArbilDataNode[] selectedArbilDataNodes = sourceTree.getSelectedNodes();
                if (selectedArbilDataNodes != null) {
                    sourceTree.copyNodeUrlToClipboard(selectedArbilDataNodes);
                }
            } else if (comp instanceof ArbilTable) {
                ArbilTable sourceTable = (ArbilTable)comp;
                sourceTable.copySelectedTableRowsToClipBoard();
            } else {
                super.exportToClipboard(comp, clip, action);
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            if (c instanceof JTree || c instanceof JTable || c instanceof JList) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] flavor) {
            System.out.println("canImport: " + comp);
            this.currentDropTarget = null;
            this.dropAllowed = false;
            if (comp instanceof JTree) {
                if (ArbilTreeHelper.getSingleInstance().componentIsTheLocalCorpusTree(comp)) {
                    System.out.println("localcorpustree so can drop here");
                    if (this.selectionContainsArchivableLocalFile || this.selectionContainsArbilCorpus || this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession || this.selectionContainsCmdiMetadata || this.selectionContainsArbilChild) {
                        System.out.println("dragged contents are acceptable");
                        this.currentDropTarget = comp;
                        this.dropAllowed = comp instanceof ArbilTree && this.canDropToTarget((ArbilTree)comp);
                        return true;
                    }
                }
                if (ArbilTreeHelper.getSingleInstance().componentIsTheFavouritesTree(comp)) {
                    System.out.println("favourites tree so can drop here");
                    if (this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession || this.selectionContainsCmdiMetadata || this.selectionContainsArbilChild) {
                        System.out.println("dragged contents are acceptable");
                        this.currentDropTarget = comp;
                        this.dropAllowed = this.canDropToTarget((ArbilTree)comp);
                        return true;
                    }
                }
            } else {
                if (comp instanceof ArbilTable) {
                    return ((ArbilTable)comp).isAllowNodeDrop();
                }
                this.dropAllowed = null != this.findArbilDropableTarget(comp);
                System.out.println("dropAllowed: " + this.dropAllowed);
                return this.dropAllowed;
            }
            System.out.println("canImport false");
            return false;
        }

        private Container findArbilDropableTarget(Container tempCom) {
            while (tempCom != null) {
                if (tempCom instanceof ArbilSplitPanel || tempCom instanceof JDesktopPane) {
                    System.out.println("canImport true");
                    return tempCom;
                }
                tempCom = tempCom.getParent();
            }
            return null;
        }

        @Override
        public Transferable createTransferable(JComponent comp) {
            this.dragStartMilliSeconds = System.currentTimeMillis();
            this.draggedArbilNodes = null;
            this.draggedTreeNodes = null;
            this.selectionDraggedFromLocalCorpus = false;
            this.selectionContainsArchivableLocalFile = false;
            this.selectionContainsLocalFile = false;
            this.selectionContainsLocalDirectory = false;
            this.selectionContainsArbilResource = false;
            this.selectionContainsArbilCorpus = false;
            this.selectionContainsImdiCatalogue = false;
            this.selectionContainsImdiSession = false;
            this.selectionContainsCmdiMetadata = false;
            this.selectionContainsArbilChild = false;
            this.selectionContainsLocal = false;
            this.selectionContainsRemote = false;
            this.selectionContainsFavourite = false;
            if (comp instanceof ArbilTree) {
                ArbilTree draggedTree = (ArbilTree)comp;
                if (draggedTree.getSelectionCount() <= 1 && (draggedTree.getSelectionCount() != 1 || draggedTree.getSelectionPath().getPathCount() <= 1)) {
                    return null;
                }
                this.draggedArbilNodes = new ArbilDataNode[draggedTree.getSelectionCount()];
                this.draggedTreeNodes = new DefaultMutableTreeNode[draggedTree.getSelectionCount()];
                for (int selectedCount = 0; selectedCount < draggedTree.getSelectionCount(); ++selectedCount) {
                    DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)draggedTree.getSelectionPaths()[selectedCount].getLastPathComponent();
                    if (parentNode.getUserObject() instanceof ArbilDataNode) {
                        this.draggedArbilNodes[selectedCount] = (ArbilDataNode)parentNode.getUserObject();
                        this.draggedTreeNodes[selectedCount] = parentNode;
                        continue;
                    }
                    this.draggedArbilNodes[selectedCount] = null;
                    this.draggedTreeNodes[selectedCount] = null;
                }
                this.classifyTransferableContents();
                return this;
            }
            if (comp instanceof ArbilTable) {
                this.draggedArbilNodes = ((ArbilTable)comp).getSelectedRowsFromTable();
                this.classifyTransferableContents();
                return this;
            }
            if (comp instanceof JList) {
                Object[] selectedValues = ((JList)comp).getSelectedValues();
                this.draggedArbilNodes = new ArbilDataNode[selectedValues.length];
                for (int selectedNodeCounter = 0; selectedNodeCounter < selectedValues.length; ++selectedNodeCounter) {
                    if (!(selectedValues[selectedNodeCounter] instanceof ArbilDataNode)) continue;
                    this.draggedArbilNodes[selectedNodeCounter] = (ArbilDataNode)selectedValues[selectedNodeCounter];
                }
                this.classifyTransferableContents();
                return this;
            }
            return null;
        }

        private void classifyTransferableContents() {
            System.out.println("classifyTransferableContents");
            for (ArbilDataNode currentDraggedObject : this.draggedArbilNodes) {
                if (currentDraggedObject == null) continue;
                if (currentDraggedObject.isLocal()) {
                    this.selectionContainsLocal = true;
                    System.out.println("selectionContainsLocal");
                    if (currentDraggedObject.isDirectory()) {
                        this.selectionContainsLocalDirectory = true;
                        System.out.println("selectionContainsLocalDirectory");
                    } else if (!currentDraggedObject.isMetaDataNode()) {
                        this.selectionContainsLocalFile = true;
                        System.out.println("selectionContainsLocalFile");
                        if (currentDraggedObject.isArchivableFile()) {
                            this.selectionContainsArchivableLocalFile = true;
                            System.out.println("selectionContainsArchivableLocalFile");
                        }
                    }
                } else {
                    this.selectionContainsRemote = true;
                    System.out.println("selectionContainsRemote");
                }
                if (!currentDraggedObject.isMetaDataNode()) continue;
                if (currentDraggedObject.isChildNode()) {
                    this.selectionContainsArbilChild = true;
                    System.out.println("selectionContainsImdiChild");
                    if (currentDraggedObject.hasResource()) {
                        this.selectionContainsArbilResource = true;
                        System.out.println("selectionContainsImdiResource");
                    }
                } else if (currentDraggedObject.isSession()) {
                    this.selectionContainsImdiSession = true;
                    System.out.println("selectionContainsImdiSession");
                } else if (currentDraggedObject.isCmdiMetaDataNode()) {
                    this.selectionContainsCmdiMetadata = true;
                    System.out.println("selectionContainsCmdiMetadata");
                } else if (currentDraggedObject.isCatalogue()) {
                    this.selectionContainsImdiCatalogue = true;
                    System.out.println("selectionContainsImdiCatalogue");
                } else if (currentDraggedObject.isCorpus()) {
                    this.selectionContainsArbilCorpus = true;
                    System.out.println("selectionContainsImdiCorpus");
                }
                if (!currentDraggedObject.isFavorite()) continue;
                this.selectionContainsFavourite = true;
                System.out.println("selectionContainsFavourite");
            }
            this.selectionDraggedFromLocalCorpus = this.draggedFromLocalCorpus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (System.currentTimeMillis() - this.dragStartMilliSeconds < 100L) {
                return false;
            }
            try {
                System.out.println("importData: " + comp.toString());
                if (comp instanceof ArbilTable && this.draggedArbilNodes == null) {
                    ((ArbilTable)comp).pasteIntoSelectedTableRowsFromClipBoard();
                } else if (this.draggedArbilNodes != null) {
                    boolean bl = this.importNodes(comp);
                    return bl;
                }
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
            finally {
                this.createTransferable(null);
            }
            return false;
        }

        private boolean importNodes(JComponent comp) {
            if (comp instanceof ArbilTree && this.canDropToTarget((ArbilTree)comp)) {
                return this.importToTree((ArbilTree)comp);
            }
            Container target = this.findArbilDropableTarget(comp);
            if (target instanceof ArbilSplitPanel) {
                ArbilSplitPanel targetPanel = (ArbilSplitPanel)target;
                targetPanel.arbilTable.updateStoredColumnWidhts();
                ArbilTableModel dropTableModel = targetPanel.arbilTable.getArbilTableModel();
                dropTableModel.addArbilDataNodes(this.draggedArbilNodes);
                return true;
            }
            if (target instanceof JDesktopPane) {
                ArbilWindowManager.getSingleInstance().openFloatingTableOnce(this.draggedArbilNodes, null);
                return true;
            }
            return false;
        }

        private boolean importToTree(ArbilTree dropTree) {
            for (int draggedCounter = 0; draggedCounter < this.draggedArbilNodes.length; ++draggedCounter) {
                System.out.println("dragged: " + this.draggedArbilNodes[draggedCounter].toString());
            }
            if (ArbilTreeHelper.getSingleInstance().componentIsTheFavouritesTree(this.currentDropTarget)) {
                boolean resultValue = ArbilFavourites.getSingleInstance().toggleFavouritesList(this.draggedArbilNodes, true);
                return resultValue;
            }
            return this.importToLocalTree(dropTree);
        }

        private boolean draggedFromLocalCorpus() {
            if (this.draggedTreeNodes != null && this.draggedTreeNodes.length > 0) {
                return this.draggedTreeNodes[0].getRoot() == ArbilTreeHelper.getSingleInstance().getLocalCorpusTreeModel().getRoot();
            }
            return false;
        }

        private boolean draggedNodesContainsChildNode() {
            if (this.draggedTreeNodes != null) {
                for (DefaultMutableTreeNode node : this.draggedTreeNodes) {
                    if (!(node.getUserObject() instanceof ArbilNode) || !((ArbilNode)node.getUserObject()).isChildNode()) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean importToLocalTree(ArbilTree dropTree) {
            ArbilDataNode dropTargetDataNode;
            DefaultMutableTreeNode targetNode = ArbilTreeHelper.getSingleInstance().getLocalCorpusTreeSingleSelection();
            Object dropTargetUserObject = targetNode.getUserObject();
            Vector<ArbilDataNode> importNodeList = new Vector<ArbilDataNode>();
            Hashtable<ArbilDataNode, Vector<ArbilDataNode>> arbilNodesDeleteList = new Hashtable<ArbilDataNode, Vector<ArbilDataNode>>();
            System.out.println("to: " + dropTargetUserObject.toString());
            if (!(dropTargetUserObject instanceof ArbilNode)) {
                return false;
            }
            ArbilNode dropTargetNode = (ArbilNode)dropTargetUserObject;
            ArbilDataNode arbilDataNode = dropTargetDataNode = dropTargetNode instanceof ArbilDataNode ? (ArbilDataNode)dropTargetNode : null;
            if (dropTargetDataNode != null && (dropTargetDataNode.getParentDomNode().isCmdiMetaDataNode() && !this.selectionDraggedFromLocalCorpus || dropTargetDataNode.isSession() || ".METATRANSCRIPT.Session.Resources.MediaFile".equals(dropTargetDataNode.getURI().getFragment())) && this.selectionContainsArchivableLocalFile && this.selectionContainsLocalFile && !this.selectionContainsLocalDirectory && !this.selectionContainsArbilResource && !this.selectionContainsArbilCorpus && !this.selectionContainsImdiSession && !this.selectionContainsArbilChild && this.selectionContainsLocal && !this.selectionContainsRemote) {
                System.out.println("ok to add local file");
                System.out.println("dragged: " + this.draggedArbilNodes.toString());
                new MetadataBuilder().requestAddNodes(dropTargetDataNode, "Resource", this.draggedArbilNodes);
                return true;
            }
            if (!(this.selectionContainsArchivableLocalFile && !this.selectionDraggedFromLocalCorpus || this.selectionContainsLocalDirectory || this.selectionContainsArbilResource || this.selectionContainsArbilCorpus && this.selectionContainsImdiSession)) {
                System.out.println("ok to move local IMDI");
                boolean moveMultiple = this.draggedArbilNodes.length > 1;
                boolean moveAll = false;
                boolean continueMove = true;
                for (int draggedCounter = 0; continueMove && draggedCounter < this.draggedArbilNodes.length; ++draggedCounter) {
                    ArbilDataNode currentNode = this.draggedArbilNodes[draggedCounter];
                    System.out.println("dragged: " + currentNode.toString());
                    if (currentNode.isChildNode() && (dropTargetDataNode == null || !MetadataReader.getSingleInstance().nodeCanExistInNode(dropTargetDataNode, currentNode))) continue;
                    boolean draggedIntoSelf = false;
                    for (DefaultMutableTreeNode ancestorNode = targetNode; ancestorNode != null; ancestorNode = (DefaultMutableTreeNode)ancestorNode.getParent()) {
                        if (!this.draggedTreeNodes[draggedCounter].equals(ancestorNode)) continue;
                        draggedIntoSelf = true;
                        System.out.println("found ancestor: " + this.draggedTreeNodes[draggedCounter] + ":" + ancestorNode);
                    }
                    if (draggedIntoSelf) continue;
                    if (currentNode.isFavorite()) {
                        if (dropTargetNode instanceof ArbilRootNode) {
                            new MetadataBuilder().requestAddRootNode(currentNode, currentNode.toString());
                            continue;
                        }
                        if (dropTargetDataNode != null) {
                            new MetadataBuilder().requestAddNode(dropTargetDataNode, currentNode.toString(), currentNode);
                            continue;
                        }
                        GuiHelper.linorgBugCatcher.logError("Cannot handle node type for drag/drop: " + dropTargetNode.getClass().toString(), null);
                        continue;
                    }
                    if (!(this.draggedFromLocalCorpus() || currentNode.isLocal() && ArbilSessionStorage.getSingleInstance().pathIsInsideCache(currentNode.getFile()))) {
                        importNodeList.add(currentNode);
                        continue;
                    }
                    String targetNodeName = dropTargetNode.toString();
                    int detailsOption = 1;
                    if (!moveAll) {
                        Object[] objectArray;
                        JFrame jFrame = ArbilWindowManager.getSingleInstance().linorgFrame;
                        String string = "Move " + this.draggedTreeNodes[draggedCounter].getUserObject().toString() + " to " + targetNodeName;
                        if (moveMultiple) {
                            Object[] objectArray2 = new Object[4];
                            objectArray2[0] = "Move";
                            objectArray2[1] = "Move all";
                            objectArray2[2] = "Skip";
                            objectArray = objectArray2;
                            objectArray2[3] = "Abort";
                        } else {
                            Object[] objectArray3 = new Object[2];
                            objectArray3[0] = "Move";
                            objectArray = objectArray3;
                            objectArray3[1] = "Cancel";
                        }
                        detailsOption = JOptionPane.showOptionDialog(jFrame, string, "Arbil", -1, -1, null, objectArray, moveMultiple ? "Skip" : "Cancel");
                        moveAll = moveMultiple && detailsOption == 1;
                        boolean bl = continueMove = !moveMultiple || detailsOption != 3;
                    }
                    if (!continueMove || !moveAll && detailsOption != 0) continue;
                    this.doMoveLocalNodes(dropTargetUserObject, dropTargetDataNode, currentNode, draggedCounter, arbilNodesDeleteList);
                }
                if (importNodeList.size() > 0) {
                    try {
                        ImportExportDialog importExportDialog = new ImportExportDialog(dropTree);
                        if (dropTargetDataNode != null) {
                            importExportDialog.setDestinationNode(dropTargetDataNode);
                        }
                        importExportDialog.copyToCache(importNodeList);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                this.deleteMovedNodesOriginals(arbilNodesDeleteList);
                if (dropTargetDataNode != null) {
                    dropTargetDataNode.reloadNode();
                } else {
                    ArbilTreeHelper.getSingleInstance().applyRootLocations();
                }
                return true;
            }
            return false;
        }

        private void doMoveLocalNodes(Object dropTargetUserObject, ArbilDataNode dropTargetDataNode, ArbilDataNode currentNode, int draggedCounter, Hashtable<ArbilDataNode, Vector<ArbilDataNode>> arbilNodesDeleteList) {
            boolean addNodeResult = false;
            if (dropTargetUserObject instanceof ArbilDataNode) {
                if (dropTargetDataNode.isCorpus()) {
                    addNodeResult = dropTargetDataNode.addCorpusLink(currentNode);
                } else if (!dropTargetDataNode.isCmdiMetaDataNode() && (dropTargetDataNode.isEmptyMetaNode() || dropTargetDataNode.isSession())) {
                    if (MetadataReader.getSingleInstance().nodeCanExistInNode(dropTargetDataNode, currentNode)) {
                        try {
                            new MetadataBuilder().addNodes(dropTargetDataNode, new String[]{currentNode.toString()}, new ArbilDataNode[]{currentNode});
                            addNodeResult = true;
                        }
                        catch (ArbilMetadataException ex) {
                            GuiHelper.linorgBugCatcher.logError(ex);
                            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue(ex.getLocalizedMessage(), "Insert node error");
                        }
                    }
                } else if (dropTargetDataNode.isCmdiMetaDataNode()) {
                    if (currentNode.isMetaDataNode() && !currentNode.isCmdiMetaDataNode()) {
                        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Moving IMDI metadata to CMDI metadata files is currently not supported", "Not supported");
                    } else if (currentNode.isCmdiMetaDataNode() && currentNode.isChildNode()) {
                        try {
                            addNodeResult = null != new ArbilComponentBuilder().insertFavouriteComponent(dropTargetDataNode, currentNode);
                        }
                        catch (ArbilMetadataException ex) {
                            addNodeResult = false;
                        }
                    } else {
                        ArbilComponentBuilder arbilComponentBuilder = new ArbilComponentBuilder();
                        addNodeResult = null != arbilComponentBuilder.insertResourceProxy(dropTargetDataNode, currentNode);
                    }
                }
            } else {
                addNodeResult = ArbilTreeHelper.getSingleInstance().addLocation(currentNode.getURI());
            }
            if (addNodeResult) {
                if (this.draggedTreeNodes[draggedCounter] != null) {
                    if (this.draggedTreeNodes[draggedCounter].getParent().equals(this.draggedTreeNodes[draggedCounter].getRoot())) {
                        System.out.println("dragged from root");
                        ArbilTreeHelper.getSingleInstance().removeLocation(currentNode);
                        ArbilTreeHelper.getSingleInstance().applyRootLocations();
                    } else {
                        ArbilDataNode parentNode = (ArbilDataNode)((DefaultMutableTreeNode)this.draggedTreeNodes[draggedCounter].getParent()).getUserObject();
                        System.out.println("removeing from parent: " + parentNode);
                        if (!arbilNodesDeleteList.containsKey(parentNode)) {
                            arbilNodesDeleteList.put(parentNode, new Vector());
                        }
                        arbilNodesDeleteList.get(parentNode).add(currentNode);
                    }
                }
            } else {
                GuiHelper.linorgBugCatcher.logError("Could not add node " + currentNode.toString() + " to target " + dropTargetUserObject.toString(), null);
            }
        }

        private void deleteMovedNodesOriginals(Hashtable<ArbilDataNode, Vector<ArbilDataNode>> arbilNodesDeleteList) {
            for (Map.Entry<ArbilDataNode, Vector<ArbilDataNode>> entry : arbilNodesDeleteList.entrySet()) {
                ArbilDataNode currentParent = entry.getKey();
                Vector<ArbilDataNode> children = entry.getValue();
                if (currentParent.isCorpus()) {
                    System.out.println("deleting by corpus link");
                    ArbilDataNode[] arbilNodeArray = children.toArray(new ArbilDataNode[0]);
                    currentParent.deleteCorpusLink(arbilNodeArray);
                    continue;
                }
                if (!currentParent.isMetaDataNode()) continue;
                ArbilTreeHelper.getSingleInstance().deleteChildNodes(currentParent, children);
            }
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            System.out.println("getTransferData");
            if (this.isDataFlavorSupported(flavor)) {
                return this.draggedArbilNodes;
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            System.out.println("getTransferDataFlavors");
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            System.out.println("isDataFlavorSupported");
            return this.flavors[0].equals(flavor);
        }
    }
}

