/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import net.handle.dnslib.DNSResourceRecord;

public class DNSQuestion {
    public String[] qName;
    public int qType;
    public int qClass;

    public DNSQuestion(String[] qName, int qType, int qClass) {
        this.qName = qName;
        this.qType = qType;
        this.qClass = qClass;
    }

    public DNSQuestion() {
        this.qName = null;
        this.qType = -1;
        this.qClass = -1;
    }

    public int decode(byte[] buf, int offset) {
        int origLoc = offset;
        Vector nameVect = new Vector();
        offset += DNSResourceRecord.readNameFromPointer(buf, offset, nameVect);
        this.qName = new String[nameVect.size()];
        for (int i = 0; i < this.qName.length; ++i) {
            this.qName[i] = (String)nameVect.elementAt(i);
        }
        this.qType = buf[offset++] << 8 | buf[offset++];
        this.qClass = buf[offset++] << 8 | buf[offset++];
        return offset - origLoc;
    }

    public int encode(byte[] msgBuf, int location, Hashtable nameTable) {
        int origLoc = location;
        location += DNSResourceRecord.writeNameToPointer(this.qName, msgBuf, location, nameTable);
        msgBuf[location++] = (byte)((this.qType & 0xFF00) >> 8);
        msgBuf[location++] = (byte)(this.qType & 0xFF);
        msgBuf[location++] = (byte)((this.qClass & 0xFF00) >> 8);
        msgBuf[location++] = (byte)(this.qClass & 0xFF);
        return location - origLoc;
    }

    public void printValues(PrintStream out) {
        out.println(this.toString());
    }

    public String toString() {
        String name = "null";
        if (this.qName != null) {
            name = "";
            for (int i = 0; i < this.qName.length; ++i) {
                name = name + this.qName[i] + '.';
            }
        }
        return "name=\"" + name + "\" type=" + this.qType + " class=" + this.qClass;
    }
}

