/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Enumeration;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.table.AbstractTableModel;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.importexport.ArbilToHtmlConverter;
import nl.mpi.arbil.templates.ArbilFavourites;
import nl.mpi.arbil.ui.ArbilFieldViews;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.util.ArbilBugCatcher;

public class GuiHelper {
    public static final ArbilBugCatcher linorgBugCatcher = new ArbilBugCatcher();
    private static final ClipboardOwner clipboardOwner = new ClipboardOwner(){

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
            System.out.println("lost clipboard ownership");
        }
    };
    private static GuiHelper singleInstance = null;

    public static synchronized GuiHelper getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new GuiHelper();
        }
        return singleInstance;
    }

    public static ClipboardOwner getClipboardOwner() {
        return clipboardOwner;
    }

    private GuiHelper() {
        ArbilFavourites.getSingleInstance();
    }

    public void saveState(boolean saveWindows) {
        ArbilFieldViews.getSingleInstance().saveViewsToFile();
        if (saveWindows) {
            ArbilWindowManager.getSingleInstance().saveWindowStates();
        }
    }

    public void initViewMenu(JMenu viewMenu) {
        viewMenu.removeAll();
        ButtonGroup viewMenuButtonGroup = new ButtonGroup();
        Enumeration menuItemName = ArbilFieldViews.getSingleInstance().getSavedFieldViewLables();
        while (menuItemName.hasMoreElements()) {
            String currentMenuName = menuItemName.nextElement().toString();
            JRadioButtonMenuItem viewLabelRadioButtonMenuItem = new JRadioButtonMenuItem();
            viewMenuButtonGroup.add(viewLabelRadioButtonMenuItem);
            viewLabelRadioButtonMenuItem.setSelected(ArbilFieldViews.getSingleInstance().getCurrentGlobalViewName().equals(currentMenuName));
            viewLabelRadioButtonMenuItem.setText(currentMenuName);
            viewLabelRadioButtonMenuItem.setName(currentMenuName);
            viewLabelRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        ArbilFieldViews.getSingleInstance().setCurrentGlobalViewName(((Component)evt.getSource()).getName());
                    }
                    catch (Exception ex) {
                        linorgBugCatcher.logError(ex);
                    }
                }
            });
            viewMenu.add(viewLabelRadioButtonMenuItem);
        }
    }

    public void openImdiXmlWindow(Object userObject, boolean formatXml, boolean launchInBrowser) {
        block11: {
            if (userObject instanceof ArbilDataNode) {
                if (((ArbilDataNode)userObject).getNeedsSaveToDisk(false)) {
                    if (0 == ArbilWindowManager.getSingleInstance().showDialogBox("The node must be saved first.\nSave now?", "View IMDI XML", 2, -1)) {
                        ((ArbilDataNode)userObject).saveChangesToCache(true);
                    } else {
                        return;
                    }
                }
                URI nodeUri = ((ArbilDataNode)userObject).getURI();
                System.out.println("openImdiXmlWindow: " + nodeUri);
                String nodeName = ((ArbilDataNode)userObject).toString();
                if (formatXml) {
                    try {
                        File tempHtmlFile = new ArbilToHtmlConverter().convertToHtml((ArbilDataNode)userObject);
                        if (!launchInBrowser) {
                            ArbilWindowManager.getSingleInstance().openUrlWindowOnce(nodeName + " formatted", tempHtmlFile.toURL());
                            break block11;
                        }
                        this.openFileInExternalApplication(new URI("file", null, tempHtmlFile.getCanonicalPath(), null));
                    }
                    catch (Exception ex) {
                        linorgBugCatcher.logError(ex);
                    }
                } else {
                    try {
                        ArbilWindowManager.getSingleInstance().openUrlWindowOnce(nodeName + "-xml", nodeUri.toURL());
                    }
                    catch (Exception ex) {
                        linorgBugCatcher.logError(ex);
                    }
                }
            }
        }
    }

    public AbstractTableModel getImdiTableModel() {
        ArbilTableModel tempModel = new ArbilTableModel();
        tempModel.setShowIcons(true);
        return tempModel;
    }

    public boolean openFileInExternalApplication(URI targetUri) {
        boolean result;
        block19: {
            boolean awtDesktopFound;
            result = false;
            try {
                Class.forName("java.awt.Desktop");
                awtDesktopFound = true;
            }
            catch (ClassNotFoundException cnfE) {
                awtDesktopFound = false;
                System.out.println("java.awt.Desktop class not found");
            }
            if (awtDesktopFound) {
                try {
                    if (targetUri.getScheme().toLowerCase().equals("file")) {
                        Desktop.getDesktop().open(new File(targetUri));
                    } else {
                        Desktop.getDesktop().browse(targetUri);
                    }
                    result = true;
                }
                catch (MalformedURLException muE) {
                    linorgBugCatcher.logError("awtDesktopFound", muE);
                    ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Failed to find the file: " + muE.getMessage(), "Open In External Application");
                }
                catch (IOException ioE) {
                    linorgBugCatcher.logError("awtDesktopFound", ioE);
                    if (targetUri.getScheme().equalsIgnoreCase("file")) {
                        if (ArbilWindowManager.getSingleInstance().showConfirmDialogBox("Failed to open the file. Please check that it is accessible and has an application associated with it.\n\nDo you want to open the parent directory?", "Open In External Application")) {
                            this.openFileInExternalApplication(new File(targetUri).getParentFile().toURI());
                        }
                        break block19;
                    }
                    ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Failed to open the remote location: " + ioE.getMessage(), "Open In External Application");
                }
            } else {
                String osNameString = null;
                try {
                    osNameString = System.getProperty("os.name").toLowerCase();
                    String fileString = ArbilDataNode.isStringLocal(targetUri.getScheme()) ? new File(targetUri).getAbsolutePath() : targetUri.toString();
                    Process launchedProcess = null;
                    if (osNameString.indexOf("windows") != -1 || osNameString.indexOf("nt") != -1) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", fileString});
                    }
                    if (osNameString.equals("windows 95") || osNameString.equals("windows 98")) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"command.com", "/C", "start", fileString});
                    }
                    if (osNameString.indexOf("mac") != -1) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"open", fileString});
                    }
                    if (osNameString.indexOf("linux") != -1) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"gnome-open", fileString});
                    }
                    if (launchedProcess != null) {
                        String line;
                        BufferedReader errorStreamReader = new BufferedReader(new InputStreamReader(launchedProcess.getErrorStream()));
                        while ((line = errorStreamReader.readLine()) != null) {
                            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue(line, "Open In External Application");
                            System.out.println("Launched process error stream: \"" + line + "\"");
                        }
                        result = true;
                    }
                }
                catch (Exception e) {
                    linorgBugCatcher.logError(osNameString, e);
                }
            }
        }
        return result;
    }
}

