/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JOptionPane;

public class MPIThreadGroup
extends ThreadGroup {
    public MPIThreadGroup(String name) {
        super(name);
    }

    public MPIThreadGroup(ThreadGroup parent, String name) {
        super(parent, name);
    }

    public Thread getMonitorThread(long minAvailable) {
        return new MemoryMonitor((ThreadGroup)this, minAvailable);
    }

    public void uncaughtException(Thread t, Throwable thr) {
        if (thr instanceof OutOfMemoryError) {
            JOptionPane.showMessageDialog(null, "Not enough memory - Application will quit.", "Not enough memory", 0);
            System.exit(0);
        } else {
            System.err.println("Uncaught exception in thread " + t + ": " + thr);
            thr.printStackTrace();
        }
    }

    private static class MemoryMonitor
    extends Thread {
        private Runtime runtime;
        private long maxMemory;
        private long minAvailable = 2000000L;
        private long lastAvailable;
        private long sleepTime = 500L;
        private boolean gcOccurred = false;
        private String warning = "Running low on memory! It may be wise to close some windows.";

        private MemoryMonitor(ThreadGroup tg, long minAvailable) {
            super(tg, "memory monitor");
            this.minAvailable = minAvailable;
            this.runtime = Runtime.getRuntime();
            this.maxMemory = this.runtime.maxMemory();
            this.lastAvailable = this.getAvailableMemory();
            System.out.println("New MemoryMonitor:\nsleepTime=" + this.sleepTime + "\nminAvailable=" + minAvailable);
        }

        public static MemoryMonitor getInstance(ThreadGroup tg, long minAvailable) {
            return new MemoryMonitor(tg, minAvailable);
        }

        public void setSleepTime(long sleepTime) {
            this.sleepTime = sleepTime;
        }

        public void setWarning(String warning) {
            this.warning = warning;
        }

        public void run() {
            boolean stop = false;
            while (!stop && !this.isInterrupted()) {
                try {
                    long available = this.getAvailableMemory();
                    if (available > this.lastAvailable) {
                        this.gcOccurred = true;
                    }
                    this.lastAvailable = available;
                    if (available <= this.minAvailable && this.gcOccurred) {
                        Object[] options = new String[]{"OK", "Don't warn me again"};
                        int answer = JOptionPane.showOptionDialog(null, this.warning, "Low on memory", 2, 2, null, options, options[1]);
                        if (answer != 0) {
                            stop = true;
                        }
                        this.gcOccurred = false;
                    }
                    MemoryMonitor.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    System.err.println(this + " was interrupted - " + e);
                    stop = true;
                }
            }
            System.out.println("MemoryMonitor quits.");
        }

        private long getAvailableMemory() {
            return this.maxMemory - (this.runtime.totalMemory() - this.runtime.freeMemory());
        }

        private void mem() {
            System.out.println("Max memory: " + MemoryMonitor.formatNumber(this.runtime.maxMemory()));
            System.out.println("Allocated memory: " + MemoryMonitor.formatNumber(this.runtime.totalMemory()));
            System.out.println("In use: " + MemoryMonitor.formatNumber(this.runtime.totalMemory() - this.runtime.freeMemory()) + "\n");
        }

        private static String formatNumber(long nr) {
            return NumberFormat.getInstance(new Locale("nl")).format(nr);
        }
    }
}

