/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.search;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ArbilRemoteSearch {
    protected String lastSearchString = null;
    protected ArbilDataNode[] lastSearchNodes = null;
    protected URI[] searchResults = null;

    public static boolean isEmptyQuery(String queryText) {
        return "<remote server search term (required)>".equals(queryText) || "".equals(queryText);
    }

    public URI[] getServerSearchResults(String queryText, ArbilDataNode[] searchNodes) {
        if (queryText == null || ArbilRemoteSearch.isEmptyQuery(queryText)) {
            return new URI[0];
        }
        if (queryText.equals(this.lastSearchString) && Arrays.equals(searchNodes, this.lastSearchNodes)) {
            System.out.println("remote search term unchanged, returning last server response");
            return this.searchResults;
        }
        ArrayList<URI> foundNodes = new ArrayList<URI>();
        this.lastSearchString = queryText;
        this.lastSearchNodes = (ArbilDataNode[])searchNodes.clone();
        for (String resultString : this.performSearch(this.lastSearchString, searchNodes)) {
            try {
                foundNodes.add(new URI(resultString));
            }
            catch (URISyntaxException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
            }
        }
        this.searchResults = foundNodes.toArray(new URI[0]);
        return this.searchResults;
    }

    protected String[] performSearch(String searchString, ArbilDataNode[] arbilDataNodeArray) {
        ArrayList<String> returnArray = new ArrayList<String>();
        int maxResultNumber = 1000;
        try {
            String fullQueryString = ArbilRemoteSearch.constructSearchQuery(arbilDataNodeArray, searchString, maxResultNumber);
            System.out.println("QueryString: " + fullQueryString);
            Document resultsDocument = this.getSearchResults(fullQueryString);
            NodeList domIdNodeList = XPathAPI.selectNodeList((Node)resultsDocument, (String)"/ImdiSearchResponse/Result/Match/URL");
            for (int nodeCounter = 0; nodeCounter < domIdNodeList.getLength(); ++nodeCounter) {
                Node urlNode = domIdNodeList.item(nodeCounter);
                if (urlNode == null) continue;
                System.out.println(urlNode.getTextContent());
                returnArray.add(urlNode.getTextContent());
            }
        }
        catch (DOMException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        catch (IOException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        catch (ParserConfigurationException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        catch (SAXException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        catch (TransformerException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        if (returnArray.size() >= maxResultNumber) {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Found more results than can be displayed, only showing the first " + maxResultNumber + " results", "Remote Search");
        }
        return returnArray.toArray(new String[0]);
    }

    private static String constructSearchQuery(ArbilDataNode[] arbilDataNodeArray, String searchString, int maxResultNumber) {
        String encodedQuery;
        try {
            encodedQuery = URLEncoder.encode(searchString, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        String fullQueryString = "http://corpus1.mpi.nl/ds/imdi_search/servlet?action=getMatches";
        fullQueryString = fullQueryString + "&num=" + maxResultNumber;
        fullQueryString = fullQueryString + "&query=" + encodedQuery;
        fullQueryString = fullQueryString + "&type=simple";
        fullQueryString = fullQueryString + "&includeUrl=true";
        for (ArbilDataNode arbilDataNode : arbilDataNodeArray) {
            if (arbilDataNode.archiveHandle != null) {
                fullQueryString = fullQueryString + "&nodeid=" + arbilDataNode.archiveHandle;
                continue;
            }
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Cannot search \"" + arbilDataNode + "\" because it does not have an archive handle", "Remote Search");
        }
        fullQueryString = fullQueryString + "&returnType=xml";
        return fullQueryString;
    }

    private Document getSearchResults(String fullQueryString) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document resultsDocument = documentBuilder.parse(fullQueryString);
        return resultsDocument;
    }
}

