/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.handle.apps.db_tool.DefaultDataPanel;
import net.handle.awt.AwtUtil;
import net.handle.awt.GenericDialog;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class HandleValuePanel
extends JPanel
implements ActionListener {
    private JTextField indexField;
    private JTextField typeField;
    private JTextField dataField;
    private byte[] data;
    private JButton editDataButton;
    private JComboBox ttlTypeChoice;
    private JTextField ttlField;
    private JTextField timestampField;
    private JCheckBox adminReadCheckbox;
    private JCheckBox adminWriteCheckbox;
    private JCheckBox publicReadCheckbox;
    private JCheckBox publicWriteCheckbox;
    private JList referenceList;
    private DefaultListModel referenceListModel;
    private Vector references = new Vector();
    private JButton addReferenceButton;
    private JButton remReferenceButton;
    private JButton editReferenceButton;

    public HandleValuePanel() {
        super(new GridBagLayout());
        this.indexField = new JTextField("", 10);
        this.typeField = new JTextField("", 10);
        this.dataField = new JTextField("", 20);
        this.dataField.setEditable(false);
        this.editDataButton = new JButton("Edit");
        this.ttlTypeChoice = new JComboBox();
        this.ttlTypeChoice.addItem("Relative");
        this.ttlTypeChoice.addItem("Absolute");
        this.ttlField = new JTextField("", 6);
        this.timestampField = new JTextField("", 10);
        this.timestampField.setEditable(false);
        this.adminReadCheckbox = new JCheckBox("AR", true);
        this.adminWriteCheckbox = new JCheckBox("AW", true);
        this.publicReadCheckbox = new JCheckBox("PR", true);
        this.publicWriteCheckbox = new JCheckBox("PW", false);
        this.referenceListModel = new DefaultListModel();
        this.referenceList = new JList(this.referenceListModel);
        this.addReferenceButton = new JButton("Add");
        this.remReferenceButton = new JButton("Remove");
        this.editReferenceButton = new JButton("Modify");
        JPanel panel1 = new JPanel(new GridBagLayout());
        JPanel panel2 = new JPanel(new GridBagLayout());
        JPanel panel3 = new JPanel(new GridBagLayout());
        int x = 0;
        int y = 0;
        panel1.add((Component)new JLabel("Index:", 4), AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel1.add((Component)this.indexField, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        panel1.add((Component)new JLabel(" Type:", 4), AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel1.add((Component)this.typeField, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        panel1.add((Component)new JLabel(" Data:", 4), AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel1.add((Component)this.dataField, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        panel1.add((Component)this.editDataButton, AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        x = 0;
        y = 0;
        panel2.add((Component)new JLabel(" TTL:", 4), AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel2.add((Component)this.ttlTypeChoice, AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel2.add((Component)this.ttlField, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        panel2.add((Component)new JLabel(" Timestamp:", 4), AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel2.add((Component)this.timestampField, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        x = 0;
        y = 0;
        JPanel tmpPanel = new JPanel(new GridBagLayout());
        tmpPanel.add((Component)new JLabel(" Permissions:", 0), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 2, 1, true, true));
        tmpPanel.add((Component)this.adminReadCheckbox, AwtUtil.getConstraints(0, 1, 1.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.adminWriteCheckbox, AwtUtil.getConstraints(1, 1, 1.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.publicReadCheckbox, AwtUtil.getConstraints(0, 2, 1.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.publicWriteCheckbox, AwtUtil.getConstraints(1, 2, 0.0, 0.0, 1, 1, true, true));
        panel3.add((Component)tmpPanel, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        tmpPanel = new JPanel(new GridBagLayout());
        tmpPanel.add((Component)new JLabel(" Refs:", 0), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 2, 1, true, true));
        tmpPanel.add((Component)new JScrollPane(this.referenceList), AwtUtil.getConstraints(0, 1, 1.0, 0.0, 1, 5, true, true));
        tmpPanel.add((Component)this.addReferenceButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.remReferenceButton, AwtUtil.getConstraints(1, 2, 0.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.editReferenceButton, AwtUtil.getConstraints(1, 3, 0.0, 0.0, 1, 1, true, true));
        int n = ++x;
        ++x;
        panel3.add((Component)tmpPanel, AwtUtil.getConstraints(n, y, 1.0, 0.0, 1, 1, true, true));
        this.add((Component)panel1, AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)panel2, AwtUtil.getConstraints(0, 1, 0.0, 1.0, 1, 1, true, true));
        this.add((Component)panel3, AwtUtil.getConstraints(0, 2, 0.0, 0.0, 1, 1, true, true));
        this.addReferenceButton.addActionListener(this);
        this.remReferenceButton.addActionListener(this);
        this.editReferenceButton.addActionListener(this);
        this.editDataButton.addActionListener(this);
    }

    private void updateDataLabel() {
        if (this.data == null) {
            this.dataField.setText("<null>");
        } else if (Util.looksLikeBinary(this.data)) {
            this.dataField.setText(Util.decodeHexString(this.data, false));
        } else {
            this.dataField.setText(Util.decodeString(this.data));
        }
    }

    private void rebuildReferenceList() {
        this.referenceListModel.clear();
        for (int i = 0; i < this.references.size(); ++i) {
            this.referenceListModel.addElement(String.valueOf(this.references.elementAt(i)));
        }
    }

    public void setHandleValue(HandleValue value) {
        this.data = value.getData();
        this.updateDataLabel();
        this.indexField.setText(String.valueOf(value.getIndex()));
        this.typeField.setText(Util.decodeString(value.getType()));
        switch (value.getTTLType()) {
            case 1: {
                this.ttlTypeChoice.setSelectedIndex(1);
                break;
            }
            default: {
                this.ttlTypeChoice.setSelectedIndex(0);
            }
        }
        this.ttlField.setText(String.valueOf(value.getTTL()));
        this.timestampField.setText(String.valueOf(new Date(value.getTimestamp() * 1000)));
        this.adminReadCheckbox.setSelected(value.getAdminCanRead());
        this.adminWriteCheckbox.setSelected(value.getAdminCanWrite());
        this.publicReadCheckbox.setSelected(value.getAnyoneCanRead());
        this.publicWriteCheckbox.setSelected(value.getAnyoneCanWrite());
        this.references.removeAllElements();
        ValueReference[] refs = value.getReferences();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                this.references.addElement(refs[i]);
            }
        }
        this.rebuildReferenceList();
    }

    public void getHandleValue(HandleValue value) {
        try {
            value.setIndex(Integer.parseInt(this.indexField.getText().trim()));
        }
        catch (Exception e) {
            System.err.println("Error: invalid index value: " + this.indexField.getText());
        }
        try {
            value.setTTL(Integer.parseInt(this.ttlField.getText().trim()));
            if (this.ttlTypeChoice.getSelectedIndex() == 0) {
                value.setTTLType((byte)0);
            } else {
                value.setTTLType((byte)1);
            }
        }
        catch (Exception e) {
            System.err.println("Error: invalid ttl: " + this.ttlField.getText());
        }
        value.setData(this.data);
        value.setType(Util.encodeString(this.typeField.getText()));
        value.setAdminCanRead(this.adminReadCheckbox.isSelected());
        value.setAdminCanWrite(this.adminWriteCheckbox.isSelected());
        value.setAnyoneCanRead(this.publicReadCheckbox.isSelected());
        value.setAnyoneCanWrite(this.publicWriteCheckbox.isSelected());
        ValueReference[] refs = new ValueReference[this.references.size()];
        for (int i = 0; i < refs.length; ++i) {
            refs[i] = (ValueReference)this.references.elementAt(i);
        }
        value.setReferences(refs);
    }

    private void editData() {
        DefaultDataPanel dataPanel = new DefaultDataPanel();
        dataPanel.setValue(this.data);
        if (2 == GenericDialog.showDialog("Edit Data", dataPanel, 3, this)) {
            return;
        }
        this.data = dataPanel.getValue();
        this.updateDataLabel();
    }

    private void evtAddReference() {
    }

    private void evtRemoveReference() {
    }

    private void evtEditReference() {
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.editDataButton) {
            this.editData();
        } else if (src == this.addReferenceButton) {
            this.evtAddReference();
        } else if (src == this.remReferenceButton) {
            this.evtRemoveReference();
        } else if (src == this.editReferenceButton) {
            this.evtEditReference();
        }
    }
}

