/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class ListHandleJPanel
extends JPanel
implements ActionListener,
ResponseMessageCallback {
    private JTextField naField;
    private JRadioButton outFileRadio;
    private JTextField outFileField;
    private JRadioButton outWindowRadio;
    private JButton browseFileButton;
    private JButton submitButton;
    private JButton changeAuthButton;
    private JTextArea consoleArea;
    private Writer hdlOut = null;
    private HandleTool tool;

    public ListHandleJPanel(HandleTool tool) {
        this.tool = tool;
        GridBagLayout gridbag = new GridBagLayout();
        EtchedBorder etchBorder = new EtchedBorder();
        this.setLayout(gridbag);
        this.consoleArea = new JTextArea(10, 30);
        this.consoleArea.setEditable(false);
        this.naField = new JTextField("", 12);
        this.outFileRadio = new JRadioButton("File:", false);
        this.outWindowRadio = new JRadioButton("Window:", true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.outFileRadio);
        bg.add(this.outWindowRadio);
        this.outFileField = new JTextField("handles.txt", 12);
        this.browseFileButton = new JButton("Browse...");
        this.submitButton = new JButton("Submit");
        this.changeAuthButton = new JButton("Authentication");
        int x = 0;
        int y = 0;
        this.add((Component)new JLabel("Naming Authority/Prefix: ", 4), AwtUtil.getConstraints(x, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.naField, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 1, 1, true, true));
        JPanel tmpPanel = new JPanel(gridbag);
        tmpPanel.add((Component)this.changeAuthButton, AwtUtil.getConstraints(0, 0, 1.0, 0.0, 1, 1, false, false));
        tmpPanel.add((Component)this.submitButton, AwtUtil.getConstraints(1, 0, 1.0, 0.0, 1, 1, false, false));
        this.add((Component)tmpPanel, AwtUtil.getConstraints(x, y++, 1.0, 0.0, 2, 1, true, true));
        this.add((Component)new JLabel(" "), AwtUtil.getConstraints(x, y++, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)new JLabel("Output To: "), AwtUtil.getConstraints(x, y++, 0.0, 0.0, 1, 1, true, true));
        tmpPanel = new JPanel(gridbag);
        tmpPanel.add((Component)this.outFileRadio, AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.outFileField, AwtUtil.getConstraints(1, 0, 1.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.browseFileButton, AwtUtil.getConstraints(2, 0, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)tmpPanel, AwtUtil.getConstraints(x, y++, 1.0, 0.0, 2, 1, true, true));
        this.add((Component)new JLabel(" "), AwtUtil.getConstraints(x, y++, 0.0, 0.0, 1, 1, true, true));
        tmpPanel = new JPanel(gridbag);
        tmpPanel.add((Component)this.outWindowRadio, AwtUtil.getConstraints(0, 0, 1.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)new JScrollPane(this.consoleArea), AwtUtil.getConstraints(0, 1, 1.0, 1.0, 1, 1, true, true));
        this.add((Component)tmpPanel, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 2, 1, true, true));
        this.submitButton.addActionListener(this);
        this.browseFileButton.addActionListener(this);
        this.changeAuthButton.addActionListener(this);
        this.outFileRadio.addActionListener(this);
        this.outWindowRadio.addActionListener(this);
        this.outputSelected();
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.submitButton) {
            this.listHandles();
        } else if (src == this.browseFileButton) {
            this.selectFile();
        } else if (src == this.changeAuthButton) {
            this.tool.changeAuthentication();
        } else if (src == this.outFileRadio || src == this.outWindowRadio) {
            this.outputSelected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void listHandles() {
        block18: {
            String prefix = this.naField.getText().trim();
            if (prefix.length() <= 0 || prefix.indexOf(47) >= 0) {
                JOptionPane.showMessageDialog(this, "Invalid or missing naming authority/prefix", "Error Message: ", 0);
                return;
            }
            String naHandleStr = Util.decodeString(Common.NA_HANDLE_PREFIX) + prefix;
            byte[] naHandle = Util.encodeString(naHandleStr.toUpperCase());
            AuthenticationInfo authInfo = this.tool.getAuthentication();
            if (authInfo == null) {
                return;
            }
            ListHandlesRequest req = new ListHandlesRequest(naHandle, authInfo);
            this.consoleArea.setText("");
            this.consoleArea.repaint();
            try {
                this.hdlOut = this.outFileRadio.isSelected() ? new FileWriter(new File(this.outFileField.getText())) : new ConsoleWriter();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error setting up output: " + e, "Error Message", 0);
                return;
            }
            ResolutionRequest dudReq = new ResolutionRequest(Util.encodeString(prefix + "/test"), null, null, null);
            System.err.println("finding local sites for " + dudReq);
            SiteInfo[] sites = this.tool.resolver.findLocalSites(dudReq);
            SiteInfo site = sites[Math.abs(new Random().nextInt()) % sites.length];
            System.err.println("contacting site: " + site);
            this.tool.resolver.setTcpTimeout(300000);
            if (site.majorProtocolVersion == 5 && site.minorProtocolVersion == 0 || site.majorProtocolVersion < 2 || site.majorProtocolVersion == 2 && site.minorProtocolVersion < 1) {
                req.majorProtocolVersion = site.majorProtocolVersion;
                req.minorProtocolVersion = site.minorProtocolVersion;
            } else {
                req.majorProtocolVersion = (byte)2;
                req.minorProtocolVersion = 1;
            }
            for (int i = 0; i < site.servers.length; ++i) {
                ServerInfo server = site.servers[i];
                System.err.println(" contacting server: " + server);
                try {
                    AbstractResponse response = this.tool.resolver.sendRequestToServer(req, server, this);
                    if (response.responseCode == 1) continue;
                    System.err.println("got error: " + response);
                    JOptionPane.showMessageDialog(this, "Error: " + response, "Error Message", 0);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            Object var13_15 = null;
            if (this.hdlOut == null) break block18;
            try {
                this.hdlOut.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            this.hdlOut = null;
            {
                break block18;
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    JOptionPane.showMessageDialog(this, "Error: " + e, "Error Message", 0);
                    Object var13_16 = null;
                    if (this.hdlOut == null) break block18;
                    try {
                        this.hdlOut.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    this.hdlOut = null;
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (this.hdlOut != null) {
                    try {
                        this.hdlOut.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    this.hdlOut = null;
                }
                throw throwable;
            }
        }
        System.err.println("done listing handles...");
    }

    public void handleResponse(AbstractResponse response) {
        if (response instanceof ListHandlesResponse) {
            try {
                ListHandlesResponse lhResp = (ListHandlesResponse)response;
                byte[][] handles = lhResp.handles;
                for (int i = 0; i < handles.length; ++i) {
                    this.hdlOut.write(Util.decodeString(handles[i]));
                    this.hdlOut.write("\n");
                    this.hdlOut.flush();
                }
            }
            catch (Exception e) {
                System.err.println("Error: " + e);
                e.printStackTrace(System.err);
            }
        } else if (response.responseCode != 402) {
            JOptionPane.showMessageDialog(this, "Error: " + response, "Error Message", 0);
        }
    }

    private void selectFile() {
        File selectedFile;
        String path = this.outFileField.getText();
        JFileChooser jfc = path.trim().length() > 0 ? new JFileChooser(path) : new JFileChooser();
        int result = jfc.showSaveDialog(this);
        if (result == 0 && (selectedFile = jfc.getSelectedFile()) != null) {
            this.outFileField.setText(selectedFile.getAbsolutePath());
        }
    }

    private void outputSelected() {
        boolean toFile = this.outFileRadio.isSelected();
        this.consoleArea.setEnabled(!toFile);
        this.browseFileButton.setEnabled(toFile);
        this.outFileField.setEnabled(toFile);
    }

    private class ConsoleWriter
    extends Writer {
        private ConsoleWriter() {
        }

        public void write(char[] cbuf, int off, int len) {
            ListHandleJPanel.this.consoleArea.append(new String(cbuf, off, len));
            ListHandleJPanel.this.consoleArea.repaint();
        }

        public void write(String str) {
            ListHandleJPanel.this.consoleArea.append(str);
            ListHandleJPanel.this.consoleArea.repaint();
        }

        public void close() {
        }

        public void flush() {
        }
    }
}

