/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Util;
import net.handle.security.HdlSecurityProvider;

public class SessionSetupInfo {
    public int keyExchangeMode = 0;
    public AuthenticationInfo authInfo = null;
    public byte[] exchangeKeyHandle = null;
    public int exchangeKeyIndex = -1;
    public byte[] publicExchangeKey = null;
    public PrivateKey privateExchangeKey = null;
    public int timeout = 86400;
    public boolean encrypted;
    public boolean authenticated;

    public SessionSetupInfo(AuthenticationInfo authInfo, byte[] exchangeHandle, int exchangeIndex, PrivateKey privateKey) {
        this.authInfo = authInfo;
        this.exchangeKeyHandle = exchangeHandle;
        this.exchangeKeyIndex = exchangeIndex;
        this.publicExchangeKey = null;
        this.privateExchangeKey = privateKey;
        this.keyExchangeMode = 3;
    }

    public SessionSetupInfo(AuthenticationInfo authInfo, String exchangeHandle, int exchangeIndex, PrivateKey privateKey) {
        this.authInfo = authInfo;
        this.exchangeKeyHandle = Util.encodeString(exchangeHandle);
        this.exchangeKeyIndex = exchangeIndex;
        this.publicExchangeKey = null;
        this.privateExchangeKey = privateKey;
        this.keyExchangeMode = 3;
    }

    public SessionSetupInfo(AuthenticationInfo authInfo) throws Exception {
        this.authInfo = authInfo;
        this.exchangeKeyHandle = null;
        this.exchangeKeyIndex = -1;
        this.keyExchangeMode = 4;
        this.initDHKeys();
    }

    public SessionSetupInfo(int mode, AuthenticationInfo authInfo, byte[] exchangekey, PrivateKey privateKey) {
        this.authInfo = authInfo;
        this.exchangeKeyHandle = null;
        this.exchangeKeyIndex = -1;
        this.publicExchangeKey = exchangekey;
        this.privateExchangeKey = privateKey;
        this.keyExchangeMode = mode;
    }

    public SessionSetupInfo(int mode, AuthenticationInfo authInfo, PublicKey exchangekey, PrivateKey privateKey) throws Exception {
        this.authInfo = authInfo;
        this.exchangeKeyHandle = null;
        this.exchangeKeyIndex = -1;
        this.publicExchangeKey = Util.getBytesFromPublicKey(exchangekey);
        this.privateExchangeKey = privateKey;
        this.keyExchangeMode = mode;
    }

    public SessionSetupInfo(int mode, AuthenticationInfo authInfo) {
        this.authInfo = authInfo;
        this.keyExchangeMode = mode;
    }

    public void reset() {
        this.authInfo = null;
        this.exchangeKeyHandle = null;
        this.exchangeKeyIndex = -1;
        this.publicExchangeKey = null;
        this.keyExchangeMode = 0;
    }

    public String toString() {
        String str = "";
        if (this.authInfo != null) {
            str = str + Util.decodeString(this.authInfo.getUserIdHandle()) + this.authInfo.getUserIdIndex() + " ";
        }
        str = str + "exchange key usage " + this.keyExchangeMode;
        return str;
    }

    public void initDHKeys() throws Exception {
        if (this.keyExchangeMode != 4) {
            throw new Exception("Tried to init Diffie-Hellman for wrong mode");
        }
        KeyPair kp = HdlSecurityProvider.getInstance().generateDHKeyPair(512);
        this.publicExchangeKey = Util.getBytesFromPublicKey(kp.getPublic());
        this.privateExchangeKey = kp.getPrivate();
    }
}

