/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.IOException;
import net.handle.hdllib4.XdrDecoder;
import net.handle.hdllib4.XdrEncoder;
import net.handle.hdllib4.XdrEncodingException;

public class QueryOptions {
    private boolean forwardRequests = true;
    private boolean authenticateRequests = false;

    public QueryOptions(boolean forwardRequests, boolean authenticateRequests) {
        this.forwardRequests = forwardRequests;
        this.authenticateRequests = authenticateRequests;
    }

    public QueryOptions(XdrDecoder decoder) throws IOException, XdrEncodingException {
        int numOptions = (int)decoder.readUnsignedInt();
        for (int i = 0; i < numOptions; ++i) {
            long optionType = decoder.readUnsignedInt();
            byte[] optionVal = decoder.readByteArray();
            if (optionType == 0L) {
                if (optionVal.length > 0 && optionVal[0] != 0 && optionVal[0] != 48) {
                    this.forwardRequests = true;
                    continue;
                }
                this.forwardRequests = false;
                continue;
            }
            if (optionType != 1L) continue;
            this.authenticateRequests = optionVal.length > 0 && optionVal[0] != 0 && optionVal[0] != 48;
        }
    }

    public QueryOptions() {
    }

    public boolean getForwardRequests() {
        return this.forwardRequests;
    }

    public boolean getAuthenticateRequests() {
        return this.authenticateRequests;
    }

    public synchronized void setForwardRequests(boolean forward) {
        this.forwardRequests = forward;
    }

    public synchronized void setAuthenticateRequests(boolean authenticate) {
        this.authenticateRequests = authenticate;
    }

    public synchronized void writeXdr(XdrEncoder encoder) {
        int numOptions = 0;
        if (this.forwardRequests) {
            ++numOptions;
        }
        if (this.authenticateRequests) {
            ++numOptions;
        }
        byte[] trueValue = new byte[]{1};
        encoder.writeUInt(numOptions);
        if (this.forwardRequests) {
            encoder.writeUInt(0L);
            encoder.writeByteArray(trueValue);
        }
        if (this.authenticateRequests) {
            encoder.writeUInt(1L);
            encoder.writeByteArray(trueValue);
        }
    }

    public static void writeNullOptions(XdrEncoder encoder) {
        encoder.writeUInt(0L);
    }
}

