/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URI;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.search.ArbilRemoteSearch;
import nl.mpi.arbil.search.RemoteServerSearchTerm;
import nl.mpi.arbil.ui.ArbilNodeSearchPanel;
import nl.mpi.arbil.ui.ArbilWindowManager;

public class RemoteServerSearchTermPanel
extends JPanel
implements RemoteServerSearchTerm {
    private ArbilNodeSearchPanel parentPanel;
    private JTextField searchField;
    private JLabel resultCountLabel;
    private ArbilRemoteSearch remoteSearch = new ArbilRemoteSearch();

    public RemoteServerSearchTermPanel(ArbilNodeSearchPanel parentPanelLocal) {
        this.parentPanel = parentPanelLocal;
        this.searchField = new JTextField("<remote server search term (required)>");
        this.searchField.setForeground(Color.lightGray);
        this.setLayout(new BoxLayout(this, 2));
        this.searchField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (RemoteServerSearchTermPanel.this.searchField.getText().equals("<remote server search term (required)>")) {
                    RemoteServerSearchTermPanel.this.searchField.setText("");
                    RemoteServerSearchTermPanel.this.searchField.setForeground(Color.BLACK);
                }
            }

            public void focusLost(FocusEvent e) {
                if (RemoteServerSearchTermPanel.this.searchField.getText().length() == 0) {
                    RemoteServerSearchTermPanel.this.searchField.setText("<remote server search term (required)>");
                    RemoteServerSearchTermPanel.this.searchField.setForeground(Color.lightGray);
                }
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                RemoteServerSearchTermPanel.this.parentPanel.stopSearch();
            }
        });
        this.resultCountLabel = new JLabel();
        this.add(this.searchField);
        this.add(this.resultCountLabel);
    }

    public URI[] getServerSearchResults(ArbilDataNode[] arbilDataNodeArray) {
        String searchFieldText = this.searchField.getText();
        if (ArbilRemoteSearch.isEmptyQuery(searchFieldText)) {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("No remote search term provided, cannot search remotely", "Remote Search");
        }
        URI[] searchResult = this.remoteSearch.getServerSearchResults(searchFieldText, arbilDataNodeArray);
        this.resultCountLabel.setText(searchResult.length + " found on server ");
        return searchResult;
    }
}

