/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.wizard.setup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.ui.wizard.ArbilWizardContent;

public abstract class TextInstructionWizardContent
extends JPanel
implements ArbilWizardContent {
    private static HyperlinkListener hyperLinkListener = new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (IOException ex) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
    };

    public TextInstructionWizardContent(String resourceLocation) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setContentType("text/html");
        textPane.addHyperlinkListener(hyperLinkListener);
        textPane.setMargin(new Insets(5, 10, 5, 10));
        textPane.setBackground(Color.WHITE);
        textPane.setText(this.loadContentFromResource(resourceLocation));
        this.add((Component)textPane, "North");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadContentFromResource(String resourceLocation) {
        try {
            InputStream resourceStream = this.getClass().getResourceAsStream(resourceLocation);
            if (resourceStream == null) {
                GuiHelper.linorgBugCatcher.logError("Cannot load wizard text. Location: " + resourceLocation, null);
                return "Error while getting wizard text. Please check the error log.";
            }
            try {
                BufferedReader contentReader = new BufferedReader(new InputStreamReader(resourceStream));
                StringBuilder contentStringBuilder = new StringBuilder();
                String line = contentReader.readLine();
                while (line != null) {
                    contentStringBuilder.append(line);
                    line = contentReader.readLine();
                }
                String string = contentStringBuilder.toString();
                return string;
            }
            finally {
                resourceStream.close();
            }
        }
        catch (IOException ex) {
            GuiHelper.linorgBugCatcher.logError("I/O exception while getting wizard text. Location: " + resourceLocation, ex);
        }
        return "Error while getting wizard text. Please check the error log.";
    }

    public JComponent getContent() {
        return this;
    }

    public void beforeShow() {
    }

    public boolean beforeNext() {
        return true;
    }

    public boolean beforePrevious() {
        return true;
    }

    public void refresh() {
    }
}

