/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ProgressMonitor;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilVocabulary;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.DownloadAbortFlag;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.WindowManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ArbilVocabularies {
    private static MessageDialogHandler messageDialogHandler;
    private static BugCatcher bugCatcher;
    private static WindowManager windowManager;
    private static SessionStorage sessionStorage;
    private Hashtable<String, ArbilVocabulary> vocabulariesTable = new Hashtable();
    private static ArbilVocabularies singleInstance;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static void setWindowManager(WindowManager windowManagerInstance) {
        windowManager = windowManagerInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static synchronized ArbilVocabularies getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilVocabularies();
        }
        return singleInstance;
    }

    private ArbilVocabularies() {
    }

    public boolean vocabularyContains(String vocabularyLocation, String valueString) {
        ArbilVocabulary tempVocab;
        if (!this.vocabulariesTable.containsKey(vocabularyLocation)) {
            this.parseRemoteFile(vocabularyLocation);
        }
        if ((tempVocab = this.vocabulariesTable.get(vocabularyLocation)) != null) {
            return null != tempVocab.findVocabularyItem(valueString);
        }
        return false;
    }

    public void redownloadCurrentlyLoadedVocabularies() {
        new Thread(){

            public void run() {
                int succeededCount = 0;
                int failedCount = 0;
                ProgressMonitor progressMonitor = windowManager.newProgressMonitor("Downloading currently loaded vocabularies", "", 0, ArbilVocabularies.this.vocabulariesTable.size());
                for (String currentUrl : ArbilVocabularies.this.vocabulariesTable.keySet()) {
                    if (sessionStorage.replaceCacheCopy(currentUrl)) {
                        ++succeededCount;
                    } else {
                        ++failedCount;
                    }
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        break;
                    }
                    progressMonitor.setNote("downloaded: " + succeededCount + " failed: " + failedCount);
                    progressMonitor.setProgress(succeededCount);
                }
                progressMonitor.close();
                messageDialogHandler.addMessageDialogToQueue("Downloaded " + succeededCount + " out of the " + ArbilVocabularies.this.vocabulariesTable.size() + " vocabularies currently in use.\nYou will need to restart the application for the new vocabularies to take effect.", "Re-download Current Vocabularies");
            }
        }.start();
    }

    public ArbilVocabulary getVocabulary(ArbilField originatingArbilField, String vocabularyLocation) {
        if (originatingArbilField != null) {
            ArbilField[] tempField;
            if (vocabularyLocation == null) {
                return null;
            }
            String fieldPath = originatingArbilField.getGenericFullXmlPath();
            if (vocabularyLocation.endsWith("MPI-Languages.xml")) {
                boolean foundTrigger = false;
                for (String[] currentTrigger : originatingArbilField.getParentDataNode().getNodeTemplate().fieldTriggersArray) {
                    if (!fieldPath.equals(currentTrigger[0])) continue;
                    foundTrigger = true;
                }
                if (!foundTrigger && !fieldPath.equals(".METATRANSCRIPT.Session.Resources.LexiconResource(x).MetaLanguages.Language")) {
                    bugCatcher.logError(new Exception("Missing Field Trigger for: " + fieldPath + " in " + originatingArbilField.getParentDataNode().getUrlString()));
                }
            }
            String vocabularyRedirectField = null;
            for (String[] currentRedirect : originatingArbilField.getParentDataNode().getNodeTemplate().genreSubgenreArray) {
                if (!fieldPath.equals(currentRedirect[0])) continue;
                vocabularyRedirectField = currentRedirect[1];
            }
            if (vocabularyRedirectField != null && (tempField = originatingArbilField.getSiblingField(vocabularyRedirectField)) != null) {
                String redirectFieldString = tempField[0].getFieldValue();
                ArbilVocabulary tempVocabulary = tempField[0].getVocabulary();
                ArbilVocabularyItem redirectFieldVocabItem = tempVocabulary.findVocabularyItem(redirectFieldString);
                if (redirectFieldVocabItem != null && redirectFieldVocabItem.followUpVocabulary != null) {
                    String correctedUrl;
                    vocabularyLocation = correctedUrl = tempVocabulary.resolveFollowUpUrl(redirectFieldVocabItem.followUpVocabulary);
                }
            }
        }
        if (vocabularyLocation == null || vocabularyLocation.length() == 0) {
            return null;
        }
        if (!this.vocabulariesTable.containsKey(vocabularyLocation)) {
            this.parseRemoteFile(vocabularyLocation);
        }
        return this.vocabulariesTable.get(vocabularyLocation);
    }

    public ArbilVocabulary getEmptyVocabulary(String vocabularyLocation) {
        if (vocabularyLocation == null || vocabularyLocation.length() == 0) {
            return null;
        }
        if (!this.vocabulariesTable.containsKey(vocabularyLocation)) {
            ArbilVocabulary vocabulary = new ArbilVocabulary(vocabularyLocation);
            this.vocabulariesTable.put(vocabularyLocation, vocabulary);
            return vocabulary;
        }
        return this.vocabulariesTable.get(vocabularyLocation);
    }

    public synchronized void parseRemoteFile(String vocabRemoteUrl) {
        if (vocabRemoteUrl != null && !this.vocabulariesTable.containsKey(vocabRemoteUrl)) {
            File cachedFile = sessionStorage.updateCache(vocabRemoteUrl, false, false, new DownloadAbortFlag(), null);
            if (!cachedFile.exists()) {
                String backupPath = "/nl/mpi/arbil/resources/IMDI/FallBack/" + cachedFile.getName();
                URL backUp = this.getClass().getResource(backupPath);
                if (backUp != null) {
                    sessionStorage.saveRemoteResource(backUp, cachedFile, true, false, new DownloadAbortFlag(), null);
                }
            }
            ArbilVocabulary vocabulary = new ArbilVocabulary(vocabRemoteUrl);
            this.vocabulariesTable.put(vocabRemoteUrl, vocabulary);
            try {
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = saxParserFactory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                FileInputStream inputStream = new FileInputStream(cachedFile);
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                InputSource inputSource = new InputSource(reader);
                inputSource.setEncoding("UTF-8");
                saxParser.parse(inputSource, (DefaultHandler)new SaxVocabularyHandler(vocabulary));
            }
            catch (Exception ex) {
                messageDialogHandler.addMessageDialogToQueue("A controlled vocabulary could not be read.\n" + vocabRemoteUrl + "\nSome fields may not show all options.", "Load Controlled Vocabulary");
                bugCatcher.logError("A controlled vocabulary could not be read: " + vocabRemoteUrl, ex);
            }
        }
    }

    static {
        singleInstance = null;
    }

    private static class SaxVocabularyHandler
    extends DefaultHandler {
        private ArbilVocabulary collectedVocab;
        private ArbilVocabularyItem currentVocabItem = null;

        public SaxVocabularyHandler(ArbilVocabulary vocabList) {
            this.collectedVocab = vocabList;
        }

        public void characters(char[] charArray, int start, int length) {
            if (this.currentVocabItem != null) {
                StringBuilder nodeContents = new StringBuilder();
                for (int charCounter = start; charCounter < start + length; ++charCounter) {
                    nodeContents.append(charArray[charCounter]);
                }
                this.currentVocabItem.descriptionString = nodeContents.toString();
            }
        }

        public void endElement(String uri, String localName, String qName) {
            this.currentVocabItem = null;
        }

        public void startElement(String uri, String name, String qName, Attributes atts) {
            if (name.equals("Entry")) {
                String vocabName = atts.getValue("Value");
                String vocabCode = atts.getValue("Code");
                String followUpVocab = atts.getValue("FollowUp");
                if (vocabName != null) {
                    this.currentVocabItem = new ArbilVocabularyItem(vocabName, vocabCode, followUpVocab);
                    this.collectedVocab.getVocabularyItemsUnfiltered().add(this.currentVocabItem);
                } else {
                    bugCatcher.logError(new Exception("Vocabulary item has no name in " + this.collectedVocab.getVocabularyUrl()));
                }
            }
        }
    }
}

