/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.util.BugCatcher;

public class ArbilFieldViews {
    protected static final String SAVED_FIELDVIEWS_FILE = "savedFieldViewsV3";
    private Hashtable<String, ArbilFieldView> savedFieldViews;
    private String currentGlobalViewName = "";
    private static ArbilFieldViews singleInstance = null;
    private static BugCatcher bugCatcher;

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static synchronized ArbilFieldViews getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilFieldViews();
        }
        return singleInstance;
    }

    private ArbilFieldViews() {
        this.loadArbilFieldViews();
    }

    public ArbilFieldView getView(String viewName) {
        return this.savedFieldViews.get(viewName);
    }

    public ArbilFieldView getCurrentGlobalView() {
        ArbilFieldView fieldView = this.savedFieldViews.get(this.currentGlobalViewName);
        if (fieldView == null) {
            return new ArbilFieldView();
        }
        return fieldView;
    }

    public String getCurrentGlobalViewName() {
        return this.currentGlobalViewName;
    }

    public void setCurrentGlobalViewName(String nextViewName) {
        this.currentGlobalViewName = nextViewName;
        ArbilSessionStorage.getSingleInstance().saveString("currentGlobalViewName", this.currentGlobalViewName);
    }

    public Enumeration getSavedFieldViewLables() {
        return this.savedFieldViews.keys();
    }

    private void loadArbilFieldViews() {
        try {
            this.savedFieldViews = (Hashtable)ArbilSessionStorage.getSingleInstance().loadObject(SAVED_FIELDVIEWS_FILE);
        }
        catch (Exception ex) {
            bugCatcher.logError("load savedFieldViews failed", ex);
            this.savedFieldViews = new Hashtable();
            this.createDefaultFieldViews();
        }
        try {
            this.currentGlobalViewName = ArbilSessionStorage.getSingleInstance().loadString("currentGlobalViewName");
            if (this.currentGlobalViewName == null) {
                this.currentGlobalViewName = (String)ArbilSessionStorage.getSingleInstance().loadObject("currentGlobalViewName");
            }
        }
        catch (Exception ex) {
            bugCatcher.logError("load currentGlobalViewName failed ", ex);
            if (this.savedFieldViews.isEmpty()) {
                this.createDefaultFieldViews();
            }
            this.currentGlobalViewName = this.savedFieldViews.keys().nextElement();
            ArbilSessionStorage.getSingleInstance().saveString("currentGlobalViewName", this.currentGlobalViewName);
        }
    }

    private void createDefaultFieldViews() {
        ArbilFieldView currentGlobalView = new ArbilFieldView();
        this.addArbilFieldView("All", currentGlobalView);
        ArbilFieldView fewFieldView = new ArbilFieldView();
        fewFieldView.setShowOnlyColumns(new String[]{"Name", "Description", "Title"});
        this.addArbilFieldView("Minimal", fewFieldView);
    }

    public void saveViewsToFile() {
        try {
            ArbilSessionStorage.getSingleInstance().saveObject(this.savedFieldViews, SAVED_FIELDVIEWS_FILE);
        }
        catch (Exception ex) {
            bugCatcher.logError(ex);
        }
    }

    public boolean addArbilFieldView(String viewLabel, ArbilFieldView fieldView) {
        if (!this.savedFieldViews.containsKey(viewLabel)) {
            this.savedFieldViews.put(viewLabel, fieldView);
            this.saveViewsToFile();
            return true;
        }
        return false;
    }
}

