/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.util.Enumeration;
import javax.swing.table.DefaultTableModel;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilWindowManager;

public class ArbilFieldViewTableModel
extends DefaultTableModel {
    private final ArbilTableModel imdiTableModel;
    Class[] types = new Class[]{String.class, Boolean.class, Boolean.class, String.class};
    private int showOnlyEnabledCount = -1;
    private static final int fieldNameColumn = 0;
    private static final int showOnlyColumn = 1;
    private static final int hideColumn = 2;
    private static final int widthColumn = 3;

    public ArbilFieldViewTableModel(ArbilTableModel imdiTableModel) {
        this.imdiTableModel = imdiTableModel;
        this.setColumnIdentifiers(new String[]{"Column Name", "Show Only", "Hide", "Column width"});
        ArbilFieldView currentView = imdiTableModel.getFieldView();
        if (currentView != null) {
            Enumeration knownColumnNames = currentView.getKnownColumns();
            while (knownColumnNames.hasMoreElements()) {
                String currentFieldName = knownColumnNames.nextElement().toString();
                this.addRow(new Object[]{currentFieldName, currentView.isShowOnlyColumn(currentFieldName), currentView.isHiddenColumn(currentFieldName), this.widthToString(currentView.getColumnWidth(currentFieldName))});
            }
        }
    }

    public Class getColumnClass(int columnIndex) {
        return this.types[columnIndex];
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 2) {
            if (this.showOnlyEnabledCount < 0) {
                this.showOnlyEnabledCount = 0;
                for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
                    if (!this.getValueAt(rowCounter, 1).equals(true)) continue;
                    ++this.showOnlyEnabledCount;
                }
            }
            return this.showOnlyEnabledCount == 0;
        }
        return column == 1 || column == 2 || column == 3;
    }

    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        this.showOnlyEnabledCount = -1;
        boolean booleanState = Boolean.TRUE.equals(aValue);
        String targetColumnName = this.getValueAt(row, 0).toString();
        switch (column) {
            case 1: {
                if (booleanState) {
                    this.imdiTableModel.getFieldView().addShowOnlyColumn(targetColumnName);
                    break;
                }
                this.imdiTableModel.getFieldView().removeShowOnlyColumn(targetColumnName);
                break;
            }
            case 2: {
                if (booleanState) {
                    this.imdiTableModel.getFieldView().addHiddenColumn(targetColumnName);
                    break;
                }
                this.imdiTableModel.getFieldView().removeHiddenColumn(targetColumnName);
                break;
            }
            case 3: {
                String intString;
                if (aValue != null && aValue instanceof String && (intString = ((String)aValue).trim()).length() > 0) {
                    try {
                        Integer width = Integer.parseInt((String)aValue);
                        this.imdiTableModel.setPreferredColumnWidth(targetColumnName, width);
                    }
                    catch (NumberFormatException ex) {
                        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Invalid width for column " + targetColumnName, "Column width invalid");
                    }
                    break;
                }
                this.imdiTableModel.setPreferredColumnWidth(targetColumnName, null);
            }
        }
        this.imdiTableModel.requestReloadTableData();
        this.fireTableStructureChanged();
    }

    private String widthToString(Integer width) {
        if (width == null) {
            return "";
        }
        return String.valueOf(width);
    }
}

