/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilTableCell;
import nl.mpi.arbil.ui.ArbilFieldPlaceHolder;
import nl.mpi.arbil.ui.ArbilIconCellPanel;

public class ArbilTableCellRenderer
extends DefaultTableCellRenderer {
    private ArbilTableCell cellObject;
    boolean isCellSelected = false;

    public int getRequiredWidth(FontMetrics fontMetrics) {
        Icon icon;
        String currentCellString = this.getText();
        int width = fontMetrics.stringWidth(currentCellString);
        if (this.getCellContent() instanceof ArbilField && (icon = ArbilIcons.getSingleInstance().getIconForField((ArbilField)this.getCellContent())) != null) {
            width += icon.getIconWidth();
        }
        return width;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Icon icon;
        this.isCellSelected = isSelected;
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.getCellContent() instanceof ArbilField && (icon = ArbilIcons.getSingleInstance().getIconForField((ArbilField)this.getCellContent())) != null) {
            return new ArbilIconCellPanel(component, icon);
        }
        return component;
    }

    public ArbilTableCellRenderer() {
    }

    public ArbilTableCellRenderer(ArbilTableCell cellObject) {
        this.setValue(cellObject);
    }

    protected final void setValue(Object value) {
        super.setValue(value);
        this.cellObject = (ArbilTableCell)value;
        if (this.getCellContent() instanceof ArbilField[]) {
            int greyTone = 150;
            super.setForeground(new Color(greyTone, greyTone, greyTone));
        }
        if (!this.isCellSelected) {
            if (this.getCellContent() instanceof ArbilFieldPlaceHolder || this.getCellContent() instanceof String && "".equals(this.getCellContent())) {
                super.setBackground(new Color(230, 230, 230));
            } else if (this.getCellContent() instanceof ArbilField && ((ArbilField)this.getCellContent()).fieldNeedsSaveToDisk()) {
                super.setForeground(Color.blue);
            }
        }
    }

    public Icon getIcon() {
        if (this.getCellContent() instanceof ArbilDataNode) {
            return ((ArbilDataNode)this.getCellContent()).getIcon();
        }
        if (this.getCellContent() instanceof ArbilDataNode[]) {
            return ArbilIcons.getSingleInstance().getIconForNode((ArbilDataNode[])this.getCellContent());
        }
        if (this.getCellContent() instanceof ArbilField[]) {
            return null;
        }
        return null;
    }

    public String getText() {
        if (this.cellObject == null) {
            return super.toString();
        }
        if (this.getCellContent() instanceof ArbilField && ((ArbilField)this.getCellContent()).isRequiredField() && ((ArbilField)this.getCellContent()).getFieldValue().length() == 0) {
            super.setForeground(Color.RED);
        } else if (this.getCellContent() instanceof ArbilField && !((ArbilField)this.getCellContent()).fieldValueValidates()) {
            super.setForeground(Color.RED);
        }
        return this.cellObject.toString();
    }

    private Object getCellContent() {
        if (this.cellObject == null) {
            return null;
        }
        return this.cellObject.getContent();
    }
}

