/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.clarin.profiles.CmdiProfileProvider;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.TemplateDialogue;
import nl.mpi.arbil.util.MessageDialogHandler;

public class CmdiProfilesPanel
extends JPanel {
    private final JDialog parentFrame;
    private final MessageDialogHandler dialogHandler;
    private JPanel clarinPanel;
    private JPanel profileReloadPanel;
    private JProgressBar profileReloadProgressBar;
    protected JCheckBox profileSelectionCheckBox;
    private JScrollPane clarinScrollPane;
    private JButton reloadListButton;
    private JButton reloadProfilesButton;
    private JButton downloadAllButton;
    private JTextArea profileInstructionsArea;
    private boolean firstLoad = true;

    public CmdiProfilesPanel(JDialog parentFrameLocal, MessageDialogHandler dialogHandler) {
        this.parentFrame = parentFrameLocal;
        this.dialogHandler = dialogHandler;
        this.profileReloadPanel = new JPanel();
        this.profileReloadProgressBar = new JProgressBar();
        this.clarinScrollPane = new JScrollPane();
        this.profileSelectionCheckBox = new JCheckBox();
        this.reloadListButton = new JButton();
        this.reloadProfilesButton = new JButton();
        this.downloadAllButton = new JButton();
        this.clarinPanel = new JPanel();
        JPanel profileReloadTopPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.profileReloadPanel.setLayout(new BorderLayout());
        this.profileReloadPanel.setAlignmentX(2.0f);
        profileReloadTopPanel.setLayout(new BoxLayout(profileReloadTopPanel, 2));
        this.reloadListButton.setText("Refresh list");
        this.reloadListButton.setToolTipText("Download the latest clarin profiles");
        this.reloadListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmdiProfilesPanel.this.reloadListButtonActionPerformed(evt);
            }
        });
        this.reloadProfilesButton.setText("Reload selection");
        this.reloadProfilesButton.setToolTipText("Clear cached copies and re-download the selected profiles");
        this.reloadProfilesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmdiProfilesPanel.this.reloadProfilesButtonActionPerformed(evt);
            }
        });
        this.downloadAllButton.setText("Download all");
        this.downloadAllButton.setToolTipText("Download all profiles for offline use (including unselected profiles)");
        this.downloadAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmdiProfilesPanel.this.downloadAllButtonActionPerformed(evt);
            }
        });
        this.profileSelectionCheckBox.setText("Only load profiles selected for manual editing");
        this.profileSelectionCheckBox.setSelected(CmdiProfileReader.getSingleInstance().getSelection() == CmdiProfileReader.ProfileSelection.SELECTED);
        profileReloadTopPanel.add(this.reloadListButton);
        profileReloadTopPanel.add(this.reloadProfilesButton);
        profileReloadTopPanel.add(this.downloadAllButton);
        profileReloadTopPanel.add(this.profileReloadProgressBar);
        this.profileReloadPanel.add((Component)profileReloadTopPanel, "Center");
        this.profileReloadPanel.add((Component)this.profileSelectionCheckBox, "South");
        this.add((Component)this.profileReloadPanel, "Last");
        this.clarinScrollPane.setViewportView(this.clarinPanel);
        this.add((Component)this.clarinScrollPane, "Center");
        this.profileInstructionsArea = new JTextArea("Profiles selected below will become available in the 'Add' menu of the local corpus. By default, only selected profiles will be downloaded for offline use.");
        this.profileInstructionsArea.setEditable(false);
        this.profileInstructionsArea.setLineWrap(true);
        this.profileInstructionsArea.setWrapStyleWord(true);
        this.profileInstructionsArea.setOpaque(false);
        JPanel profilesTopButtonsPanel = new JPanel();
        profilesTopButtonsPanel.setLayout(new BoxLayout(profilesTopButtonsPanel, 2));
        JButton addButton = new JButton();
        addButton.setText("Add URL");
        addButton.setToolTipText("Add a profile URL to the list");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String newDirectoryName = JOptionPane.showInputDialog(ArbilWindowManager.getSingleInstance().linorgFrame, "Enter the profile URL", "Add Profile", -1, null, null, null).toString();
                ArbilTemplateManager.getSingleInstance().addSelectedTemplates("custom:" + newDirectoryName);
                CmdiProfilesPanel.this.populateList();
            }
        });
        profilesTopButtonsPanel.add(addButton);
        JButton browseButton = new JButton();
        browseButton.setText("Add File");
        browseButton.setToolTipText("Browse for local profiles");
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (File selectedFile : ArbilWindowManager.getSingleInstance().showFileSelectBox("Select Profile", false, true, false)) {
                    ArbilTemplateManager.getSingleInstance().addSelectedTemplates("custom:" + selectedFile.toURI().toString());
                }
                CmdiProfilesPanel.this.populateList();
            }
        });
        profilesTopButtonsPanel.add(browseButton);
        JPanel profilesTopPanel = new JPanel();
        profilesTopPanel.setLayout(new BoxLayout(profilesTopPanel, 1));
        this.profileInstructionsArea.setAlignmentX(0.0f);
        profilesTopButtonsPanel.setAlignmentX(0.0f);
        profilesTopPanel.add(this.profileInstructionsArea);
        profilesTopPanel.add(profilesTopButtonsPanel);
        this.add((Component)profilesTopPanel, "First");
    }

    public void downloadProfiles(boolean forceUpdate) {
        this.loadProfiles(forceUpdate, true);
    }

    public void loadProfileDescriptions(boolean forceUpdate) {
        this.loadProfiles(forceUpdate, false);
    }

    public void setInstructionsVisible(boolean visible) {
        this.profileInstructionsArea.setVisible(visible);
    }

    private void showProgressBar(boolean show) {
        this.reloadListButton.setVisible(!show);
        this.reloadProfilesButton.setVisible(!show);
        this.downloadAllButton.setVisible(!show);
        this.profileSelectionCheckBox.setEnabled(!show);
        this.profileReloadProgressBar.setVisible(show);
    }

    private void loadProfiles(final boolean forceUpdate, final boolean updateProfilesCache) {
        CmdiProfileReader.getSingleInstance().setSelection(this.profileSelectionCheckBox.isSelected() ? CmdiProfileReader.ProfileSelection.SELECTED : CmdiProfileReader.ProfileSelection.ALL);
        this.clarinPanel.removeAll();
        this.clarinPanel.add(new JTextField("Loading, please wait..."));
        this.showProgressBar(true);
        this.doLayout();
        new Thread("loadProfiles"){

            public void run() {
                CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
                if (updateProfilesCache) {
                    cmdiProfileReader.refreshProfilesAndUpdateCache(CmdiProfilesPanel.this.profileReloadProgressBar, forceUpdate);
                } else {
                    cmdiProfileReader.refreshProfiles(forceUpdate);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CmdiProfilesPanel.this.showProgressBar(false);
                        CmdiProfilesPanel.this.populateList();
                        CmdiProfilesPanel.this.doLayout();
                    }
                });
            }
        }.start();
    }

    private void reloadListButtonActionPerformed(ActionEvent evt) {
        this.loadProfileDescriptions(true);
    }

    private void reloadProfilesButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CmdiProfilesPanel.this.showProgressBar(true);
                CmdiProfilesPanel.this.profileReloadProgressBar.setIndeterminate(true);
                CmdiProfilesPanel.this.profileReloadProgressBar.setString("");
                CmdiProfilesPanel.this.doLayout();
            }
        });
        new Thread(){

            public void run() {
                final List<String> profilesToReload = ArbilTemplateManager.getSingleInstance().getCMDIProfileHrefs();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CmdiProfilesPanel.this.profileReloadProgressBar.setIndeterminate(false);
                        CmdiProfilesPanel.this.profileReloadProgressBar.setMinimum(0);
                        CmdiProfilesPanel.this.profileReloadProgressBar.setMaximum(profilesToReload.size() + 1);
                        CmdiProfilesPanel.this.profileReloadProgressBar.setValue(1);
                    }
                });
                for (String xsdHref : profilesToReload) {
                    CmdiProfileReader.getSingleInstance().storeProfileInCache(xsdHref, 0);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CmdiProfilesPanel.this.profileReloadProgressBar.setValue(CmdiProfilesPanel.this.profileReloadProgressBar.getValue() + 1);
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CmdiProfilesPanel.this.profileReloadProgressBar.setValue(0);
                        CmdiProfilesPanel.this.showProgressBar(false);
                        CmdiProfilesPanel.this.doLayout();
                        CmdiProfilesPanel.this.dialogHandler.addMessageDialogToQueue("The profiles have been re-downloaded. You need to restart Arbil in order to apply any changes.", "Restart Arbil");
                    }
                });
            }
        }.start();
    }

    private void downloadAllButtonActionPerformed(ActionEvent evt) {
        this.downloadProfiles(true);
    }

    public synchronized void populateList() {
        this.populateProfilesList();
        if (this.firstLoad) {
            this.parentFrame.pack();
            TemplateDialogue.setDialogHeight(this.parentFrame);
            this.firstLoad = false;
        }
    }

    protected void populateProfilesList() {
        List<String> selectedTemplates = ArbilTemplateManager.getSingleInstance().getSelectedTemplates();
        ArrayList<JCheckBox> checkBoxArray = new ArrayList<JCheckBox>();
        CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
        for (CmdiProfileProvider.CmdiProfile currentCmdiProfile : cmdiProfileReader.cmdiProfileArray) {
            String templateId = "clarin:" + currentCmdiProfile.getXsdHref();
            JCheckBox clarinProfileCheckBox = new JCheckBox();
            clarinProfileCheckBox.setText(currentCmdiProfile.name);
            clarinProfileCheckBox.setName(currentCmdiProfile.name);
            clarinProfileCheckBox.setActionCommand(templateId);
            clarinProfileCheckBox.setSelected(selectedTemplates.contains(templateId));
            clarinProfileCheckBox.setToolTipText(currentCmdiProfile.description);
            clarinProfileCheckBox.addActionListener(TemplateDialogue.templateSelectionListener);
            clarinProfileCheckBox.addActionListener(new DownloadSchemaActionListener(clarinProfileCheckBox, cmdiProfileReader, currentCmdiProfile.getXsdHref()));
            checkBoxArray.add(clarinProfileCheckBox);
        }
        for (String currentSepectedProfile : selectedTemplates) {
            if (!currentSepectedProfile.startsWith("custom:")) continue;
            String customUrlString = currentSepectedProfile.substring("custom:".length());
            String customName = currentSepectedProfile.replaceAll("[/.]xsd$", "");
            if (customName.contains("/")) {
                customName = customName.substring(customName.lastIndexOf("/") + 1);
            }
            JCheckBox clarinProfileCheckBox = new JCheckBox();
            clarinProfileCheckBox.setText(customName);
            clarinProfileCheckBox.setName(customName);
            clarinProfileCheckBox.setActionCommand(currentSepectedProfile);
            clarinProfileCheckBox.setSelected(true);
            clarinProfileCheckBox.setToolTipText("custom profile, uncheck to remove");
            clarinProfileCheckBox.addActionListener(TemplateDialogue.templateSelectionListener);
            clarinProfileCheckBox.addActionListener(new DownloadSchemaActionListener(clarinProfileCheckBox, cmdiProfileReader, customUrlString));
            checkBoxArray.add(clarinProfileCheckBox);
        }
        TemplateDialogue.addSorted(this.clarinPanel, checkBoxArray);
    }

    private static class DownloadSchemaActionListener
    implements ActionListener {
        private CmdiProfileReader reader;
        private String url;
        private JCheckBox checkBox;

        public DownloadSchemaActionListener(JCheckBox clarinProfileCheckBox, CmdiProfileReader reader, String url) {
            this.reader = reader;
            this.url = url;
            this.checkBox = clarinProfileCheckBox;
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(){

                public void run() {
                    if (DownloadSchemaActionListener.this.checkBox.isSelected()) {
                        DownloadSchemaActionListener.this.reader.storeProfileInCache(DownloadSchemaActionListener.this.url, 0);
                    }
                }
            }.start();
        }
    }
}

