/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.util.regex.Pattern;
import nl.mpi.corpusstructure.UnknownNodeException;
import org.apache.log4j.Logger;

public class NodeIdUtils {
    protected static Logger logger = Logger.getLogger((String)NodeIdUtils.class.getName());
    private static Pattern nodeIdPattern = null;

    public static void setLogger(Logger l) {
        logger = l;
    }

    public static boolean isNodeId(String nodeId) {
        if (nodeId == null) {
            return false;
        }
        if (nodeIdPattern == null) {
            nodeIdPattern = Pattern.compile("^MPI\\d\\d*#$");
        }
        return nodeIdPattern.matcher(nodeId).matches();
    }

    public static String TONODEID(long n) {
        if (n < 0L) {
            return "INVALID";
        }
        return "MPI" + n + '#';
    }

    public static String TONODEID(int n) {
        if (n < 0) {
            return "INVALID";
        }
        return "MPI" + n + '#';
    }

    public static int TOINT(String nodeId) throws UnknownNodeException {
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error((Object)("NodeIdUtils: TOINT: ERROR: not a NodeId: " + nodeId));
            throw new UnknownNodeException("TOINT: invalid NodeId: " + nodeId);
        }
        try {
            String s = nodeId.substring(3, nodeId.length() - 1);
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)("NodeIdUtils: TOINT: ERROR: unexpected NodeId: " + nodeId + " "), (Throwable)nfe);
            throw new UnknownNodeException("TOINT: unparseable NodeId: " + nodeId);
        }
    }

    public static String nodeIdToHandle(String nodeid, String prefix) throws UnknownNodeException {
        int nodenumber = NodeIdUtils.TOINT(nodeid);
        if (prefix == null) {
            logger.debug((Object)("nodeIdToHandle: No prefix -> no handle. Node: " + nodenumber));
            return null;
        }
        return NodeIdUtils.nodeToHandle(nodenumber, prefix);
    }

    public static String nodeToHandle(int nodenumber, String prefix) {
        if (nodenumber < 0) {
            logger.error((Object)("NodeIdUtils: nodeToHandle: ERROR: node number must not be negative: " + nodenumber));
            return prefix + "/ERROR";
        }
        String hex = "00000000" + Integer.toHexString(nodenumber).toUpperCase();
        hex = hex.substring(hex.length() - 8);
        String handle = prefix + "/00-0000-0000-" + hex.substring(0, 4) + "-" + hex.substring(4) + "-";
        int check = 16;
        for (int n = 17; n >= 0; --n) {
            int digit = nodenumber >> 4 * n & 0xF;
            if ((digit = digit + check & 0xF) == 0) {
                digit = 16;
            }
            if ((digit *= 2) >= 17) {
                digit -= 17;
            }
            check = digit;
        }
        check = 17 - check & 0xF;
        return handle + Integer.toHexString(check).toUpperCase();
    }

    public static String handleToPrefix(String handle) {
        int where;
        if (handle == null) {
            return new String("0");
        }
        if (handle.startsWith("hdl:")) {
            handle = handle.substring(4);
        }
        if ((where = handle.indexOf(47)) < 1) {
            logger.error((Object)("NodeIdUtils: handleToPrefix: ERROR: unexpected handle: " + handle));
            return new String("0");
        }
        return handle.substring(0, where);
    }

    public static int handleToNode(String handle, String prefix) {
        if (handle == null || prefix == null) {
            return -1;
        }
        if (handle.startsWith("hdl:")) {
            handle = handle.substring(4);
        }
        while (handle.startsWith("/")) {
            handle = handle.substring(1);
        }
        if (!prefix.equals(NodeIdUtils.handleToPrefix(handle))) {
            logger.error((Object)("NodeIdUtils: handleToNode: ERROR: not in our domain: " + handle + " expected: " + prefix + "/..."));
            return -1;
        }
        int where = handle.indexOf(47);
        String suffix = handle.substring(where + 1);
        if (!suffix.startsWith("00-0000-0000-") || suffix.length() != 24) {
            logger.error((Object)("NodeIdUtils: handleToNode: ERROR: no standard URID: " + handle));
            return -1;
        }
        String numSuffix = suffix.substring(13, suffix.length() - 2);
        String numHex = numSuffix.substring(0, 4) + numSuffix.substring(5);
        try {
            return Integer.parseInt(numHex, 16);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)("NodeIdUtils: handleToNode: ERROR: unexpected URID: " + handle + " "), (Throwable)nfe);
            return -1;
        }
    }

    public static String handleToNodeId(String handle, String prefix) {
        int node = NodeIdUtils.handleToNode(handle, prefix);
        return NodeIdUtils.TONODEID(node);
    }

    public static String standardizePID(String pid) {
        String _pid = pid;
        if (_pid.startsWith("hdl:")) {
            _pid = _pid.substring("hdl:".length());
        }
        while (_pid.startsWith("/")) {
            _pid = _pid.substring(1);
        }
        return _pid;
    }

    public static String formatPIDForStorage(String pid, String prefix) {
        if (NodeIdUtils.isValidString(pid) && !pid.startsWith("hdl:") && NodeIdUtils.doesPIDPrefixMatch(pid, prefix)) {
            return "hdl:" + pid;
        }
        return pid;
    }

    public static boolean arePIDsEqual(String pid1, String pid2) {
        if (!NodeIdUtils.isValidString(pid1) || !NodeIdUtils.isValidString(pid2)) {
            return false;
        }
        return (pid1 = NodeIdUtils.standardizePID(pid1)).equals(pid2 = NodeIdUtils.standardizePID(pid2));
    }

    public static boolean doesPIDPrefixMatch(String pid, String prefix) {
        if (!NodeIdUtils.isValidString(pid) || !NodeIdUtils.isValidString(prefix)) {
            return false;
        }
        pid = NodeIdUtils.standardizePID(pid);
        String pidPrefix = NodeIdUtils.handleToPrefix(pid);
        return pidPrefix.equals(prefix);
    }

    private static boolean isValidString(String arg) {
        return arg != null && arg.length() > 0;
    }
}

