/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.Util;
import net.handle.server.TransactionQueue;

public class PushTransactionsHS {
    private TransactionQueueInterface _txnQueue = null;
    private long _txnId = -1L;
    private boolean _syncAtOnce = false;
    private File _serverDir = null;
    private File _txnIdFile = null;

    public PushTransactionsHS(File serverDirectory, boolean synced) throws IOException {
        this._serverDir = serverDirectory;
        this._syncAtOnce = synced;
        this.openTxnQueue();
        this._txnIdFile = new File(this._serverDir, "txn_id");
        if (!this._txnIdFile.exists()) {
            FileWriter fw = new FileWriter(this._txnIdFile);
            fw.write(String.valueOf(0));
            fw.close();
        }
        if (!this._txnIdFile.canWrite() || !this._txnIdFile.canRead()) {
            throw new IOException("R/W access needed: " + this._txnIdFile);
        }
    }

    public void shutdown() {
        this.close();
    }

    public void close() {
        if (this._txnQueue == null) {
            return;
        }
        try {
            this._txnQueue.shutdown();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this._txnQueue = null;
        this._serverDir = null;
    }

    public synchronized void sync() throws IOException {
        if (this._txnQueue == null) {
            return;
        }
        try {
            this._txnQueue.shutdown();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this._txnQueue = null;
        this.openTxnQueue();
    }

    public void deletedAllHandles() throws IOException {
        this.enqueueTransaction(Common.BLANK_HANDLE, (byte)6);
    }

    public void handleCreated(String handle) throws IOException {
        this.enqueueTransaction(Util.encodeString((String)handle), (byte)1);
    }

    public void handleDeleted(String handle) throws IOException {
        this.enqueueTransaction(Util.encodeString((String)handle), (byte)2);
    }

    public void handleUpdated(String handle) throws IOException {
        this.enqueueTransaction(Util.encodeString((String)handle), (byte)3);
    }

    private void enqueueTransaction(byte[] handle, byte action) throws IOException {
        try {
            this._txnQueue.addTransaction(this.getNextTxnId(), handle, action, System.currentTimeMillis());
        }
        catch (HandleException he) {
            throw new IOException("enqueueTransaction(" + Util.decodeString((byte[])handle) + ", " + action + ") " + he.toString());
        }
        catch (Exception e) {
            throw new IOException("enqueueTransaction(" + Util.decodeString((byte[])handle) + ", " + action + ") Exception: " + e);
        }
        if (this._syncAtOnce) {
            this.sync();
        }
    }

    private synchronized long getNextTxnId() throws IOException {
        if (this._syncAtOnce) {
            this._txnId = this._txnQueue.getLastTxnId();
        }
        ++this._txnId;
        FileWriter fw = new FileWriter(this._txnIdFile);
        fw.write(String.valueOf(this._txnId));
        fw.close();
        return this._txnId;
    }

    private synchronized void openTxnQueue() throws IOException {
        try {
            this._txnQueue = new TransactionQueue(new File(this._serverDir, "txns"));
            this._txnId = this._txnQueue.getLastTxnId();
        }
        catch (Exception e) {
            throw new IOException("Failed to open transaction queue: " + e);
        }
    }
}

