/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.Util;
import net.handle.security.HdlSecurityProvider;
import net.handle.server.ServerSideSessionInfo;
import net.handle.util.IntTable;

public class SessionManager {
    public final String RSA_PRIVATE_KEY_FILE = "rsapriv.bin";
    public final String RSA_PUBLIC_KEY_FILE = "rsapub.bin";
    PublicKey rsaPubKey = null;
    PrivateKey rsaPrivKey = null;
    private static int maxAnonymousSession = 10;
    private Hashtable sessionInfoDict = new Hashtable(10);
    private Hashtable sessionOptionsDict = new Hashtable(10);
    private SessionSetupInfo anonymousSessionOption = null;
    private IntTable anonymousSessionDict = new IntTable(10);
    private boolean keepRunning = true;
    private static Random sessionRandom;
    private static String sessionRandomLock;
    public static final int SESSION_NOT_AVAILABLE = -100;
    public static final int SESSION_MAXNUM_PER_SERVER = 10;

    public ServerSideSessionInfo getSession(int sessionId) {
        ServerSideSessionInfo ssinfo = (ServerSideSessionInfo)this.sessionInfoDict.get(new Integer(sessionId));
        if (ssinfo != null) {
            ssinfo.touch();
            return ssinfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(int sessionId) {
        Hashtable hashtable = this.sessionInfoDict;
        synchronized (hashtable) {
            this.sessionInfoDict.remove(new Integer(sessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceServerSideSessionInfo(int sessionId, ServerSideSessionInfo newInfo) {
        if (newInfo == null) {
            System.err.println("The new session info is null. No info is replaced.");
            return true;
        }
        if (newInfo instanceof ServerSideSessionInfo) {
            Hashtable hashtable = this.sessionInfoDict;
            synchronized (hashtable) {
                this.sessionInfoDict.remove(new Integer(sessionId));
                this.sessionInfoDict.put(new Integer(sessionId), newInfo);
            }
            newInfo.touch();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSession(ServerSideSessionInfo sessionInfo) throws HandleException {
        if (sessionInfo == null) {
            return true;
        }
        ServerSideSessionInfo ssinfo = sessionInfo;
        Hashtable hashtable = this.sessionInfoDict;
        synchronized (hashtable) {
            this.sessionInfoDict.put(new Integer(ssinfo.sessionId), ssinfo);
        }
        sessionInfo.touch();
        return true;
    }

    public void checkTimeoutSession() {
        CheckSessionTimeOut cst = new CheckSessionTimeOut();
        cst.setDaemon(true);
        cst.setPriority(1);
        cst.start();
    }

    public Vector getSessions() {
        Vector<ServerSideSessionInfo> vecSessions = new Vector<ServerSideSessionInfo>();
        Enumeration enumSession = this.sessionInfoDict.elements();
        while (enumSession.hasMoreElements()) {
            ServerSideSessionInfo sssinfo = (ServerSideSessionInfo)enumSession.nextElement();
            vecSessions.addElement(sssinfo);
        }
        return vecSessions;
    }

    public Vector getSessions(AuthenticationInfo info) {
        if (info != null) {
            return this.getSessions(info.getUserIdHandle(), info.getUserIdIndex());
        }
        return null;
    }

    public Vector getSessions(byte[] identityHandle, int identityIndex) {
        Vector<ServerSideSessionInfo> vecSessions = new Vector<ServerSideSessionInfo>();
        Enumeration enumSession = this.sessionInfoDict.elements();
        while (enumSession.hasMoreElements()) {
            ServerSideSessionInfo sssinfo = (ServerSideSessionInfo)enumSession.nextElement();
            if (!Util.equals(sssinfo.identityKeyHandle, identityHandle) || sssinfo.identityKeyIndex != identityIndex) continue;
            vecSessions.addElement(sssinfo);
        }
        return vecSessions;
    }

    public Enumeration getAllKeys() {
        return this.sessionInfoDict.keys();
    }

    public void finalize() {
        try {
            this.shutdown();
        }
        catch (Throwable t) {
            System.err.println("Error finalizing session manager: " + t);
        }
    }

    public synchronized void shutdown() {
        if (!this.keepRunning) {
            return;
        }
        this.keepRunning = false;
    }

    public static final byte[] getGeneratedSecretKey() throws HandleException {
        byte[] sessionKey = new byte[512];
        SessionManager.getSessionRandom().nextBytes(sessionKey);
        return sessionKey;
    }

    public static final void initializeSessionKeyRandom() {
        SessionManager.initializeSessionKeyRandom(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void initializeSessionKeyRandom(byte[] seed) {
        if (sessionRandom == null) {
            String string = sessionRandomLock;
            synchronized (string) {
                if (sessionRandom == null) {
                    sessionRandom = seed == null ? new SecureRandom() : new SecureRandom(seed);
                    sessionRandom.nextInt();
                }
            }
        }
    }

    private static Random getSessionRandom() {
        if (sessionRandom == null) {
            SessionManager.initializeSessionKeyRandom();
        }
        return sessionRandom;
    }

    public boolean loadRSAKeys(byte[] secKey, File dir) {
        try {
            File rsaprivateKeyFile = new File(dir, "rsapriv.bin");
            if (rsaprivateKeyFile.exists() && rsaprivateKeyFile.canRead()) {
                int r;
                FileInputStream inRSA = new FileInputStream(rsaprivateKeyFile);
                byte[] rsaencKeyBytes = new byte[(int)rsaprivateKeyFile.length()];
                for (int n = 0; n < rsaencKeyBytes.length && (r = inRSA.read(rsaencKeyBytes, n, rsaencKeyBytes.length - n)) >= 0; n += r) {
                }
                byte[] rsakeyBytes = null;
                rsakeyBytes = Util.decrypt(rsaencKeyBytes, secKey);
                this.rsaPrivKey = Util.getPrivateKeyFromBytes(rsakeyBytes, 0);
                for (int i = 0; i < rsakeyBytes.length; ++i) {
                    rsakeyBytes[i] = 0;
                }
            }
            File rsapublicKeyFile = new File(dir, "rsapub.bin");
            if (rsaprivateKeyFile.exists() && rsaprivateKeyFile.canRead()) {
                byte[] pubkey = Util.getBytesFromFile(rsapublicKeyFile);
                try {
                    this.rsaPubKey = Util.getPublicKeyFromBytes(pubkey, 0);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    this.rsaPubKey = null;
                }
            }
            if (this.rsaPubKey != null && this.rsaPrivKey != null && Util.isMatchingKeyPair((RSAPublicKey)this.rsaPubKey, (RSAPrivateKey)this.rsaPrivKey)) {
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Unable to initialize server session exchange key      object.");
            e.printStackTrace(System.err);
            return false;
        }
        return false;
    }

    public boolean generateRSAKeys(byte[] secKey, File dir) {
        System.err.println("Generating RSA session exchange key...");
        try {
            HdlSecurityProvider cryptoProvider = HdlSecurityProvider.getInstance();
            if (cryptoProvider == null) {
                throw new HandleException(14, "Encryption/Key generation engine missing");
            }
            KeyPair keys = cryptoProvider.generateRSAKeyPair(1024);
            this.rsaPubKey = keys.getPublic();
            this.rsaPrivKey = keys.getPrivate();
        }
        catch (Exception e) {
            System.err.println("Unable to generate RSA session key: " + e);
            this.rsaPrivKey = null;
            this.rsaPubKey = null;
            return false;
        }
        try {
            File f = new File(dir, "rsapub.bin");
            Util.writeBytesToFile(f, Util.getBytesFromPublicKey(this.rsaPubKey));
            DataInputStream in = new DataInputStream(System.in);
            f = new File(dir, "rsapriv.bin");
            boolean encrypt = true;
            byte[] encKeyBytes = null;
            byte[] keyBytes = Util.getBytesFromPrivateKey(this.rsaPrivKey);
            if (secKey != null) {
                encKeyBytes = Util.encryptIfPossible(keyBytes, secKey);
                for (int i = 0; i < keyBytes.length; ++i) {
                    keyBytes[i] = 0;
                }
            } else {
                encKeyBytes = Util.encrypt(keyBytes, secKey, 1);
            }
            Util.writeBytesToFile(f, encKeyBytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    static {
        sessionRandomLock = "sessionRandomLock";
    }

    private class CheckSessionTimeOut
    extends Thread {
        private CheckSessionTimeOut() {
        }

        public void run() {
            while (SessionManager.this.keepRunning) {
                try {
                    Thread.sleep(60000L);
                    Enumeration enu = SessionManager.this.sessionInfoDict.keys();
                    while (enu.hasMoreElements()) {
                        Integer sessionId = (Integer)enu.nextElement();
                        ServerSideSessionInfo ssinfo = (ServerSideSessionInfo)SessionManager.this.sessionInfoDict.get(sessionId);
                        if (ssinfo == null || !ssinfo.hasExpired()) continue;
                        SessionManager.this.removeSession(sessionId);
                    }
                }
                catch (Throwable e) {
                    System.err.println("Error purging timeout session objects: " + e);
                }
            }
        }
    }
}

