/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.clarin.profiles.CmdiTemplate;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilDataNodeService;
import nl.mpi.arbil.data.ArbilDataNodeType;
import nl.mpi.arbil.data.ArbilFavouritesSorter;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilFieldComparator;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilNodeSorter;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.data.metadatafile.CmdiUtils;
import nl.mpi.arbil.data.metadatafile.ImdiUtils;
import nl.mpi.arbil.data.metadatafile.MetadataUtils;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.util.ArrayComparator;
import nl.mpi.arbil.util.MimeHashQueue;
import nl.mpi.flap.model.DataNodeType;
import nl.mpi.flap.model.FieldGroup;
import nl.mpi.flap.model.PluginDataNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilDataNode
extends ArbilNode
implements Comparable,
PluginDataNode {
    private static final Logger logger = LoggerFactory.getLogger(ArbilDataNode.class);
    private static final MetadataFormat metadataFormat = new MetadataFormat();
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private ArbilDataNodeService dataNodeService;
    public MetadataUtils metadataUtils;
    public ArbilTemplate nodeTemplate;
    private HashMap<String, ArbilField[]> fieldHashtable;
    protected ArbilDataNode[] childArray = new ArbilDataNode[0];
    private LoadingState loadingState = LoadingState.UNLOADED;
    private LoadingState requestedLoadingState = null;
    public int resourceFileServerResponse = -1;
    public String hashString;
    public String mpiMimeType = null;
    public String typeCheckerMessage;
    private MimeHashQueue.TypeCheckerState typeCheckerState = MimeHashQueue.TypeCheckerState.UNCHECKED;
    public int matchesInCache;
    public int matchesRemote;
    public int matchesLocalFileSystem;
    public boolean fileNotFound;
    public boolean isInfoLink = false;
    private boolean singletonMetadataNode = false;
    protected boolean nodeNeedsSaveToDisk;
    protected String nodeText;
    protected String lastNodeText = NODE_LOADING_TEXT;
    private final URI nodeUri;
    private boolean containerNode = false;
    public ArbilField resourceUrlField;
    private CmdiComponentLinkReader cmdiComponentLinkReader = null;
    private ImageIcon icon;
    private boolean nodeEnabled;
    public boolean hasSchemaError = false;
    protected List<String[]> childLinks = new ArrayList<String[]>();
    private int isLoadingCount = 0;
    private final Object loadingCountLock = new Object();
    @Deprecated
    public boolean lockedByLoadingThread = false;
    public String archiveHandle = null;
    public boolean hasDomIdAttribute = false;
    public boolean scrollToRequested = false;
    private ArbilDataNode domParentNode = null;
    public File thumbnailFile = null;
    private boolean resourceNode = false;
    private final Object domLockObjectPrivate = new Object();
    private static final String NODE_LOADING_TEXT = widgets.getString("LOADING NODE...");
    public static final String EMPTY_NODE_STRING_VALUE = "                      ";
    private MetadataFormat.FileType formatType = MetadataFormat.FileType.UNKNOWN;
    private Boolean isFavorite = null;
    private static ArbilNodeSorter dataNodeSorter = new ArbilNodeSorter();
    private static ArbilNodeSorter favouriteSorter = new ArbilFavouritesSorter();

    protected ArbilDataNode(ArbilDataNodeService dataNodeService, URI localUri, MetadataFormat.FileType formatType) {
        this.dataNodeService = dataNodeService;
        this.formatType = formatType;
        this.nodeUri = localUri;
        if (this.nodeUri != null) {
            this.metadataUtils = ArbilDataNode.getMetadataUtils(this.nodeUri.toString());
        }
        this.initNodeVariables();
    }

    public void setNodeText(String localNodeText) {
        if (this.nodeText == null) {
            this.nodeText = localNodeText;
        }
    }

    public static boolean isArbilDataNode(Object unknownObj) {
        if (unknownObj == null) {
            return false;
        }
        return unknownObj instanceof ArbilDataNode;
    }

    public static boolean isStringLocal(String urlString) {
        return urlString.startsWith("file:");
    }

    public static boolean isUriLocal(URI uri) {
        return uri.getScheme().equalsIgnoreCase("file");
    }

    public static boolean isPathHistoryFile(String urlString) {
        return MetadataFormat.isPathMetadata(urlString.replaceAll("mdi.[0-9]*$", "mdi"));
    }

    public static MetadataUtils getMetadataUtils(String urlString) {
        if (MetadataFormat.isPathCmdi(urlString)) {
            return new CmdiUtils();
        }
        if (MetadataFormat.isPathImdi(urlString)) {
            return new ImdiUtils();
        }
        return null;
    }

    public MetadataUtils getMetadataUtils() {
        return this.metadataUtils;
    }

    public boolean getNeedsSaveToDisk(boolean onlyOfSubNode) {
        if (this.nodeNeedsSaveToDisk && !this.getParentDomNode().nodeNeedsSaveToDisk) {
            this.nodeNeedsSaveToDisk = false;
        }
        if (onlyOfSubNode) {
            return this.nodeNeedsSaveToDisk;
        }
        return this.getParentDomNode().nodeNeedsSaveToDisk;
    }

    protected boolean isNeedsSaveToDisk() {
        return this.nodeNeedsSaveToDisk;
    }

    public boolean hasChangedFields() {
        for (ArbilField[] currentFieldArray : this.fieldHashtable.values()) {
            for (ArbilField currentField : currentFieldArray) {
                if (!currentField.fieldNeedsSaveToDisk()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasChangedFieldsInSubtree() {
        if (this.hasChangedFields()) {
            return true;
        }
        for (ArbilDataNode child : this.getChildArray()) {
            if (!child.hasChangedFieldsInSubtree()) continue;
            return true;
        }
        return false;
    }

    public void setDataNodeNeedsSaveToDisk(ArbilField originatingField, boolean updateUI) {
        this.dataNodeService.setDataNodeNeedsSaveToDisk(this, originatingField, updateUI);
    }

    public String getAnyMimeType() {
        ArbilField[] formatField;
        if (this.mpiMimeType == null && this.hasResource() && (formatField = this.getFieldArray("Format")) != null && formatField.length > 0) {
            return formatField[0].getFieldValue();
        }
        return this.mpiMimeType;
    }

    public void setMimeType(String[] typeCheckerMessageArray) {
        this.mpiMimeType = typeCheckerMessageArray[0];
        this.typeCheckerMessage = typeCheckerMessageArray[1];
        if (!this.isMetaDataNode() && this.isLocal() && this.mpiMimeType != null) {
            ArbilField mimeTypeField = new ArbilField(this.fieldHashtable.size(), this, "Format", this.mpiMimeType, 0, false, null, null);
            this.addField(mimeTypeField);
        }
    }

    private String getNodeTypeNameFromUriFragment(String nodeFragmentName) {
        if (nodeFragmentName == null) {
            return null;
        }
        nodeFragmentName = nodeFragmentName.substring(nodeFragmentName.lastIndexOf(".") + 1);
        nodeFragmentName = nodeFragmentName.replaceAll("\\(\\d+\\)", "");
        return nodeFragmentName;
    }

    protected final void initNodeVariables() {
        if (this.childArray != null) {
            for (ArbilDataNode currentNode : this.childArray) {
                if (!currentNode.isChildNode()) continue;
                currentNode.initNodeVariables();
            }
        }
        this.fieldHashtable = new HashMap();
        this.setLoadingState(LoadingState.UNLOADED);
        this.hashString = null;
        this.matchesInCache = 0;
        this.matchesRemote = 0;
        this.matchesLocalFileSystem = 0;
        this.fileNotFound = false;
        this.nodeNeedsSaveToDisk = false;
        this.icon = null;
        this.nodeEnabled = true;
        this.singletonMetadataNode = false;
        this.containerNode = false;
        if (this.nodeUri != null) {
            File fileObject;
            if (!this.isMetaDataNode() && this.isLocal() && (fileObject = this.getFile()) != null) {
                this.nodeText = fileObject.getName();
            }
            if (!this.isMetaDataNode() && this.nodeText == null) {
                this.nodeText = this.getUrlString();
            }
        }
    }

    public void reloadNodeShallowly() {
        this.dataNodeService.reloadNodeShallowly(this);
    }

    public void reloadNode() {
        this.dataNodeService.reloadNode(this);
    }

    public void loadArbilDom() {
        this.dataNodeService.loadArbilDom(this);
    }

    public void loadFullArbilDom() {
        this.dataNodeService.loadFullArbilDom(this);
    }

    @Override
    public int getChildCount() {
        return this.childArray.length;
    }

    @Override
    public ArbilDataNode[] getAllChildren() {
        ArrayList<ArbilDataNode> allChildren = new ArrayList<ArbilDataNode>();
        this.getAllChildren(allChildren);
        return allChildren.toArray(new ArbilDataNode[0]);
    }

    @Override
    public void getAllChildren(List<ArbilDataNode> allChildren) {
        logger.debug("getAllChildren: {}", (Object)this.getUrlString());
        if (this.isSession() || this.isCatalogue() || this.isChildNode() || this.isCmdiMetaDataNode()) {
            for (ArbilDataNode currentChild : this.childArray) {
                if (currentChild == this) continue;
                currentChild.getAllChildren(allChildren);
                allChildren.add(currentChild);
            }
        }
    }

    public ArbilDataNode[] getChildArray() {
        return this.childArray;
    }

    public List<? extends PluginDataNode> getChildList() {
        return Arrays.asList(this.getChildArray());
    }

    public ArbilDataNode[] getChildNodesArray(String childType) {
        for (ArbilDataNode currentNode : this.childArray) {
            if (!currentNode.toString().equals(childType)) continue;
            return currentNode.getChildArray();
        }
        return null;
    }

    public ArbilDataNode getChildByPath(String path) {
        if (this.childArray != null && this.childArray.length > 0) {
            for (ArbilDataNode child : this.childArray) {
                if (child.getURI() != null && path.equals(child.getURIFragment())) {
                    return child;
                }
                ArbilDataNode childMatch = child.getChildByPath(path);
                if (childMatch == null) continue;
                return childMatch;
            }
        }
        return null;
    }

    public String getNodePath() {
        String fragment = this.nodeUri.getFragment();
        if (fragment == null) {
            return null;
        }
        String startPath = MetadataFormat.getMetadataStartPath(this.nodeUri.getPath());
        if (fragment.startsWith(startPath) && fragment.length() > startPath.length()) {
            return fragment.substring(startPath.length() + 1);
        }
        return fragment;
    }

    public ArbilTemplate getNodeTemplate() {
        if (this.nodeTemplate != null && !this.isCorpus()) {
            return this.nodeTemplate;
        }
        if (this.isChildNode()) {
            return this.getParentDomNode().getNodeTemplate();
        }
        return ArbilTemplateManager.getSingleInstance().getDefaultTemplate();
    }

    public File getSubDirectory() {
        String currentFileName = this.getFile().getParent();
        if (MetadataFormat.isPathImdi(this.nodeUri.getPath()) || MetadataFormat.isPathCmdi(this.nodeUri.getPath())) {
            File destinationDir = new File(currentFileName = currentFileName + File.separatorChar + this.getFile().getName().substring(0, this.getFile().getName().length() - 5));
            if (!destinationDir.exists() && !destinationDir.mkdir()) {
                logger.error("Could not create directory {}", (Object)destinationDir.getAbsolutePath());
            }
            return destinationDir;
        }
        return new File(this.getFile().getParent());
    }

    public boolean containsFieldValue(String fieldName, String searchValue) {
        boolean findResult = false;
        String fieldNameLowerCase = fieldName.toLowerCase();
        for (String keyString : this.fieldHashtable.keySet()) {
            ArbilField[] currentFieldArray;
            if (!fieldNameLowerCase.equals(keyString.toLowerCase()) || (currentFieldArray = this.fieldHashtable.get(keyString)) == null) continue;
            for (ArbilField currentField : currentFieldArray) {
                logger.trace("containsFieldValue: {}:{}", (Object)currentField.getFieldValue(), (Object)searchValue);
                if (!currentField.getFieldValue().toLowerCase().contains(searchValue.toLowerCase())) continue;
                return true;
            }
        }
        logger.trace("result: {}:{}", (Object)findResult, (Object)this);
        return findResult;
    }

    public boolean containsFieldValue(String searchValue) {
        boolean findResult = false;
        for (ArbilField[] currentFieldArray : this.fieldHashtable.values()) {
            for (ArbilField currentField : currentFieldArray) {
                logger.trace("containsFieldValue: {}:{}", (Object)currentField.getFieldValue(), (Object)searchValue);
                if (!currentField.getFieldValue().toLowerCase().contains(searchValue.toLowerCase())) continue;
                return true;
            }
        }
        logger.trace("result: {}:{}", (Object)findResult, (Object)this);
        return findResult;
    }

    public boolean getNodeEnabled() {
        return this.nodeEnabled;
    }

    public boolean canHaveChildren() {
        return this.childArray.length > 0;
    }

    public void deleteCorpusLink(ArbilDataNode[] targetImdiNodes) {
        this.dataNodeService.deleteCorpusLink(this, targetImdiNodes);
    }

    @Override
    public boolean hasCatalogue() {
        for (ArbilDataNode childNode : this.childArray) {
            if (!childNode.isCatalogue()) continue;
            return true;
        }
        return false;
    }

    public boolean addCorpusLink(ArbilDataNode targetImdiNode) {
        return this.dataNodeService.addCorpusLink(this, targetImdiNode);
    }

    public void pasteIntoNode() {
        this.dataNodeService.pasteIntoNode(this);
    }

    public void saveChangesToCache(boolean updateUI) {
        this.dataNodeService.saveChangesToCache(this);
    }

    public void addField(ArbilField fieldToAdd) {
        this.dataNodeService.addField(this, fieldToAdd);
    }

    public Map<String, ArbilField[]> getFields() {
        return this.fieldHashtable;
    }

    public List<FieldGroup> getFieldGroups() {
        ArrayList<FieldGroup> fieldArrays = new ArrayList<FieldGroup>();
        for (Map.Entry<String, ArbilField[]> currentEntry : this.getFields().entrySet()) {
            List<Object> fieldList = Arrays.asList((Object[])currentEntry.getValue());
            fieldArrays.add(new FieldGroup(currentEntry.getKey(), fieldList));
        }
        return fieldArrays;
    }

    public List<ArbilField[]> getFieldsSorted() {
        ArrayList<ArbilField[]> fieldArrays = new ArrayList<ArbilField[]>(this.getFields().values());
        Collections.sort(fieldArrays, new ArrayComparator<ArbilField>(new ArbilFieldComparator(), 0));
        return fieldArrays;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this.isFavorite()) {
            return favouriteSorter.compare(this, o);
        }
        return dataNodeSorter.compare(this, o);
    }

    public synchronized void notifyLoaded() {
        this.getParentDomLockObject().notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitTillLoaded() {
        if (this != this.getParentDomNode()) {
            return this.getParentDomNode().waitTillLoaded();
        }
        Object object = this.getParentDomLockObject();
        synchronized (object) {
            while (this.isLoading()) {
                try {
                    logger.debug("wait for loading: {}", (Object)this.nodeUri);
                    this.getParentDomLockObject().wait(1000L);
                }
                catch (InterruptedException ex) {
                    logger.debug("Interrupted while waiting for node to be loaded", (Throwable)ex);
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLoadingState(int countChange) {
        if (this != this.getParentDomNode()) {
            this.getParentDomNode().updateLoadingState(countChange);
        } else {
            boolean wasLoading = this.isLoading();
            Object object = this.loadingCountLock;
            synchronized (object) {
                this.isLoadingCount += countChange;
            }
            if (wasLoading != this.isLoading()) {
                this.clearChildIcons();
                this.clearIcon();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoading() {
        if (this != this.getParentDomNode()) {
            return this.getParentDomNode().isLoading();
        }
        Object object = this.loadingCountLock;
        synchronized (object) {
            return this.getParentDomNode().isLoadingCount > 0;
        }
    }

    public String getLabel() {
        return this.toString();
    }

    public String toString() {
        if (this.lastNodeText != null) {
            return this.lastNodeText;
        }
        return "unknown";
    }

    public boolean isNodeTextDetermined() {
        return this.lastNodeText != null && !this.lastNodeText.equals(NODE_LOADING_TEXT) && !this.lastNodeText.equals(EMPTY_NODE_STRING_VALUE);
    }

    public String refreshStringValue() {
        Iterator<ArbilField[]> fieldsIterator;
        URI resourceUri;
        if (this.isLoading()) {
            return this.lastNodeText;
        }
        if (this.lastNodeText.equals(NODE_LOADING_TEXT) && this.isDataPartiallyLoaded()) {
            this.lastNodeText = EMPTY_NODE_STRING_VALUE;
        }
        boolean foundPreferredNameField = false;
        boolean preferredNameFieldExists = false;
        block2: for (String currentPreferredName : this.getNodeTemplate().getPreferredNameFields()) {
            for (ArbilField[] currentFieldArray : (ArbilField[][])this.fieldHashtable.values().toArray((T[])new ArbilField[0][])) {
                if (!currentFieldArray[0].getFullXmlPath().replaceAll("\\(\\d+\\)", "").equals(currentPreferredName)) continue;
                preferredNameFieldExists = true;
                for (ArbilField currentField : currentFieldArray) {
                    if (currentField == null || currentField.toString().trim().length() <= 0) continue;
                    this.nodeText = currentField.toString();
                    foundPreferredNameField = true;
                    break block2;
                }
            }
            ArbilField[] currentFieldArray = this.getFieldArray(currentPreferredName);
            if (currentFieldArray == null) continue;
            for (ArbilField currentField : currentFieldArray) {
                if (currentField == null || currentField.toString().trim().length() <= 0) continue;
                this.nodeText = currentField.toString();
                foundPreferredNameField = true;
                break block2;
            }
        }
        if (!foundPreferredNameField && this.isCmdiMetaDataNode()) {
            String nodeFragmentName = this.getURIFragment();
            String unamedText = nodeFragmentName != null ? (nodeFragmentName = this.getNodeTypeNameFromUriFragment(nodeFragmentName)) : (this.nodeTemplate != null ? this.nodeTemplate.getTemplateName() : "");
            this.nodeText = preferredNameFieldExists ? unamedText + " (unnamed)" : unamedText;
        }
        if (this.hasResource() && (resourceUri = this.getFullResourceURI()) != null) {
            String resourcePathString = resourceUri.toString();
            int lastIndex = resourcePathString.lastIndexOf("/");
            resourcePathString = resourcePathString.substring(lastIndex + 1);
            try {
                resourcePathString = URLDecoder.decode(resourcePathString, "UTF-8");
            }
            catch (UnsupportedEncodingException encodingException) {
                throw new RuntimeException(encodingException);
            }
            this.nodeText = resourcePathString;
        }
        if (this.isInfoLink && (fieldsIterator = this.fieldHashtable.values().iterator()).hasNext()) {
            String infoTitle = fieldsIterator.next()[0].getFieldValue();
            if ((infoTitle = infoTitle.trim()).length() > 0) {
                this.nodeText = infoTitle;
            }
        }
        if (this.nodeText != null) {
            File nodeFile;
            if (this.isMetaDataNode() && (nodeFile = this.getFile()) != null && !this.isHeadRevision()) {
                this.nodeText = this.nodeText + " (rev:" + this.getHistoryLabelStringForFile(nodeFile) + ")";
            }
            this.lastNodeText = this.nodeText;
        }
        if (this.isContainerNode()) {
            this.lastNodeText = String.format("%1$s (%2$d)", this.lastNodeText, this.getChildCount());
        } else if (this.isSingletonMetadataNode()) {
            StringBuilder nodeTextSB = new StringBuilder(this.getNodeTypeNameFromUriFragment(this.getURIFragment()));
            if (this.nodeText != null && this.nodeText.length() > 0) {
                nodeTextSB.append(" (").append(this.nodeText).append(")");
            }
            this.lastNodeText = nodeTextSB.toString();
        }
        if (this.lastNodeText.length() == 0) {
            this.lastNodeText = EMPTY_NODE_STRING_VALUE;
        }
        return this.lastNodeText;
    }

    @Override
    public boolean isArchivableFile() {
        return this.mpiMimeType != null;
    }

    @Override
    public boolean hasResource() {
        return this.resourceUrlField != null && !this.resourceUrlField.getFieldValue().isEmpty();
    }

    public boolean canHaveResource() {
        ArbilTemplate template;
        if (this.resourceUrlField != null) {
            return true;
        }
        if (this.isCmdiMetaDataNode() && (template = this.getNodeTemplate()) instanceof CmdiTemplate) {
            return ((CmdiTemplate)template).pathCanHaveResource(this.nodeUri.getFragment());
        }
        return false;
    }

    public void insertResourceLocation(URI location) throws ArbilMetadataException {
        this.dataNodeService.insertResourceLocation(this, location);
    }

    @Override
    public boolean hasLocalResource() {
        if (!this.hasResource()) {
            return false;
        }
        if (this.resourceUrlField.getFieldValue().toLowerCase().startsWith("http")) {
            return false;
        }
        return this.isLocal();
    }

    public boolean resourceFileNotFound() {
        if (this.hasLocalResource()) {
            if (this.resourceUrlField.getFieldValue().length() == 0) {
                return true;
            }
            try {
                return !new File(this.getFullResourceURI()).exists();
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasHistory() {
        if (!this.isLocal()) {
            return false;
        }
        return !this.isChildNode() && new File(this.getFile().getAbsolutePath() + ".0").exists();
    }

    private boolean isHeadRevision() {
        return !new File(this.getFile().getAbsolutePath() + ".x").exists();
    }

    private String getHistoryLabelStringForFile(File historyFile) {
        Date mtime = new Date(historyFile.lastModified());
        String mTimeString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mtime);
        return mTimeString;
    }

    public String[][] getHistoryList() {
        File currentHistoryFile;
        Vector<String[]> historyVector = new Vector<String[]>();
        int versionCounter = 0;
        if (!this.isHeadRevision()) {
            historyVector.add(new String[]{widgets.getString("HISTORY_LAST SAVE"), ".x"});
        }
        do {
            if ((currentHistoryFile = new File(this.getFile().getAbsolutePath() + "." + versionCounter)).exists()) {
                String mTimeString = this.getHistoryLabelStringForFile(currentHistoryFile);
                historyVector.add(new String[]{mTimeString, "." + versionCounter});
            }
            ++versionCounter;
        } while (currentHistoryFile.exists());
        return (String[][])historyVector.toArray((T[])new String[][]{new String[0]});
    }

    public boolean resurrectHistory(String historyVersion) {
        return this.dataNodeService.resurrectHistory(this, historyVersion);
    }

    public void bumpHistory() throws IOException {
        this.dataNodeService.bumpHistory(this.getFile());
    }

    public String getResourceArchiveHandle() {
        return this.resourceUrlField.getArchiveHandle();
    }

    public URI getFullResourceURI() {
        String targetUriString = this.resourceUrlField.getFieldValue();
        String[] uriParts = targetUriString.split(":/", 2);
        try {
            boolean isUncPath;
            URI targetUri;
            if (uriParts.length > 1) {
                String bracketEncodedPath = uriParts[1];
                targetUri = new URI(uriParts[0], "/" + bracketEncodedPath, null);
            } else {
                targetUri = new URI(null, targetUriString, null);
            }
            URI resourceUri = this.nodeUri.resolve(targetUri);
            if (!targetUri.equals(resourceUri) && (isUncPath = this.nodeUri.toString().toLowerCase().startsWith("file:////"))) {
                resourceUri = URI.create("file:////" + resourceUri.toString().substring("file:/".length()));
            }
            return resourceUri;
        }
        catch (Exception urise) {
            logger.error("URI syntax exception creating target URI from {}", (Object)targetUriString);
            logger.debug("URISyntaxException: {}", (Throwable)urise);
            return null;
        }
    }

    public String getUrlString() {
        return this.nodeUri.toString();
    }

    public Object getParentDomLockObject() {
        return this.getParentDomNode().domLockObjectPrivate;
    }

    public synchronized ArbilDataNode getParentDomNode() {
        if (this.domParentNode == null) {
            this.domParentNode = this.nodeUri.getFragment() != null ? this.dataNodeService.loadArbilDataNode(null, URI.create(this.nodeUri.toString().split("#")[0])) : this;
        }
        return this.domParentNode;
    }

    public synchronized void setParentDomNode(ArbilDataNode domParentNode) {
        this.domParentNode = domParentNode;
    }

    public DataNodeType getType() {
        return ArbilDataNodeType.getTypeForNode(this);
    }

    @Override
    public boolean isDirectory() {
        return MetadataFormat.FileType.DIRECTORY == this.formatType;
    }

    public boolean isFile() {
        return MetadataFormat.FileType.FILE == this.formatType;
    }

    @Override
    public boolean isMetaDataNode() {
        if (this.resourceNode) {
            return false;
        }
        return metadataFormat.isMetaDataNode(this.formatType);
    }

    @Override
    public boolean isCmdiMetaDataNode() {
        if (MetadataFormat.FileType.CHILD == this.formatType) {
            return this.getParentDomNode().isCmdiMetaDataNode();
        }
        return MetadataFormat.FileType.CMDI == this.formatType;
    }

    @Override
    public boolean isChildNode() {
        return MetadataFormat.FileType.CHILD == this.formatType;
    }

    @Override
    public boolean isSession() {
        ArbilField[] nameFields = this.getFieldArray("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(".METATRANSCRIPT.Session.Name");
        }
        return false;
    }

    @Override
    public boolean isEmptyMetaNode() {
        return this.getFields().isEmpty();
    }

    @Override
    public boolean isCatalogue() {
        ArbilField[] nameFields = this.getFieldArray("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(".METATRANSCRIPT.Catalogue.Name");
        }
        return false;
    }

    @Override
    public boolean isCorpus() {
        if (this.isCmdiMetaDataNode()) {
            return false;
        }
        ArbilField[] nameFields = this.getFieldArray("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(".METATRANSCRIPT.Corpus.Name");
        }
        return false;
    }

    @Override
    public boolean isLocal() {
        if (this.nodeUri != null) {
            return ArbilDataNode.isUriLocal(this.nodeUri);
        }
        return false;
    }

    @Override
    public boolean isEditable() {
        return this.dataNodeService.isEditable(this);
    }

    public URI getURI() {
        return this.nodeUri;
    }

    public String getURIFragment() {
        return this.nodeUri.getFragment();
    }

    public File getFile() {
        try {
            return MetadataFormat.getFile(this.nodeUri);
        }
        catch (Exception urise) {
            logger.error(this.nodeUri.toString(), (Throwable)urise);
            return null;
        }
    }

    public String getParentDirectory() {
        String parentPath = this.getUrlString().substring(0, this.getUrlString().lastIndexOf("/")) + "/";
        return parentPath;
    }

    @Override
    public void registerContainer(ArbilDataNodeContainer containerToAdd) {
        if (!this.isDataLoaded() && !this.isLoading()) {
            if (containerToAdd.isFullyLoadedNodeRequired()) {
                this.setRequestedLoadingState(LoadingState.LOADED);
                this.dataNodeService.reloadNode(this);
            } else if (!this.isDataPartiallyLoaded()) {
                this.dataNodeService.reloadNodeShallowly(this);
            }
        }
        super.registerContainer(containerToAdd);
    }

    public void clearChildIcons() {
        for (ArbilDataNode currentChild : this.childArray) {
            currentChild.clearChildIcons();
            currentChild.clearIcon();
        }
    }

    public void clearIcon() {
        this.refreshStringValue();
        this.icon = ArbilIcons.getSingleInstance().getIconForNode(this);
        for (ArbilDataNodeContainer currentContainer : this.containersOfThisNode.toArray(new ArbilDataNodeContainer[0])) {
            logger.trace("Updating node {} in container {}", (Object)this, (Object)currentContainer);
            currentContainer.dataNodeIconCleared(this);
        }
    }

    public synchronized void removeFromAllContainers() {
        for (ArbilDataNode currentChildNode : this.getAllChildren()) {
            logger.trace("Removing node {} from all containers", (Object)this);
            currentChildNode.removeFromAllContainers();
        }
        for (ArbilDataNodeContainer currentContainer : this.containersOfThisNode.toArray(new ArbilDataNodeContainer[0])) {
            logger.trace("Removing node {} from container {}", (Object)this, (Object)currentContainer);
            currentContainer.dataNodeRemoved(this);
        }
    }

    @Override
    public boolean isFavorite() {
        if (this.isFavorite == null) {
            this.isFavorite = this.dataNodeService.isFavorite(this);
        }
        return this.isFavorite;
    }

    public String getID() {
        return this.archiveHandle;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.icon == null) {
            return ArbilIcons.getSingleInstance().loadingIcon;
        }
        return this.icon;
    }

    public MetadataFormat.FileType getFormatType() {
        return this.formatType;
    }

    public void setFormatType(MetadataFormat.FileType formatType) {
        this.formatType = formatType;
    }

    public synchronized LoadingState getLoadingState() {
        if (this.isChildNode()) {
            return this.getParentDomNode().getLoadingState();
        }
        return this.loadingState;
    }

    public synchronized void setLoadingState(LoadingState loadingState) {
        this.loadingState = loadingState;
    }

    public synchronized LoadingState getRequestedLoadingState() {
        return this.requestedLoadingState;
    }

    public synchronized void setRequestedLoadingState(LoadingState requestedLoadingState) {
        this.requestedLoadingState = requestedLoadingState;
    }

    @Override
    public synchronized boolean isDataLoaded() {
        return this.getLoadingState().equals((Object)LoadingState.LOADED);
    }

    @Override
    public synchronized boolean isDataPartiallyLoaded() {
        return !this.getLoadingState().equals((Object)LoadingState.UNLOADED);
    }

    @Override
    public boolean isResourceSet() {
        return this.resourceUrlField != null && this.resourceUrlField.getFieldValue().length() > 0;
    }

    public void invalidateThumbnails() {
        this.thumbnailFile = null;
        for (ArbilDataNode node : this.getChildArray()) {
            node.invalidateThumbnails();
        }
    }

    public boolean isSingletonMetadataNode() {
        return this.singletonMetadataNode;
    }

    public void setSingletonMetadataNode(boolean singletonMetadataNodeName) {
        this.singletonMetadataNode = singletonMetadataNodeName;
    }

    public boolean isContainerNode() {
        return this.containerNode;
    }

    public void setContainerNode(boolean containerNode) {
        this.containerNode = containerNode;
    }

    public synchronized CmdiComponentLinkReader getCmdiComponentLinkReader() {
        if (this.cmdiComponentLinkReader == null) {
            this.cmdiComponentLinkReader = new CmdiComponentLinkReader();
        }
        return this.getParentDomNode().cmdiComponentLinkReader;
    }

    public MimeHashQueue.TypeCheckerState getTypeCheckerState() {
        return this.typeCheckerState;
    }

    public void setTypeCheckerState(MimeHashQueue.TypeCheckerState typeCheckerState) {
        this.typeCheckerState = typeCheckerState;
    }

    protected List<String[]> getChildLinks() {
        return this.childLinks;
    }

    protected ArbilField[] getFieldArray(String translateFieldName) {
        return this.fieldHashtable.get(translateFieldName);
    }

    protected void addFieldArray(String translateFieldName, ArbilField[] fieldArray) {
        this.fieldHashtable.put(translateFieldName, fieldArray);
    }

    public ArbilDataNode getParentNode() {
        return this.dataNodeService.getParentOfNode(this);
    }

    public void setResourceNode(boolean resource) {
        this.resourceNode = resource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoadingState {
        UNLOADED,
        PARTIAL,
        LOADED;

    }
}

