/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checksum {
    private static Logger logger = LoggerFactory.getLogger((String)Checksum.class.getName());
    private static final String zeroString = "00000000000000000000000000000000";

    public static void main(String[] args) {
        if (args.length == 1) {
            System.out.println("Command line: '" + args[0] + "'");
            if (new File(args[0]).canRead()) {
                System.out.println("File checksum: " + Checksum.create(args[0]));
            } else {
                System.out.println("Command line has no name of a readable file");
            }
            System.out.println("Text checksum: " + Checksum.checksumString(args[0]));
        } else {
            System.out.println("Usage : java Checksum [filename/string]\n");
        }
    }

    public static String checksumString(String text) {
        byte[] digest = null;
        try {
            byte[] chk = text.getBytes("UTF-8");
            MessageDigest complete = MessageDigest.getInstance("MD5");
            complete.update(chk, 0, chk.length);
            digest = complete.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("This Java environment does not support the MD5SUM algorithm\n" + nsae);
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("This Java environment does not support the UTF-8 encoding\n" + uee);
            return null;
        }
        if (digest == null) {
            return "";
        }
        String md5 = zeroString + new BigInteger(1, digest).toString(16);
        return md5.substring(md5.length() - 32);
    }

    public static String create(String filename) {
        byte[] chk = Checksum.createChecksum(filename);
        if (chk == null) {
            return "";
        }
        String md5 = zeroString + new BigInteger(1, chk).toString(16);
        return md5.substring(md5.length() - 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createChecksum(String filename) {
        FileInputStream fis = null;
        try {
            int numRead;
            fis = new FileInputStream(filename);
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            ((InputStream)fis).close();
            fis = null;
            byte[] byArray = complete.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("This Java environment does not support the MD5SUM algorithm\n" + nsae);
            byte[] byArray = null;
            return byArray;
        }
        catch (FileNotFoundException fnfe) {
            logger.error("File not found: " + fnfe + " for: " + filename);
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException ioe) {
            logger.error("File read error: " + ioe + " for: " + filename);
            logger.debug("Stack trace for I/O error for: " + filename + " follows...", (Throwable)ioe);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException ioe) {
                    logger.error("Failed to close input stream: " + ioe + " for: " + filename);
                }
            }
        }
    }
}

