/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.IMDIVocabularies;
import nl.mpi.arbil.plugins.ArbilPluginManager;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.ArbilFieldViews;
import nl.mpi.arbil.ui.ArbilHelp;
import nl.mpi.arbil.ui.ArbilLogConsole;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.ImportExportDialog;
import nl.mpi.arbil.ui.LanguageListDialogue;
import nl.mpi.arbil.ui.PreviewSplitPanel;
import nl.mpi.arbil.ui.TemplateDialogue;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizard;
import nl.mpi.arbil.userstorage.ArbilConfiguration;
import nl.mpi.arbil.userstorage.ArbilConfigurationManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilLogConfigurer;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.MimeHashQueue;
import nl.mpi.arbil.util.WebstartHelper;
import nl.mpi.arbil.util.WindowManager;
import nl.mpi.arbilcommons.journal.ArbilJournal;
import nl.mpi.arbilcommons.ui.LocalisationSelector;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.pluginloader.PluginManager;
import nl.mpi.pluginloader.PluginService;
import nl.mpi.pluginloader.ui.PluginMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ArbilMenuBar
extends JMenuBar {
    private static final Logger logger = LoggerFactory.getLogger(ArbilMenuBar.class);
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus");
    private static final ResourceBundle services = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Services");
    public static final String FORUM_URL = "http://tla.mpi.nl/forums/software/arbil/";
    private final WebstartHelper webstartHelper = new WebstartHelper();
    private final SessionStorage sessionStorage;
    private final MimeHashQueue mimeHashQueue;
    private final ArbilTreeHelper treeHelper;
    private final ArbilWindowManager windowManager;
    private final MessageDialogHandler dialogHandler;
    private final DataNodeLoader dataNodeLoader;
    private final ArbilLogConfigurer logConfigurer;
    private final ApplicationVersionManager versionManager;
    private final ArbilConfiguration applicationConfiguration;
    private final ArbilConfigurationManager configurationManager;
    private final PreviewSplitPanel previewSplitPanel;
    private final JApplet containerApplet;
    private final HostOS hostOS;
    private final Action zoomInAction = new AbstractAction(menus.getString("MENU_INCREASE_FONT_SIZE")){

        public void actionPerformed(ActionEvent ae) {
            ArbilMenuBar.this.windowManager.changeFontScale(0.1f);
        }
    };
    private final Action zoomOutAction = new AbstractAction(menus.getString("MENU_DECREASE_FONT_SIZE")){

        public void actionPerformed(ActionEvent ae) {
            ArbilMenuBar.this.windowManager.changeFontScale(-0.1f);
        }
    };
    private final Action zoomResetAction = new AbstractAction(menus.getString("MENU_RESET_FONT_SIZE")){

        public void actionPerformed(ActionEvent ae) {
            ArbilMenuBar.this.windowManager.resetFontScale();
        }
    };
    private final Action saveAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            try {
                ArbilMenuBar.this.windowManager.stopEditingInCurrentWindow();
                ArbilMenuBar.this.dataNodeLoader.saveNodesNeedingSave(true);
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
    };
    private final Action redoAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            try {
                ArbilMenuBar.this.windowManager.stopEditingInCurrentWindow();
                ArbilJournal.getSingleInstance().redoFromFieldChangeHistory();
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
    };
    private final Action undoAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            try {
                ArbilMenuBar.this.windowManager.stopEditingInCurrentWindow();
                ArbilJournal.getSingleInstance().undoFromFieldChangeHistory();
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
    };
    private final JMenu windowMenu = new JMenu();
    private final JMenuItem saveFileMenuItem = new JMenuItem();
    private final JMenuItem showChangedNodesMenuItem = new JMenuItem();
    private final JCheckBoxMenuItem saveWindowsCheckBoxMenuItem = new JCheckBoxMenuItem();
    private final JMenuItem shortCutKeysjMenuItem = new JMenuItem();
    private final JMenuItem selectLanguageMenuItem = new JMenuItem();
    private final JMenuItem arbilForumMenuItem = new JMenuItem();
    private final JMenuItem checkForUpdatesMenuItem = new JMenuItem();
    private final JMenuItem viewErrorLogMenuItem = new JMenuItem();
    private final JCheckBoxMenuItem showSelectionPreviewCheckBoxMenuItem = new JCheckBoxMenuItem();
    private final JMenuItem templatesMenu = new JMenuItem();
    private final JCheckBoxMenuItem trackTableSelectionCheckBoxMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem useLanguageIdInColumnNameCheckBoxMenuItem = new JCheckBoxMenuItem();
    private final JMenuItem verbatimXmlStructureMenuItem = new JCheckBoxMenuItem();
    private final JMenuItem undoMenuItem = new JMenuItem();
    private final JMenu setCacheDirectoryMenu = new JMenu();
    private final JMenu columnViewMenu = new JMenu();
    private final JMenuItem resetWindowsMenuItem = new JMenuItem();
    private final JMenuItem closeWindowsMenuItem = new JMenuItem();
    private final JMenu optionsMenu = new JMenu();
    private final JMenuItem pasteMenuItem = new JMenuItem();
    private final JMenuItem redoMenuItem = new JMenuItem();
    private final JCheckBoxMenuItem checkNewVersionAtStartCheckBoxMenuItem = new JCheckBoxMenuItem();
    private final JMenuItem copyMenuItem = new JMenuItem();
    private final JCheckBoxMenuItem copyNewResourcesCheckBoxMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem checkResourcePermissionsCheckBoxMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem schemaCheckLocalFiles = new JCheckBoxMenuItem();
    private final JMenuItem editPreferredLanguagesMenuItem = new JMenuItem();
    private final JMenuItem editFieldViewsMenuItem = new JMenuItem();
    private final JMenuItem logConsoleMenuItem = new JMenuItem();
    private final JMenuItem updateAllLoadedVocabulariesMenuItem = new JMenuItem();
    private final JMenu editMenu = new JMenu();
    private final JMenu fileMenu = new JMenu();
    private final JMenu helpMenu = new JMenu();
    private final JMenuItem helpMenuItem = new JMenuItem();
    private final JMenuItem setupWizardMenuItem = new JMenuItem();
    private final JMenuItem importMenuItem = new JMenuItem();
    private final JCheckBoxMenuItem showStatusBarMenuItem = new JCheckBoxMenuItem();
    private final JMenu viewMenu = new JMenu();
    private final JMenuItem zoomInMenuItem = new JMenuItem();
    private final JMenuItem zoomOutMenuItem = new JMenuItem();
    private final JMenuItem zoomResetMenuItem = new JMenuItem();
    private final JMenuItem exitMenuItem = new JMenuItem(){

        public boolean isVisible() {
            return ArbilMenuBar.this.hostOS != HostOS.MACOS;
        }
    };
    private JMenuItem aboutMenuItem = new JMenuItem(){

        public boolean isVisible() {
            return ArbilMenuBar.this.hostOS != HostOS.MACOS;
        }
    };
    private final JMenuItem searchReplaceMenuItem = new JMenuItem(){

        public boolean isEnabled() {
            if (ArbilMenuBar.this.windowManager != null) {
                return ArbilMenuBar.this.windowManager.getCurrentFrameComponent() instanceof ArbilSplitPanel;
            }
            return false;
        }
    };

    public ArbilMenuBar(ArbilConfiguration appConfiguration, SessionStorage sessionStorage, MessageDialogHandler dialogHandler, ArbilWindowManager windowManager, ArbilTreeHelper treeHelper, DataNodeLoader dataNodeLoader, MimeHashQueue mimeHashQueue, ApplicationVersionManager versionManager, ArbilLogConfigurer logConfigurer, JApplet containerApplet, PreviewSplitPanel previewSplitPanel, HostOS hostOS) {
        this.containerApplet = containerApplet;
        this.previewSplitPanel = previewSplitPanel;
        this.hostOS = hostOS;
        this.versionManager = versionManager;
        this.logConfigurer = logConfigurer;
        this.applicationConfiguration = appConfiguration;
        this.treeHelper = treeHelper;
        this.windowManager = windowManager;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.sessionStorage = sessionStorage;
        this.mimeHashQueue = mimeHashQueue;
        this.configurationManager = new ArbilConfigurationManager(sessionStorage);
        this.initFileMenu();
        this.initEditMenu();
        this.initViewMenu();
        this.initOptionsMenu();
        this.initPluginMenu();
        this.initWindowMenu();
        this.initHelpMenu();
        this.setUpHotKeys();
    }

    private ArbilHelp getArbilHelp() {
        try {
            return ArbilHelp.getArbilHelpInstance();
        }
        catch (IOException ioEx) {
            this.dialogHandler.addMessageDialogToQueue(menus.getString("I/O ERROR WHILE TRYING TO READ HELP SYSTEM! SEE ERROR LOG FOR DETAILS."), menus.getString("ERROR"));
            BugCatcherManager.getBugCatcher().logError(ioEx);
        }
        catch (SAXException saxEx) {
            this.dialogHandler.addMessageDialogToQueue(menus.getString("PARSER ERROR WHILE TRYING TO READ HELP SYSTEM! SEE ERROR LOG FOR DETAILS."), menus.getString("ERROR"));
            BugCatcherManager.getBugCatcher().logError(saxEx);
        }
        return null;
    }

    private void initFileMenu() {
        this.fileMenu.setText(menus.getString("FILE"));
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.saveFileMenuItem.setEnabled(ArbilMenuBar.this.dataNodeLoader.nodesNeedSave());
                ArbilMenuBar.this.showChangedNodesMenuItem.setEnabled(ArbilMenuBar.this.dataNodeLoader.nodesNeedSave());
            }
        });
        this.saveFileMenuItem.setEnabled(false);
        this.saveFileMenuItem.setAction(this.saveAction);
        this.saveFileMenuItem.setText(menus.getString("SAVE CHANGES"));
        this.fileMenu.add(this.saveFileMenuItem);
        this.showChangedNodesMenuItem.setText(menus.getString("SHOW MODIFIED NODES"));
        this.showChangedNodesMenuItem.setEnabled(false);
        this.showChangedNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArrayList<ArbilDataNode> individualChangedNodes = new ArrayList<ArbilDataNode>();
                    for (ArbilDataNode currentTestable : ArbilMenuBar.this.dataNodeLoader.getNodesNeedSave()) {
                        if (currentTestable.hasChangedFields()) {
                            individualChangedNodes.add(currentTestable);
                        }
                        for (ArbilDataNode currentChildSaveable : currentTestable.getAllChildren()) {
                            if (!currentChildSaveable.hasChangedFields()) continue;
                            individualChangedNodes.add(currentChildSaveable);
                        }
                    }
                    ArbilMenuBar.this.windowManager.openFloatingTable(individualChangedNodes.toArray(new ArbilDataNode[0]), menus.getString("MODIFIED NODES"));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.fileMenu.add(this.showChangedNodesMenuItem);
        this.importMenuItem.setText(menus.getString("IMPORT..."));
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.importMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.exitMenuItem.setText(menus.getString("EXIT"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.exitMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        if (this.containerApplet == null) {
            this.fileMenu.add(this.exitMenuItem);
        } else {
            String loggedInUserName = this.containerApplet.getParameter(menus.getString("USERNAME"));
            if (loggedInUserName == null) {
                loggedInUserName = menus.getString("UNKNOWN USER");
            }
            JMenuItem logoutButton = new JMenuItem(MessageFormat.format(menus.getString("LOG OUT ({0})"), loggedInUserName));
            logoutButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String logoutUrl = ArbilMenuBar.this.containerApplet.getParameter(menus.getString("LOGOUTURL"));
                    try {
                        if (ArbilMenuBar.this.containerApplet != null) {
                            ArbilMenuBar.this.containerApplet.getAppletContext().showDocument(new URL(logoutUrl));
                        }
                    }
                    catch (MalformedURLException ex) {
                        ArbilMenuBar.this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(menus.getString("INVALID LOGOUT URL: {0}"), logoutUrl), menus.getString("LOGOUT ERROR"));
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            });
            this.fileMenu.add(logoutButton);
        }
        this.add(this.fileMenu);
    }

    private void initEditMenu() {
        this.editMenu.setText(menus.getString("EDIT"));
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.undoMenuItem.setEnabled(ArbilJournal.getSingleInstance().canUndo());
                ArbilMenuBar.this.redoMenuItem.setEnabled(ArbilJournal.getSingleInstance().canRedo());
            }
        });
        this.copyMenuItem.setText(menus.getString("COPY"));
        this.copyMenuItem.setEnabled(false);
        this.pasteMenuItem.setText(menus.getString("PASTE"));
        this.pasteMenuItem.setEnabled(false);
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.setAction(this.undoAction);
        this.undoMenuItem.setText(menus.getString("UNDO"));
        this.redoMenuItem.setEnabled(false);
        this.redoMenuItem.setAction(this.redoAction);
        this.redoMenuItem.setText(menus.getString("REDO"));
        this.searchReplaceMenuItem.setText(menus.getString("FIND/REPLACE"));
        this.searchReplaceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component selectedComponent = ArbilMenuBar.this.windowManager.getCurrentFrameComponent();
                if (selectedComponent instanceof ArbilSplitPanel) {
                    ((ArbilSplitPanel)selectedComponent).showSearchPane();
                }
            }
        });
        this.editMenu.add(this.searchReplaceMenuItem);
        this.editMenu.add(this.undoMenuItem);
        this.editMenu.add(this.redoMenuItem);
        this.add(this.editMenu);
    }

    private void initViewMenu() {
        this.showSelectionPreviewCheckBoxMenuItem.setSelected(this.sessionStorage.loadBoolean("showSelectionPreview", true));
        this.previewSplitPanel.setPreviewPanel(this.showSelectionPreviewCheckBoxMenuItem.getState());
        this.showSelectionPreviewCheckBoxMenuItem.setText(menus.getString("SHOW SELECTION PREVIEW"));
        this.showSelectionPreviewCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.previewSplitPanel.setPreviewPanel(ArbilMenuBar.this.showSelectionPreviewCheckBoxMenuItem.getState());
                    ArbilMenuBar.this.sessionStorage.saveBoolean("showSelectionPreview", ArbilMenuBar.this.showSelectionPreviewCheckBoxMenuItem.isSelected());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.showStatusBarMenuItem.setText(menus.getString("SHOW STATUS BAR"));
        this.showStatusBarMenuItem.setState(this.sessionStorage.loadBoolean("showStatusBar", false));
        this.showStatusBarMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArbilMenuBar.this.windowManager.setStatusBarVisible(ArbilMenuBar.this.showStatusBarMenuItem.getState());
                ArbilMenuBar.this.sessionStorage.saveBoolean("showStatusBar", ArbilMenuBar.this.showStatusBarMenuItem.getState());
            }
        });
        this.showStatusBarMenuItem.setVisible(false);
        this.showStatusBarMenuItem.setEnabled(false);
        this.zoomInMenuItem.setAction(this.zoomInAction);
        this.zoomOutMenuItem.setAction(this.zoomOutAction);
        this.zoomResetMenuItem.setAction(this.zoomResetAction);
        this.viewMenu.add(this.showSelectionPreviewCheckBoxMenuItem);
        this.viewMenu.add(this.showStatusBarMenuItem);
        this.viewMenu.add(new JSeparator());
        this.viewMenu.add(this.zoomInMenuItem);
        this.viewMenu.add(this.zoomOutMenuItem);
        this.viewMenu.add(this.zoomResetMenuItem);
        this.viewMenu.setText(menus.getString("MENU_VIEW"));
        this.add(this.viewMenu);
    }

    private void initOptionsMenu() {
        this.optionsMenu.setText(menus.getString("OPTIONS"));
        this.templatesMenu.setText(menus.getString("TEMPLATES & PROFILES..."));
        this.templatesMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TemplateDialogue.showTemplatesDialogue(ArbilMenuBar.this.windowManager, ArbilMenuBar.this.dialogHandler);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.optionsMenu.add(this.templatesMenu);
        this.setCacheDirectoryMenu.setText(menus.getString("LOCAL CORPUS STORAGE DIRECTORY"));
        this.setCacheDirectoryMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.setCacheDirectoryMenu.removeAll();
                JMenuItem cacheDirectoryMenuItem = new JMenuItem();
                cacheDirectoryMenuItem.setText(ArbilMenuBar.this.sessionStorage.getProjectWorkingDirectory().getAbsolutePath());
                cacheDirectoryMenuItem.setEnabled(false);
                JMenuItem changeCacheDirectoryMenuItem = new JMenuItem();
                changeCacheDirectoryMenuItem.setText(menus.getString("MOVE LOCAL CORPUS STORAGE DIRECTORY..."));
                changeCacheDirectoryMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            ArbilMenuBar.this.dialogHandler.offerUserToSaveChanges();
                            File[] selectedFiles = ArbilMenuBar.this.dialogHandler.showDirectorySelectBox(menus.getString("MOVE LOCAL CORPUS STORAGE DIRECTORY"), false);
                            if (selectedFiles != null && selectedFiles.length > 0) {
                                ArbilMenuBar.this.sessionStorage.changeCacheDirectory(selectedFiles[0], true);
                            }
                        }
                        catch (Exception ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                        }
                    }
                });
                ArbilMenuBar.this.setCacheDirectoryMenu.add(cacheDirectoryMenuItem);
                ArbilMenuBar.this.setCacheDirectoryMenu.add(changeCacheDirectoryMenuItem);
            }
        });
        this.optionsMenu.add(this.setCacheDirectoryMenu);
        this.editPreferredLanguagesMenuItem.setText(menus.getString("EDIT IMDI LANGUAGE LIST..."));
        this.editPreferredLanguagesMenuItem.setEnabled(true);
        this.editPreferredLanguagesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LanguageListDialogue.showLanguageDialogue(ArbilMenuBar.this.windowManager, ArbilMenuBar.this.dialogHandler);
            }
        });
        this.optionsMenu.add(this.editPreferredLanguagesMenuItem);
        this.updateAllLoadedVocabulariesMenuItem.setText(menus.getString("RE-DOWNLOAD CURRENT VOCABULARIES"));
        this.updateAllLoadedVocabulariesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IMDIVocabularies.getSingleInstance().redownloadCurrentlyLoadedVocabularies();
            }
        });
        this.optionsMenu.add(this.updateAllLoadedVocabulariesMenuItem);
        this.saveWindowsCheckBoxMenuItem.setSelected(this.sessionStorage.loadBoolean("saveWindows", true));
        this.saveWindowsCheckBoxMenuItem.setText(menus.getString("SAVE WINDOWS ON EXIT"));
        this.optionsMenu.add(this.saveWindowsCheckBoxMenuItem);
        this.checkNewVersionAtStartCheckBoxMenuItem.setSelected(this.sessionStorage.loadBoolean("checkNewVersionAtStart", true));
        this.checkNewVersionAtStartCheckBoxMenuItem.setText(menus.getString("CHECK FOR NEW VERSION ON START"));
        this.optionsMenu.add(this.checkNewVersionAtStartCheckBoxMenuItem);
        this.copyNewResourcesCheckBoxMenuItem.setSelected(this.applicationConfiguration.isCopyNewResourcesToCache());
        this.copyNewResourcesCheckBoxMenuItem.setText(menus.getString("COPY NEW RESOURCES INTO CACHE"));
        this.copyNewResourcesCheckBoxMenuItem.setToolTipText(menus.getString("WHEN ADDING A NEW RESOURCE TO A SESSION THIS OPTIONS WILL COPY THE FILE INTO THE LOCAL CACHE RATHER THAN LINKING TO ITS CURRENT LOCATION. THIS OPTION CAN MAKE A CONSIDERABLE DIFFERENCE TO DISK USE IF YOU ARE HANDLING LARGE FILES."));
        this.copyNewResourcesCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ArbilMenuBar.this.applicationConfiguration.setCopyNewResourcesToCache(ArbilMenuBar.this.copyNewResourcesCheckBoxMenuItem.isSelected());
                ArbilMenuBar.this.configurationManager.write(ArbilMenuBar.this.applicationConfiguration);
            }
        });
        this.optionsMenu.add(this.copyNewResourcesCheckBoxMenuItem);
        this.checkResourcePermissionsCheckBoxMenuItem.setSelected(this.mimeHashQueue.isCheckResourcePermissions());
        this.checkResourcePermissionsCheckBoxMenuItem.setText(menus.getString("CHECK PERMISSIONS FOR REMOTE RESOURCES"));
        this.checkResourcePermissionsCheckBoxMenuItem.setToolTipText(menus.getString("THIS OPTION CHECKS THE SERVER PERMISSIONS FOR REMOTE RESOURCES AND SHOWS ICONS ACCORDINGLY."));
        this.checkResourcePermissionsCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ArbilMenuBar.this.mimeHashQueue.setCheckResourcePermissions(ArbilMenuBar.this.checkResourcePermissionsCheckBoxMenuItem.isSelected());
                ArbilMenuBar.this.sessionStorage.saveBoolean("checkResourcePermissions", ArbilMenuBar.this.checkResourcePermissionsCheckBoxMenuItem.isSelected());
                ArbilMenuBar.this.dialogHandler.addMessageDialogToQueue(menus.getString("THE SETTING CHANGE WILL BE EFFECTIVE WHEN ARBIL IS RESTARTED."), menus.getString("CHECK PERMISSIONS FOR REMOTE RESOURCES"));
            }
        });
        this.optionsMenu.add(this.checkResourcePermissionsCheckBoxMenuItem);
        this.schemaCheckLocalFiles.setText(menus.getString("ALWAYS CHECK LOCAL METADATA FILES FOR XML CONFORMANCE"));
        this.schemaCheckLocalFiles.setSelected(this.dataNodeLoader.isSchemaCheckLocalFiles());
        this.schemaCheckLocalFiles.setToolTipText(menus.getString("THIS OPTION CHECKS ALL LOCAL METADATA FILES FOR XML CONFORMANCE EVERY TIME THEY ARE LOADED. IF THE METADATA FILE DOES NOT VALIDATE AGAINST THE SCHEMA IT WILL BE HIGHLIGHTED RED IN THE TREE."));
        this.schemaCheckLocalFiles.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ArbilMenuBar.this.dataNodeLoader.setSchemaCheckLocalFiles(ArbilMenuBar.this.schemaCheckLocalFiles.isSelected());
                ArbilMenuBar.this.sessionStorage.saveBoolean("schemaCheckLocalFiles", ArbilMenuBar.this.schemaCheckLocalFiles.isSelected());
            }
        });
        this.optionsMenu.add(this.schemaCheckLocalFiles);
        this.trackTableSelectionCheckBoxMenuItem.setSelected(this.sessionStorage.loadBoolean("trackTableSelection", false));
        this.trackTableSelectionCheckBoxMenuItem.setText(menus.getString("TRACK TABLE SELECTION IN TREE"));
        this.trackTableSelectionCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.sessionStorage.saveBoolean("useLanguageIdInColumnName", ArbilMenuBar.this.trackTableSelectionCheckBoxMenuItem.getState());
                    ArbilMenuBar.this.sessionStorage.saveBoolean("trackTableSelection", ArbilMenuBar.this.trackTableSelectionCheckBoxMenuItem.isSelected());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.trackTableSelectionCheckBoxMenuItem.setEnabled(true);
        this.optionsMenu.add(this.trackTableSelectionCheckBoxMenuItem);
        this.useLanguageIdInColumnNameCheckBoxMenuItem.setSelected(this.sessionStorage.loadBoolean("useLanguageIdInColumnName", false));
        this.useLanguageIdInColumnNameCheckBoxMenuItem.setText(menus.getString("SHOW LANGUAGE IN COLUMN NAME"));
        this.useLanguageIdInColumnNameCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.dialogHandler.offerUserToSaveChanges();
                    ArbilMenuBar.this.sessionStorage.saveBoolean("useLanguageIdInColumnName", ArbilMenuBar.this.useLanguageIdInColumnNameCheckBoxMenuItem.isSelected());
                    ArbilMenuBar.this.dataNodeLoader.requestReloadAllNodes();
                }
                catch (Exception ex) {
                    ArbilMenuBar.this.useLanguageIdInColumnNameCheckBoxMenuItem.setSelected(ArbilMenuBar.this.sessionStorage.loadBoolean("useLanguageIdInColumnName", false));
                }
            }
        });
        this.optionsMenu.add(this.useLanguageIdInColumnNameCheckBoxMenuItem);
        this.verbatimXmlStructureMenuItem.setSelected(this.applicationConfiguration.isVerbatimXmlTreeStructure());
        this.verbatimXmlStructureMenuItem.setText(menus.getString("MENU OPTION VERBATIM XML STRUCTURE IN TREE"));
        this.verbatimXmlStructureMenuItem.setToolTipText(menus.getString("MENU OPTION VERBATIM XML STRUCTURE TOOLTIP"));
        this.verbatimXmlStructureMenuItem.setEnabled(true);
        this.verbatimXmlStructureMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ArbilMenuBar.this.dialogHandler.showConfirmDialogBox(menus.getString("MENU SWITCH XML VERBATIM STRUCTURE CONFIRM"), menus.getString("MENU OPTION VERBATIM XML STRUCTURE IN TREE"))) {
                    ArbilMenuBar.this.applicationConfiguration.setVerbatimXmlTreeStructure(ArbilMenuBar.this.verbatimXmlStructureMenuItem.isSelected());
                    ArbilMenuBar.this.dataNodeLoader.saveNodesNeedingSave(false);
                    ArbilMenuBar.this.configurationManager.write(ArbilMenuBar.this.applicationConfiguration);
                    ArbilTemplateManager.getSingleInstance().unloadCmdiTemplates();
                    ArbilMenuBar.this.dataNodeLoader.requestReloadAllMetadataNodes();
                }
                ArbilMenuBar.this.verbatimXmlStructureMenuItem.setSelected(ArbilMenuBar.this.applicationConfiguration.isVerbatimXmlTreeStructure());
            }
        });
        this.optionsMenu.add(this.verbatimXmlStructureMenuItem);
        this.optionsMenu.add(new JSeparator());
        this.columnViewMenu.setText(menus.getString("COLUMN VIEW FOR NEW TABLES"));
        this.columnViewMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.colomnViewMenuMenuSelected(evt);
            }
        });
        this.optionsMenu.add(this.columnViewMenu);
        this.editFieldViewsMenuItem.setText(menus.getString("EDIT COLUMN VIEWS"));
        this.editFieldViewsMenuItem.setEnabled(false);
        this.add(this.optionsMenu);
    }

    private void initPluginMenu() {
        ArbilPluginManager pluginManager = new ArbilPluginManager(this.sessionStorage, this.windowManager, this.dataNodeLoader, BugCatcherManager.getBugCatcher());
        List<URL> pluginUlrs = pluginManager.getPluginsFromDirectoriesAndPluginsList();
        String javaVersion = System.getProperty("java.version");
        if (!javaVersion.startsWith("1.4.") && !javaVersion.startsWith("1.5.")) {
            try {
                this.add((JMenu)new PluginMenu(new PluginService(pluginUlrs.toArray(new URL[0])), (PluginManager)pluginManager, true));
            }
            catch (NoClassDefFoundError error) {
                logger.error("Failed to initialize plugin system. Probably JRE version issue despite check.", (Throwable)error);
            }
        } else {
            logger.warn("Plugins are NOT enabled due to unsupported java version {}", (Object)javaVersion);
        }
    }

    private void initWindowMenu() {
        this.windowManager.setWindowMenu(this.windowMenu);
        this.windowMenu.setText(menus.getString("WINDOW"));
        this.resetWindowsMenuItem.setText(menus.getString("RESET WINDOW LOCATIONS"));
        this.resetWindowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ArbilMenuBar.this.dialogHandler.showConfirmDialogBox(menus.getString("RESET ALL WINDOWS TO DEFAULT SIZE AND LOCATION?"), menus.getString("RESET WINDOWS"))) {
                    ArbilMenuBar.this.windowManager.resetWindows();
                }
            }
        });
        this.closeWindowsMenuItem.setText(menus.getString("CLOSE ALL WINDOWS"));
        this.closeWindowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ArbilMenuBar.this.dialogHandler.showConfirmDialogBox(menus.getString("CLOSE ALL WINDOWS?"), menus.getString("CLOSE WINDOWS"))) {
                    ArbilMenuBar.this.windowManager.closeAllWindows();
                }
            }
        });
        this.windowMenu.add(this.closeWindowsMenuItem);
        this.windowMenu.add(this.resetWindowsMenuItem);
        this.windowMenu.add(new JSeparator());
        this.add(this.windowMenu);
    }

    private void initHelpMenu() {
        this.aboutMenuItem.setText(menus.getString("ABOUT"));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.aboutMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.helpMenuItem.setText(menus.getString("HELP"));
        this.helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.helpMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.setupWizardMenuItem.setText(menus.getString("RUN SETUP WIZARD"));
        this.setupWizardMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArbilMenuBar.this.sessionStorage.saveString("wizardHasRun", menus.getString("YES"));
                ArbilSetupWizard wizard = new ArbilSetupWizard(ArbilMenuBar.this.windowManager.getMainFrame());
                wizard.showModalDialog();
            }
        });
        this.arbilForumMenuItem.setText(menus.getString("ARBIL FORUM (WEBSITE)"));
        this.arbilForumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.windowManager.openFileInExternalApplication(new URI(ArbilMenuBar.FORUM_URL));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.logConsoleMenuItem.setText(menus.getString("SHOW LOG CONSOLE"));
        this.logConsoleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ArbilLogConsole(ArbilMenuBar.this.windowManager.getMainFrame()).show();
            }
        });
        if (this.webstartHelper.isWebStart()) {
            this.logConsoleMenuItem.setEnabled(false);
            this.logConsoleMenuItem.setToolTipText(menus.getString("LOG CONSOLE NOT AVAILABLE WEB START"));
        }
        this.viewErrorLogMenuItem.setText(menus.getString("VIEW ERROR LOG"));
        this.viewErrorLogMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.windowManager.openFileInExternalApplication(ArbilMenuBar.this.logConfigurer.getLogFile(ArbilMenuBar.this.sessionStorage).toURI());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.checkForUpdatesMenuItem.setText(menus.getString("CHECK FOR UPDATES"));
        this.checkForUpdatesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!ArbilMenuBar.this.versionManager.forceUpdateCheck()) {
                        ApplicationVersion appVersion = ArbilMenuBar.this.versionManager.getApplicationVersion();
                        String versionString = appVersion.currentMajor + "." + appVersion.currentMinor + "." + appVersion.currentRevision;
                        ArbilMenuBar.this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(menus.getString("NO UPDATES FOUND, CURRENT VERSION IS {0}"), versionString), menus.getString("CHECK FOR UPDATES"));
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.shortCutKeysjMenuItem.setText(menus.getString("SHORT CUT KEYS"));
        this.shortCutKeysjMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.shortCutKeysjMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.selectLanguageMenuItem.setText(menus.getString("SELECT LANGUAGE"));
        this.selectLanguageMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    String availableLanguages = ResourceBundle.getBundle("nl/mpi/arbil/localisation/AvailableLanguages").getString("LANGUAGE CODES");
                    LocalisationSelector localisationSelector = new LocalisationSelector((PluginSessionStorage)ArbilMenuBar.this.sessionStorage, availableLanguages.split(","));
                    String please_select_your_preferred_language = menus.getString("PLEASE SELECT YOUR PREFERRED LANGUAGE");
                    String language_Selection = menus.getString("LANGUAGE SELECTION");
                    String system_Default = menus.getString("SYSTEM DEFAULT");
                    boolean languageChanged = localisationSelector.askUser(ArbilMenuBar.this.windowManager.getMainFrame(), (Icon)ArbilIcons.getSingleInstance().linorgIcon, please_select_your_preferred_language, language_Selection, system_Default);
                    localisationSelector.setLanguageFromSaved();
                    if (languageChanged) {
                        ResourceBundle menuBundle = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus");
                        ArbilMenuBar.this.dialogHandler.addMessageDialogToQueue(menuBundle.getString("PLEASE RESTART THE APPLICATION FOR THE LANGUAGE SELECTION TO BECOME VISIBLE"), menuBundle.getString("SELECT LANGUAGE"));
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.helpMenu.setText(menus.getString("HELP"));
        this.helpMenu.add(this.aboutMenuItem);
        this.helpMenu.add(this.helpMenuItem);
        this.helpMenu.add(this.setupWizardMenuItem);
        this.helpMenu.add(this.shortCutKeysjMenuItem);
        this.helpMenu.add(new JSeparator());
        this.helpMenu.add(this.arbilForumMenuItem);
        this.helpMenu.add(this.checkForUpdatesMenuItem);
        this.helpMenu.add(new JSeparator());
        this.helpMenu.add(this.viewErrorLogMenuItem);
        this.helpMenu.add(this.logConsoleMenuItem);
        this.helpMenu.add(new JSeparator());
        this.helpMenu.add(this.selectLanguageMenuItem);
        this.add(this.helpMenu);
        this.helpMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.viewErrorLogMenuItem.setEnabled(ArbilMenuBar.this.logConfigurer.getLogFile(ArbilMenuBar.this.sessionStorage).exists());
            }
        });
    }

    private void setUpHotKeys() {
        int modifier = this.hostOS == HostOS.MACOS ? 256 : 128;
        this.saveFileMenuItem.setMnemonic(83);
        KeyStroke saveKeyStroke = KeyStroke.getKeyStroke(83, modifier);
        this.saveFileMenuItem.setAccelerator(saveKeyStroke);
        this.getActionMap().put("save", this.saveAction);
        this.getInputMap(2).put(saveKeyStroke, "save");
        KeyStroke undoKeyStroke = KeyStroke.getKeyStroke(90, modifier);
        this.undoMenuItem.setAccelerator(undoKeyStroke);
        this.getActionMap().put("undo", this.undoAction);
        this.getInputMap(2).put(undoKeyStroke, "undo");
        KeyStroke redoKeyStroke = KeyStroke.getKeyStroke(90, 0x40 | modifier);
        this.redoMenuItem.setAccelerator(redoKeyStroke);
        this.getActionMap().put("redo", this.redoAction);
        this.getInputMap(2).put(redoKeyStroke, "redo");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(89, modifier), "redo");
        this.searchReplaceMenuItem.setMnemonic(70);
        this.searchReplaceMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, modifier));
        this.showStatusBarMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, modifier));
        this.showSelectionPreviewCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, modifier));
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.zoomInMenuItem.setMnemonic(521);
        this.zoomInMenuItem.setAccelerator(KeyStroke.getKeyStroke(521, modifier));
        this.getActionMap().put("zoomIn", this.zoomInAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(521, modifier), "zoomIn");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(107, modifier), "zoomIn");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(61, modifier), "zoomIn");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(61, modifier | 0x40), "zoomIn");
        this.zoomOutMenuItem.setMnemonic(45);
        this.zoomOutMenuItem.setAccelerator(KeyStroke.getKeyStroke(45, modifier));
        this.getActionMap().put("zoomOut", this.zoomOutAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(45, modifier), "zoomOut");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(109, modifier), "zoomOut");
        this.zoomResetMenuItem.setMnemonic(48);
        this.zoomResetMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, modifier));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(48, modifier), "zoomReset");
    }

    private void colomnViewMenuMenuSelected(MenuEvent evt) {
        this.initColumnViewMenu(this.columnViewMenu);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.performCleanExit();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        this.windowManager.openAboutPage();
    }

    private void shortCutKeysjMenuItemActionPerformed(ActionEvent evt) {
        ArbilHelp helpComponent = this.getArbilHelp();
        if (helpComponent != null) {
            if (null == this.windowManager.focusWindow(ArbilHelp.helpWindowTitle)) {
                this.windowManager.createWindow(ArbilHelp.helpWindowTitle, helpComponent);
            }
            helpComponent.setCurrentPage("IMDI", ArbilHelp.SHOTCUT_KEYS_PAGE);
        }
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        ArbilHelp arbilHelp = this.getArbilHelp();
        if (arbilHelp != null && null == this.windowManager.focusWindow(ArbilHelp.helpWindowTitle)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JInternalFrame helpWindow = ArbilMenuBar.this.windowManager.createWindow(ArbilHelp.helpWindowTitle, ArbilMenuBar.this.getArbilHelp());
                    helpWindow.setSize(800, 600);
                }
            });
        }
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        try {
            ImportExportDialog importExportDialog = new ImportExportDialog(this.treeHelper.getArbilTreePanel().remoteCorpusTree);
            importExportDialog.importArbilBranch();
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError(e);
            logger.debug(e.getMessage());
        }
    }

    private boolean saveApplicationState() {
        if (this.dataNodeLoader.nodesNeedSave()) {
            switch (JOptionPane.showConfirmDialog(this, menus.getString("SAVE CHANGES BEFORE EXITING?"), menus.getString("ARBIL"), 1, -1)) {
                case 1: {
                    break;
                }
                case 0: {
                    this.dataNodeLoader.saveNodesNeedingSave(false);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        this.saveState(this.saveWindowsCheckBoxMenuItem.isSelected());
        this.sessionStorage.saveBoolean("saveWindows", this.saveWindowsCheckBoxMenuItem.isSelected());
        this.sessionStorage.saveBoolean("checkNewVersionAtStart", this.checkNewVersionAtStartCheckBoxMenuItem.isSelected());
        return true;
    }

    private void saveState(boolean saveWindows) {
        ArbilFieldViews.getSingleInstance().saveViewsToFile();
        if (saveWindows) {
            this.windowManager.saveWindowStates();
        }
    }

    public boolean performCleanExit() {
        this.windowManager.stopEditingInCurrentWindow();
        if (this.saveApplicationState()) {
            Runnable exitRunner = new Runnable(){

                public void run() {
                    new HashQueueTerminator(ArbilMenuBar.this.mimeHashQueue, ArbilMenuBar.this.windowManager).terminateHashQueue();
                    System.exit(0);
                }
            };
            new Thread(exitRunner).start();
            return true;
        }
        return false;
    }

    private void initColumnViewMenu(JMenu menu) {
        menu.removeAll();
        ButtonGroup viewMenuButtonGroup = new ButtonGroup();
        Enumeration menuItemName = ArbilFieldViews.getSingleInstance().getSavedFieldViewLables();
        while (menuItemName.hasMoreElements()) {
            String currentMenuName = menuItemName.nextElement().toString();
            JRadioButtonMenuItem viewLabelRadioButtonMenuItem = new JRadioButtonMenuItem();
            viewMenuButtonGroup.add(viewLabelRadioButtonMenuItem);
            viewLabelRadioButtonMenuItem.setSelected(ArbilFieldViews.getSingleInstance().getCurrentGlobalViewName().equals(currentMenuName));
            viewLabelRadioButtonMenuItem.setText(currentMenuName);
            viewLabelRadioButtonMenuItem.setName(currentMenuName);
            viewLabelRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        ArbilFieldViews.getSingleInstance().setCurrentGlobalViewName(((Component)evt.getSource()).getName());
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            });
            menu.add(viewLabelRadioButtonMenuItem);
        }
    }

    public static class HashQueueTerminator {
        private static final int HASH_QUEUE_WAIT_TIME = 500;
        private final Object terminationLockObject = new Object();
        private final MimeHashQueue mimeHashQueue;
        private final WindowManager windowManager;
        private boolean terminationComplete = false;
        private JDialog messageDialogue;

        public HashQueueTerminator(MimeHashQueue mimeHashQueue, WindowManager windowManager) {
            this.mimeHashQueue = mimeHashQueue;
            this.windowManager = windowManager;
        }

        public void terminateHashQueue() {
            this.startTerminatorThread();
            this.waitForTerminatorThread();
        }

        private void startTerminatorThread() {
            Runnable terminator = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = HashQueueTerminator.this.terminationLockObject;
                    synchronized (object) {
                        HashQueueTerminator.this.terminationComplete = false;
                    }
                    HashQueueTerminator.this.mimeHashQueue.terminateQueue();
                    object = HashQueueTerminator.this.terminationLockObject;
                    synchronized (object) {
                        HashQueueTerminator.this.terminationComplete = true;
                        HashQueueTerminator.this.terminationLockObject.notifyAll();
                    }
                }
            };
            Thread terminatorThread = new Thread(terminator);
            terminatorThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForTerminatorThread() {
            boolean messageDialogueShown = false;
            while (!this.terminationComplete) {
                Object object = this.terminationLockObject;
                synchronized (object) {
                    block7: {
                        try {
                            logger.debug("Waiting for mime hash queue termination to finish");
                            this.terminationLockObject.wait(500L);
                            if (!this.terminationComplete && !messageDialogueShown) {
                                logger.info("Mime hash queue is busy while trying to exit application. Current node: {}", (Object)this.mimeHashQueue.getActiveNode());
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        HashQueueTerminator.this.messageDialogue = new JDialog(HashQueueTerminator.this.windowManager.getMainFrame(), services.getString("TYPECHECKING_IN_PROGRESS"), true);
                                        JLabel label = new JLabel(services.getString("FINISHING_TYPECHECKING"));
                                        label.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
                                        HashQueueTerminator.this.messageDialogue.getContentPane().add(label);
                                        HashQueueTerminator.this.messageDialogue.setLocationRelativeTo(HashQueueTerminator.this.windowManager.getMainFrame());
                                        HashQueueTerminator.this.messageDialogue.setDefaultCloseOperation(0);
                                        HashQueueTerminator.this.messageDialogue.pack();
                                        HashQueueTerminator.this.messageDialogue.setVisible(true);
                                    }
                                });
                                messageDialogueShown = true;
                            }
                        }
                        catch (InterruptedException ex) {
                            if (this.messageDialogue == null) break block7;
                            this.messageDialogue.dispose();
                        }
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (HashQueueTerminator.this.messageDialogue != null) {
                        HashQueueTerminator.this.messageDialogue.dispose();
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HostOS {
        MACOS,
        OTHER;

    }
}

