/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.handle.hdllib4.HandleException;
import net.handle.hdllib4.InvalidPacketException;
import net.handle.hdllib4.XdrDecoder;
import net.handle.hdllib4.XdrEncoder;
import net.handle.hdllib4.XdrEncodingException;

public class ResponsePacketBody {
    private long[] objectFlags;
    private long numberOfDataItems;
    private byte[] data;
    private byte[] redirectedHandleServer;
    private int udpPortNumber;
    private int tcpPortNumber;
    private int expectedVersion;
    private String diagnostic;
    private byte[] packetBuffer = null;
    private boolean dirty = true;
    private boolean parsed = false;

    public ResponsePacketBody(byte[] body) {
        this.packetBuffer = body;
        this.dirty = false;
    }

    public ResponsePacketBody(int errorCode, byte[] body, int offset, int length) throws InvalidPacketException, IOException, XdrEncodingException {
        this.initFromBufferResponsePacketBody(errorCode, body, offset, length);
    }

    private synchronized void initFromBufferResponsePacketBody(int errorCode, byte[] body, int offset, int length) throws InvalidPacketException, IOException, XdrEncodingException {
        if (offset == 0 && length == body.length) {
            this.packetBuffer = body;
        } else {
            this.packetBuffer = new byte[length];
            System.arraycopy(body, offset, this.packetBuffer, 0, length);
        }
        this.dirty = false;
        XdrDecoder decoder = new XdrDecoder(this.packetBuffer);
        if (errorCode == 0) {
            MessageDigest md5Digest;
            this.objectFlags = decoder.readUIntArray();
            this.numberOfDataItems = decoder.readUnsignedInt();
            this.data = decoder.readBytes(Math.max(decoder.getRemainingByteCount() - 16, 0));
            byte[] checksum = decoder.readBytes(16);
            try {
                md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidPacketException("MD5 algorithm missing");
            }
            byte[] dataBuf = new byte[Math.max(0, this.packetBuffer.length - 16)];
            System.arraycopy(this.packetBuffer, 0, dataBuf, 0, dataBuf.length);
            byte[] newChecksum = md5Digest.digest(dataBuf);
            if (!MessageDigest.isEqual(newChecksum, checksum)) {
                throw new InvalidPacketException("MD5 checksum failed");
            }
        } else if (errorCode == 4) {
            this.redirectedHandleServer = decoder.readByteArray();
            this.udpPortNumber = decoder.readShort();
            this.tcpPortNumber = decoder.readShort();
        } else if (errorCode == 6) {
            this.redirectedHandleServer = decoder.readByteArray();
        } else if (errorCode == 2) {
            this.expectedVersion = decoder.readInt();
        } else if (errorCode == 3) {
            this.diagnostic = decoder.readString();
        } else if (errorCode == 1) {
            this.diagnostic = decoder.readString();
        }
        this.parsed = true;
    }

    public synchronized void parsePacket(int errorCode) throws InvalidPacketException, IOException, XdrEncodingException {
        if (!this.parsed) {
            this.initFromBufferResponsePacketBody(errorCode, this.packetBuffer, 0, this.packetBuffer.length);
        }
    }

    public synchronized byte[] encodeErrorPacketBody(int errorCode) throws HandleException {
        XdrEncoder encoder = new XdrEncoder(484);
        if (errorCode == 4) {
            encoder.writeByteArray(this.redirectedHandleServer);
            encoder.writeUInt(this.udpPortNumber);
            encoder.writeUInt(this.tcpPortNumber);
        } else if (errorCode == 6) {
            encoder.writeByteArray(this.redirectedHandleServer);
        } else if (errorCode == 2) {
            encoder.writeInt(1);
        } else {
            if (errorCode == 3) {
                try {
                    encoder.writeByteArray(this.diagnostic.getBytes("UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new HandleException(7, "unable to encode UTF8 string");
                }
            }
            if (errorCode == 1) {
                try {
                    encoder.writeByteArray(this.diagnostic.getBytes("UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new HandleException(7, "unable to encode UTF8 string");
                }
            }
        }
        return encoder.getCurrentBuffer();
    }

    public synchronized byte[] encodePacketBody() throws InvalidPacketException {
        MessageDigest md5Digest;
        if (!this.dirty) {
            return this.packetBuffer;
        }
        XdrEncoder encoder = new XdrEncoder(484);
        if (this.objectFlags == null) {
            encoder.writeUIntArray(new long[0]);
        } else {
            encoder.writeUIntArray(this.objectFlags);
        }
        encoder.writeUInt(this.numberOfDataItems);
        encoder.writeBytes(this.data);
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidPacketException("MD5 algorithm missing");
        }
        byte[] checksum = md5Digest.digest(encoder.getCurrentBuffer());
        encoder.writeBytes(checksum);
        this.packetBuffer = encoder.getCurrentBuffer();
        this.dirty = false;
        return this.packetBuffer;
    }

    public void setObjectFlags(long[] newObjectFlags) {
        this.objectFlags = newObjectFlags;
        this.dirty = true;
    }

    public long[] getObjectFlags() {
        if (!this.parsed) {
            try {
                this.parsePacket(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.objectFlags;
    }

    public void setNumberOfDataItems(long numberOfDataItems) {
        this.numberOfDataItems = numberOfDataItems;
        this.dirty = true;
    }

    public long getNumberOfDataItems() {
        if (!this.parsed) {
            try {
                this.parsePacket(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.numberOfDataItems;
    }

    public void setData(byte[] buf) {
        this.data = buf;
        this.dirty = true;
    }

    public byte[] getData() {
        if (!this.parsed) {
            try {
                this.parsePacket(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.data;
    }

    public byte[] getRedirectedHandleServer() {
        return this.redirectedHandleServer;
    }

    public void setRedirectedHandleServer(byte[] redirectedHandleServer) {
        this.redirectedHandleServer = redirectedHandleServer;
        this.dirty = true;
    }

    public int getUdpPortNumber() {
        return this.udpPortNumber;
    }

    public void setUdpPortNumber(int newUdpPortNumber) {
        this.udpPortNumber = newUdpPortNumber;
        this.dirty = true;
    }

    public int getTcpPortNumber() {
        return this.tcpPortNumber;
    }

    public void setTcpPortNumber(int newTcpPortNumber) {
        this.tcpPortNumber = newTcpPortNumber;
        this.dirty = true;
    }

    public int getExpectedVersion() {
        return this.expectedVersion;
    }

    public void setExpectedVersion(int newExpectedVersion) {
        this.expectedVersion = newExpectedVersion;
        this.dirty = true;
    }

    public void setDiagnostic(String diag) {
        this.diagnostic = diag;
        this.dirty = true;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }
}

