/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdi.api;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.mpi.imdi.api.IMDIAPIImpl;
import nl.mpi.imdi.api.WSNodeType;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class IMDIXMLFormat {
    public static DocumentBuilder docBuilder;
    public static DocumentBuilder valDocBuilder;
    public static final String defLangId = "ISO639-2:eng";
    public static final String uridAttribName = "ArchiveHandle";
    public static final String nameAttribName = "Name";
    public static final String langIdAttribName = "LanguageId";
    public static final String resourceLinkName = "ResourceLink";
    public static final String sessionName = "Session";
    public static final String corpusName = "Corpus";
    public static final String catalogueName = "Catalogue";
    public static final String notyetProtoName = "notyet";
    public static final String topXpath = "/:METATRANSCRIPT";
    protected static final String catalogueLinkName = "Corpus.Catalogue.CatalogueLink";
    protected static final String catalogueLinkURIDName = "Corpus.Catalogue.CatalogueHandle";
    private static final String resourcesXpath = "/:METATRANSCRIPT/:Session/:Resources";
    private static final String[] elementNames;
    private static final String[] elementXPath;
    private static final String[] xPathQueries;
    private static final String[] linkXPath;
    private static final Vector removeableIMDIElements;
    private static final String idAttribName = "id";
    private static final String formatElementName = "Format";
    private static final String typeElementName = "Type";
    private static Logger logger;
    private static final String resDir = "resources";
    private static final String specLang = "resources/SpecLang.xml";
    private static final String schema = "resources/IMDI_3.0.xsd";
    private static final String corpusTemplate = "resources/CORPUS.LAMS.Profile.xml";
    private static final String catalogueTemplate = "resources/CATALOGUE.Profile.xml";
    private static final String sessionTemplate = "resources/SESSION.LAMS.Profile.xml";
    private static Hashtable spec2xpath;
    private static Hashtable xpath2spec;

    IMDIXMLFormat() {
    }

    private static int indexForType(int type) {
        if (type == 1) {
            return 0;
        }
        if (type == 2) {
            return 1;
        }
        if (type == 3) {
            return 2;
        }
        if (type == 4) {
            return 3;
        }
        if (type == 5) {
            return 4;
        }
        if (type == 6) {
            return 5;
        }
        if (type == 7) {
            return 6;
        }
        if (type == 8) {
            return 7;
        }
        logger.error("indexForType: Unsupported type: " + type);
        return -1;
    }

    protected static String getElementName(int type) {
        return elementNames[IMDIXMLFormat.indexForType(type)];
    }

    private static String getElementXPath(int type) {
        return elementXPath[IMDIXMLFormat.indexForType(type)];
    }

    protected static String getXPathQuery(int type) {
        return xPathQueries[IMDIXMLFormat.indexForType(type)];
    }

    protected static String getLinkXPath(int type) {
        return linkXPath[IMDIXMLFormat.indexForType(type)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadTemplate(int type) {
        Document doc = null;
        DocumentBuilder documentBuilder = docBuilder;
        synchronized (documentBuilder) {
            try {
                if (type == 1) {
                    doc = docBuilder.parse(IMDIAPIImpl.class.getResource(sessionTemplate).openStream());
                    doc.normalize();
                } else if (type == 2) {
                    doc = docBuilder.parse(IMDIAPIImpl.class.getResource(corpusTemplate).openStream());
                    doc.normalize();
                } else if (type == 8) {
                    doc = docBuilder.parse(IMDIAPIImpl.class.getResource(catalogueTemplate).openStream());
                    doc.normalize();
                } else {
                    doc = null;
                    logger.error("Cannot load template for IMDI file type: " + WSNodeType.nameForType(type));
                }
            }
            catch (SAXException se) {
                doc = null;
                logger.error("SAXException loading template: " + se.getMessage());
            }
            catch (IOException ioe) {
                doc = null;
                logger.error("IOException loading template: " + ioe.getMessage());
            }
            catch (NullPointerException npe) {
                doc = null;
                logger.error("NullPointerException loading template: " + npe.getMessage());
            }
        }
        return doc;
    }

    public static Element selectElement(Node root, int type) {
        if (root == null) {
            return null;
        }
        try {
            Node node = XPathAPI.selectSingleNode((Node)root, (String)IMDIXMLFormat.getElementXPath(type));
            if (node != null && node instanceof Element) {
                return (Element)node;
            }
            if (node == null) {
                return null;
            }
            logger.error("Node is not an element in selectElement(...," + WSNodeType.nameForType(type) + ")");
        }
        catch (TransformerException te) {
            logger.error("TransformerException in selectElement");
        }
        return null;
    }

    public static Node selectLink(Node root, int type) {
        if (root == null) {
            return null;
        }
        try {
            return XPathAPI.selectSingleNode((Node)root, (String)(".//" + IMDIXMLFormat.getLinkXPath(type)));
        }
        catch (TransformerException te) {
            logger.error("TransformerException in selectLink");
            return null;
        }
    }

    public static Node selectFormat(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!formatElementName.equals(n.getNodeName())) continue;
            return n;
        }
        return null;
    }

    public static Node selectType(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!typeElementName.equals(n.getNodeName())) continue;
            return n;
        }
        return null;
    }

    public static Element selectResources(Node root) {
        if (root == null) {
            return null;
        }
        try {
            Node node = XPathAPI.selectSingleNode((Node)root, (String)"//:Resources");
            if (node == null || !(node instanceof Element)) {
                return null;
            }
            return (Element)node;
        }
        catch (TransformerException te) {
            logger.error("TransformerException in selectResources");
            return null;
        }
    }

    public static Element getElementById(String id, Node contextNode) {
        String currentId = IMDIXMLFormat.getDomId(contextNode);
        if (currentId != null && id.equals(IMDIXMLFormat.getDomId(contextNode))) {
            return (Element)contextNode;
        }
        try {
            Node n = XPathAPI.selectSingleNode((Node)contextNode, (String)(".//*[@id=\"" + id + "\"]"));
            if (n != null && n instanceof Element) {
                return (Element)n;
            }
        }
        catch (TransformerException tfe) {
            logger.error("getElementById: got TransformerException while matching for Element with id " + id);
        }
        return null;
    }

    public static boolean isRemovable(String spec) {
        if (spec == null) {
            return false;
        }
        if (spec.startsWith("Catalogue.Publisher")) {
            return true;
        }
        int pastLastDot = spec.lastIndexOf(46) + 1;
        int bidx = spec.lastIndexOf(40);
        if (bidx < 0 || bidx < pastLastDot) {
            bidx = spec.length();
        }
        String lastPathElement = spec.substring(pastLastDot, bidx);
        return removeableIMDIElements.contains(lastPathElement);
    }

    public static String whichAttribute(String spec) {
        String attName;
        if (spec == null) {
            return null;
        }
        String specCheck = spec.replaceAll("\\(\\d+\\)", "\\(X\\)");
        String simpleXPath = (String)spec2xpath.get(specCheck);
        if (simpleXPath == null && (attName = IMDIXMLFormat.isKnownAttributeSpec(specCheck)) != null) {
            return attName;
        }
        if (simpleXPath == null) {
            logger.warn("whichAttribute: invalid spec, cannot check: " + spec);
            return null;
        }
        if (!IMDIXMLFormat.pointsToAttribute(simpleXPath)) {
            return null;
        }
        attName = simpleXPath.substring(simpleXPath.indexOf("[@") + 2);
        return attName.substring(0, attName.length() - 1);
    }

    public static boolean pointsToAttribute(String query) {
        if (query == null) {
            return false;
        }
        return query.indexOf("[@") != -1;
    }

    public static String spec2XPath(String spec) {
        String xPath;
        String attName;
        if (spec == null || spec.equals("")) {
            logger.info("Warning: spec2XPath: spec null or empty");
            return "";
        }
        String specCheck = spec.replaceAll("\\(\\d+\\)", "\\(X\\)");
        String trans = (String)spec2xpath.get(specCheck);
        if (trans == null && (attName = IMDIXMLFormat.isKnownAttributeSpec(specCheck)) != null) {
            trans = (String)spec2xpath.get(specCheck.replaceAll("." + attName, "")) + "[@" + attName + "]";
        }
        if ((xPath = IMDIXMLFormat.translatePath(specCheck, spec, trans, "[", "]")) != null) {
            return "/" + xPath;
        }
        logger.debug("spec2XPath failed for: " + spec);
        return null;
    }

    public static String generateSpecFromNode(Node node) {
        return IMDIXMLFormat.generateAttribSpecFromNode(node, null);
    }

    public static String generateAttribSpecFromNode(Node node, String attribName) {
        String result = null;
        if (node == null) {
            return null;
        }
        result = IMDIXMLFormat.generateXPathFromNode(node);
        if (result.startsWith("#document/")) {
            result = result.substring(10);
        } else if (result.startsWith(":#document/")) {
            result = result.substring(11);
        }
        if (result.indexOf(58) == -1) {
            result = ":" + result.replaceAll("/", "/:");
        }
        if (attribName != null) {
            result = result + "[@" + attribName + "]";
        }
        return IMDIXMLFormat.xPath2Spec(result);
    }

    public static String generateCachedSpecFromNode(Node node, Map cache) {
        String result = null;
        if (node == null) {
            return null;
        }
        if (IMDIXMLFormat.getDomId(node) == null) {
            logger.error("generateCachedSpecFromNode needs domIds");
            return null;
        }
        result = IMDIXMLFormat.generateCachedXPathFromNode(node, cache);
        if (result.startsWith("#document/")) {
            result = result.substring(10);
        } else if (result.startsWith(":#document/")) {
            result = result.substring(11);
        }
        if (result.indexOf(58) == -1) {
            result = ":" + result.replaceAll("/", "/:");
        }
        result = IMDIXMLFormat.xPath2Spec(result);
        return result;
    }

    public static boolean domify(Document doc) {
        try {
            Node rootThing = XPathAPI.selectSingleNode((Node)doc.getDocumentElement(), (String)topXpath);
            if (IMDIXMLFormat.getDomId(rootThing) != null) {
                return true;
            }
            if (!IMDIXMLFormat.addDomIds(doc, doc.getDocumentElement())) {
                logger.warn("setting DomIds failed");
                return false;
            }
        }
        catch (TransformerException te) {
            logger.error("TransformerException while adding DomIds: " + te);
            return false;
        }
        return true;
    }

    public static boolean addDomIds(Document doc, Node startNode) {
        Element root = doc.getDocumentElement();
        String idvalue = IMDIXMLFormat.getDomId(root);
        int startId = 1;
        if (idvalue != null && idvalue.trim().length() > 0) {
            if (!idvalue.startsWith("i")) {
                logger.warn("addDomIds: document element ID value must start with an i: " + idvalue);
                return false;
            }
            try {
                startId = Integer.parseInt(idvalue.substring(1));
            }
            catch (NumberFormatException nfe) {
                logger.error("addDomIds: Invalid document element ID: " + idvalue);
                return false;
            }
        }
        int nextStartId = IMDIXMLFormat.addDomIds_(startNode, startId, doc);
        root.setAttribute(idAttribName, "i" + nextStartId);
        return true;
    }

    public static void removeDomIds(Element startElement) {
        startElement.removeAttribute(idAttribName);
        NodeList childs = startElement.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1 || !(child instanceof Element)) continue;
            IMDIXMLFormat.removeDomIds((Element)child);
        }
    }

    public static boolean setFirstChildValue(Document doc, Node parentNode, String value) {
        if (parentNode == null) {
            return false;
        }
        if (parentNode.getFirstChild() != null) {
            parentNode.getFirstChild().setNodeValue(value);
        } else {
            parentNode.appendChild(doc.createTextNode(value));
        }
        return true;
    }

    public static String getFirstChildValue(Node node) {
        if (node == null) {
            return null;
        }
        Node child = node.getFirstChild();
        if (child == null) {
            return null;
        }
        return child.getNodeValue();
    }

    public static String getAttribute(Node n, String attName) {
        if (n == null || !(n instanceof Element)) {
            return null;
        }
        if (!((Element)n).hasAttribute(attName)) {
            return null;
        }
        return ((Element)n).getAttribute(attName);
    }

    public static String getDomId(Node n) {
        String id = IMDIXMLFormat.getAttribute(n, idAttribName);
        if (id == null || id.length() == 0) {
            return null;
        }
        if (!id.startsWith("i")) {
            logger.debug("getDomId: invalid domId: " + id);
            return null;
        }
        return id;
    }

    private static String isKnownAttributeSpec(String spec) {
        if (spec.indexOf("Key.") != -1 || spec.indexOf("Key(X).") != -1) {
            if (spec.endsWith(nameAttribName)) {
                return nameAttribName;
            }
            if (spec.endsWith("Link")) {
                return "Link";
            }
            if (spec.endsWith(typeElementName)) {
                return typeElementName;
            }
            if (spec.endsWith("DefaultLink")) {
                return "DefaultLink";
            }
        }
        if (spec.indexOf("Description.") != -1 || spec.indexOf("Description(X).") != -1) {
            if (spec.endsWith("Link")) {
                return "Link";
            }
            if (spec.endsWith(langIdAttribName)) {
                return langIdAttribName;
            }
            if (spec.endsWith(nameAttribName)) {
                return nameAttribName;
            }
        }
        return null;
    }

    private static String isKnownAttributeXPath(String xpath) {
        if (xpath.indexOf("/:Key[@") != -1 || xpath.indexOf("/:Key[X][@") != -1) {
            if (xpath.endsWith("[@Name]")) {
                return nameAttribName;
            }
            if (xpath.endsWith("[@Link]")) {
                return "Link";
            }
            if (xpath.endsWith("[@Type]")) {
                return typeElementName;
            }
            if (xpath.endsWith("[@DefaultLink]")) {
                return "DefaultLink";
            }
        }
        if (xpath.indexOf("/:Description[@") != -1 || xpath.indexOf("/:Description[X][@") != -1) {
            if (xpath.endsWith("[@Link]")) {
                return "Link";
            }
            if (xpath.endsWith("[@LanguageId]")) {
                return langIdAttribName;
            }
            if (xpath.endsWith("[@Name]")) {
                return nameAttribName;
            }
        }
        return null;
    }

    private static String translatePath(String input, String rawInput, String template, String left, String right) {
        int j;
        if (template == null) {
            logger.error("Cannot translate spec / path: " + rawInput + " (context: " + input + ")");
            return null;
        }
        if (template.indexOf(left + "X" + right) == -1) {
            return template;
        }
        String[] tParts = template.split("\\" + left + "X\\" + right);
        String numbers = rawInput.replaceFirst("\\D+", "");
        numbers = numbers.replaceAll("\\D+", ",");
        String[] nParts = numbers.split(",");
        String result = new String();
        for (j = 0; j < nParts.length; ++j) {
            result = result + tParts[j] + left + nParts[j] + right;
        }
        if (j < tParts.length) {
            result = result + tParts[j];
        }
        return result;
    }

    private static String xPath2Spec(String xpath) {
        String attName;
        if (xpath == null || xpath.equals("")) {
            logger.info("Warning: xPath2Spec: xpath null or empty");
            return "";
        }
        String xpathCheck = xpath.replaceAll("\\[\\d+\\]", "\\[X\\]");
        String trans = (String)xpath2spec.get(xpathCheck);
        if (trans == null && (attName = IMDIXMLFormat.isKnownAttributeXPath(xpathCheck)) != null) {
            String xpath2 = xpathCheck.substring(0, xpathCheck.indexOf("[@"));
            trans = (String)xpath2spec.get(xpath2) + "." + attName;
        }
        return IMDIXMLFormat.translatePath(xpathCheck, xpath, trans, "(", ")");
    }

    private static String generateXPathFromNode(Node node) {
        String nodename = node.getNodeName();
        Node parent = node.getParentNode();
        if (parent == null) {
            return (nodename.indexOf(":") == -1 ? ":" : "") + nodename;
        }
        int count = 0;
        for (Node tmp = node; tmp != null; tmp = tmp.getPreviousSibling()) {
            if (tmp == null || !tmp.getNodeName().equals(nodename)) continue;
            ++count;
        }
        if (nodename.equals("METATRANSCRIPT")) {
            count = 1;
        }
        return IMDIXMLFormat.generateXPathFromNode(parent) + "/" + nodename + (count > 1 ? "[" + count + "]" : "");
    }

    private static String generateCachedXPathFromNode(Node node, Map cache) {
        String nodeKey;
        String nodename = node.getNodeName();
        Node parent = node.getParentNode();
        if (parent == null) {
            return (nodename.indexOf(":") == -1 ? ":" : "") + nodename;
        }
        int count = 0;
        for (Node tmp = node; tmp != null; tmp = tmp.getPreviousSibling()) {
            if (tmp == null || !tmp.getNodeName().equals(nodename)) continue;
            ++count;
            String tmpKey = IMDIXMLFormat.getDomId(tmp);
            Integer cached = null;
            if (tmpKey != null) {
                cached = (Integer)cache.get(tmpKey);
            }
            if (cached == null) continue;
            count = cached + count - 1;
            break;
        }
        if (nodename.equals("METATRANSCRIPT")) {
            count = 1;
        }
        if ((nodeKey = IMDIXMLFormat.getDomId(node)) != null && !cache.containsKey(nodeKey)) {
            cache.put(nodeKey, new Integer(count));
        }
        StringBuilder result = new StringBuilder(IMDIXMLFormat.generateCachedXPathFromNode(parent, cache));
        result.append('/');
        result.append(nodename);
        if (count > 1) {
            result.append('[');
            result.append(count);
            result.append(']');
        }
        return result.toString();
    }

    private static int addDomIds_(Node startNode, int startId, Document doc) {
        if (!(startNode instanceof Element)) {
            return startId;
        }
        int nextStartId = startId;
        ((Element)startNode).setAttribute(idAttribName, "i" + nextStartId);
        ++nextStartId;
        NodeList childs = startNode.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            if (childs.item(i).getNodeType() != 1) continue;
            nextStartId = IMDIXMLFormat.addDomIds_(childs.item(i), nextStartId, doc);
        }
        return nextStartId;
    }

    static {
        elementNames = new String[]{"CorpusLink", "CorpusLink", "Description", "WrittenResource", "MediaFile", "unknown", "LexiconResource", corpusName};
        elementXPath = new String[]{"/:METATRANSCRIPT/:Session", "/:METATRANSCRIPT/:Corpus", ":" + elementNames[2], "/:METATRANSCRIPT/:Session/:Resources/:" + elementNames[3], "/:METATRANSCRIPT/:Session/:Resources/:" + elementNames[4], elementNames[5], "/:METATRANSCRIPT/:Session/:Resources/:" + elementNames[6], "/:METATRANSCRIPT/:Catalogue"};
        xPathQueries = new String[]{elementXPath[1] + "/:" + elementNames[0], elementXPath[1] + "/:" + elementNames[1], elementXPath[2], elementXPath[3] + "/:" + resourceLinkName, elementXPath[4] + "/:" + resourceLinkName, elementXPath[5], elementXPath[6] + "/:" + resourceLinkName, elementXPath[1]};
        linkXPath = new String[]{":" + elementNames[0], ":" + elementNames[1], "Link", ":ResourceLink", ":ResourceLink", elementNames[5], ":ResourceLink", "CatalogueLink"};
        removeableIMDIElements = new Vector();
        removeableIMDIElements.add(elementNames[0]);
        removeableIMDIElements.add(elementNames[2]);
        removeableIMDIElements.add(elementNames[3]);
        removeableIMDIElements.add(elementNames[4]);
        removeableIMDIElements.add(elementNames[6]);
        removeableIMDIElements.add("SelfHandle");
        removeableIMDIElements.add("Actor");
        removeableIMDIElements.add("Source");
        removeableIMDIElements.add("Region");
        removeableIMDIElements.add("Language");
        removeableIMDIElements.add("Project");
        removeableIMDIElements.add("CatalogueLink");
        removeableIMDIElements.add("CatalogueHandle");
        removeableIMDIElements.add("ContentType");
        removeableIMDIElements.add("LocationList");
        removeableIMDIElements.add("Author");
        removeableIMDIElements.add("Key");
        removeableIMDIElements.add(nameAttribName);
        removeableIMDIElements.add(typeElementName);
        removeableIMDIElements.add("Link");
        removeableIMDIElements.add("DefaultLink");
        logger = LoggerFactory.getLogger((String)IMDIXMLFormat.class.getName());
        spec2xpath = new Hashtable();
        xpath2spec = new Hashtable();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(null);
            builder.setErrorHandler(null);
            Document specDoc = builder.parse(IMDIXMLFormat.class.getResource(specLang).openStream());
            specDoc.normalize();
            Element root = specDoc.getDocumentElement();
            NodeList nodes = XPathAPI.selectNodeList((Node)root, (String)"//from");
            for (int i = 0; i < nodes.getLength(); ++i) {
                String from = nodes.item(i).getFirstChild().getNodeValue();
                String to = nodes.item(i).getNextSibling().getFirstChild().getNodeValue();
                spec2xpath.put(from, to);
                xpath2spec.put(to, from);
            }
        }
        catch (TransformerException te) {
            logger.error("TransformerException loading SpecLang: " + te.getMessage());
        }
        catch (SAXException sxe) {
            logger.error("SAXException opening specLang.xml: " + sxe.getMessage());
        }
        catch (ParserConfigurationException pce) {
            logger.error("ParserConfigurationException opening specLang.xml:" + pce.getMessage());
        }
        catch (IOException ioe) {
            logger.error("IOException opening specLang.xml: " + ioe.getMessage());
        }
        catch (NullPointerException npe) {
            logger.error("NullPointerException opening specLang.xml: " + npe.getMessage());
        }
        factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            docBuilder = factory.newDocumentBuilder();
            factory.setValidating(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", IMDIAPIImpl.class.getResource(schema).openStream());
            valDocBuilder = factory.newDocumentBuilder();
        }
        catch (IllegalArgumentException iae) {
            logger.error("IllegalArgumentException setting DocumentBuilderFactory attributes: " + iae.getMessage(), (Throwable)iae);
        }
        catch (ParserConfigurationException pce) {
            logger.error("ParserConfigurationException creating DocumentBuilder : " + pce.getMessage(), (Throwable)pce);
        }
        catch (IOException ioe) {
            logger.error("IOException validating creating DocumentBuilder : " + ioe.getMessage(), (Throwable)ioe);
        }
    }
}

