/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import nl.mpi.arbil.util.BugCatcherManager;
import org.apache.commons.digester.Digester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdiComponentLinkReader {
    private static final Logger logger = LoggerFactory.getLogger(CmdiComponentLinkReader.class);
    private URI parentUri;
    public ArrayList<CmdiResourceLink> cmdiResourceLinkArray = null;
    public ArrayList<ResourceRelation> cmdiResourceRelationArray = null;

    public static void main(String[] args) {
        CmdiComponentLinkReader cmdiComponentLinkReader = new CmdiComponentLinkReader();
        try {
            cmdiComponentLinkReader.readLinks(new URI("http://www.clarin.eu/cmd/example/example-md-instance.cmdi"));
        }
        catch (URISyntaxException exception) {
            System.err.println(exception.getMessage());
        }
    }

    public CmdiResourceLink getResourceLink(String resourceId) {
        for (CmdiResourceLink cmdiResourceLink : this.cmdiResourceLinkArray) {
            if (!cmdiResourceLink.resourceProxyId.equals(resourceId)) continue;
            return cmdiResourceLink;
        }
        return null;
    }

    public String getProxyId(String resourceRef) {
        for (CmdiResourceLink resourceLink : this.cmdiResourceLinkArray) {
            try {
                if (!resourceLink.resourceRef.equals(resourceRef) && !resourceLink.getResolvedLinkUri().toString().equals(resourceRef) && (resourceLink.localUri == null || !resourceRef.equals(resourceLink.getLocalUri().toString()))) continue;
                return resourceLink.resourceProxyId;
            }
            catch (URISyntaxException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
        return null;
    }

    public ArrayList<CmdiResourceLink> readLinks(URI targetCmdiNode) {
        this.parentUri = targetCmdiNode;
        try {
            Digester digester = new Digester();
            digester.push((Object)this);
            digester.setNamespaceAware(false);
            digester.addCallMethod("CMD/Resources/ResourceProxyList/ResourceProxy", "addResourceProxy", 4);
            digester.addCallParam("CMD/Resources/ResourceProxyList/ResourceProxy", 0, "id");
            digester.addCallParam("CMD/Resources/ResourceProxyList/ResourceProxy/ResourceType", 1);
            digester.addCallParam("CMD/Resources/ResourceProxyList/ResourceProxy/ResourceRef", 2);
            digester.addCallParam("CMD/Resources/ResourceProxyList/ResourceProxy/ResourceRef", 3, "lcl:localURI");
            digester.addCallMethod("CMD/Resources/ResourceRelationList/ResourceRelation", "addResourceRelation", 3);
            digester.addCallParam("CMD/Resources/ResourceRelationList/ResourceRelation/RelationType", 0);
            digester.addCallParam("CMD/Resources/ResourceRelationList/ResourceRelation/Res1", 1, "ref");
            digester.addCallParam("CMD/Resources/ResourceRelationList/ResourceRelation/Res2", 2, "ref");
            this.cmdiResourceLinkArray = new ArrayList();
            this.cmdiResourceRelationArray = new ArrayList();
            URLConnection uRLConnection = targetCmdiNode.toURL().openConnection();
            int maxRedirects = 5;
            while (maxRedirects > 0) {
                --maxRedirects;
                if (!(uRLConnection instanceof HttpURLConnection)) continue;
                HttpURLConnection httpConnection = (HttpURLConnection)uRLConnection;
                httpConnection.setInstanceFollowRedirects(true);
                int stat = httpConnection.getResponseCode();
                if (stat < 300 || stat > 307 || stat == 306 || stat == 304) break;
                try {
                    String locationField = uRLConnection.getHeaderField("Location");
                    if (locationField == null) continue;
                    URI redirectedUri = new URI(locationField);
                    uRLConnection = redirectedUri.toURL().openConnection();
                    this.parentUri = redirectedUri;
                }
                catch (IOException exception) {
                    logger.debug("get document 303 check on URL {} failed", (Object)exception.getMessage());
                }
                catch (URISyntaxException exception) {
                    logger.debug("get document 303 check on URL {} failed", (Object)exception.getMessage());
                }
            }
            InputStream inputStream = uRLConnection.getInputStream();
            digester.parse(inputStream);
        }
        catch (IOException e) {
            logger.debug("failed to read cmdi links", (Throwable)e);
        }
        catch (SAXException e) {
            logger.debug("failed to read cmdi links", (Throwable)e);
        }
        return this.cmdiResourceLinkArray;
    }

    public void addResourceProxy(String resourceProxyId, String resourceType, String resourceRef, String localUri) {
        CmdiResourceLink cmdiProfile = new CmdiResourceLink(this.parentUri, resourceProxyId, resourceType, resourceRef, localUri);
        this.cmdiResourceLinkArray.add(cmdiProfile);
    }

    public void addResourceRelation(String RelationType, String Res1, String Res2) {
        ResourceRelation resourceRelation = new ResourceRelation(RelationType, Res1, Res2);
        this.cmdiResourceRelationArray.add(resourceRelation);
    }

    public static class ResourceRelation {
        public final String relationType;
        public final String res1;
        public final String res2;

        public ResourceRelation(String type, String resource1, String resource2) {
            this.relationType = type;
            this.res1 = resource1;
            this.res2 = resource2;
        }
    }

    public static final class CmdiResourceLink {
        public final String resourceProxyId;
        public final String resourceType;
        public final String resourceRef;
        public final String localUri;
        private final URI parentUri;
        private int referencingNodes;

        public CmdiResourceLink(URI parentUri, String proxyId, String type, String ref, String localUri) {
            this.resourceProxyId = proxyId;
            this.resourceType = type;
            this.resourceRef = ref;
            this.parentUri = parentUri;
            this.localUri = localUri;
        }

        public synchronized void addReferencingNode() {
            ++this.referencingNodes;
        }

        public synchronized void removeReferencingNode() {
            --this.referencingNodes;
        }

        public synchronized int getReferencingNodesCount() {
            return this.referencingNodes;
        }

        public URI getLocalUri() throws URISyntaxException {
            if (this.localUri == null) {
                return null;
            }
            return this.parentUri.resolve(this.localUri);
        }

        public URI getLinkUri() throws URISyntaxException {
            if (this.resourceRef != null && this.resourceRef.length() > 0) {
                return new URI(this.resourceRef);
            }
            throw new URISyntaxException(this.resourceRef, "resourceRef is null or zero length");
        }

        public URI getResolvedLinkUri() throws URISyntaxException {
            if (this.parentUri != null) {
                return this.parentUri.resolve(this.getLinkUri());
            }
            throw new URISyntaxException(this.resourceRef, "resourceRef is null");
        }

        public String toString() {
            return String.format("%s: %s -> [%s]%s", this.resourceProxyId, this.parentUri, this.resourceType, this.resourceRef);
        }
    }
}

