/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.mpi.arbil.data.ArbilVocabularyFilter;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.data.DocumentationLanguages;
import nl.mpi.arbil.data.IMDIVocabularies;
import nl.mpi.arbil.userstorage.SessionStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImdiDocumentationLanguages
extends DocumentationLanguages
implements ArbilVocabularyFilter {
    private SessionStorage sessionStorage;
    private static final String IMDI_LANGUAGE_VOCABULARY_URL_KEY = "LanguageVocabularyUrl";
    private static final String SELECTED_LANGUAGES_KEY = "selectedLanguages";
    private static final String OLD_MPI_LANGUAGE_VOCABULARY_URL = "http://www.mpi.nl/IMDI/Schema/ISO639-2Languages.xml";
    private static final String MPI_LANGUAGE_VOCABULARY_URL = "http://www.mpi.nl/IMDI/Schema/MPI-Languages.xml";
    private static String imdiLanguageVocabularyUrl = null;

    public synchronized String getLanguageVocabularyUrlForImdi() {
        if (imdiLanguageVocabularyUrl == null && ((imdiLanguageVocabularyUrl = this.sessionStorage.loadString(IMDI_LANGUAGE_VOCABULARY_URL_KEY)) == null || imdiLanguageVocabularyUrl.equals(OLD_MPI_LANGUAGE_VOCABULARY_URL))) {
            imdiLanguageVocabularyUrl = MPI_LANGUAGE_VOCABULARY_URL;
            this.sessionStorage.saveString(IMDI_LANGUAGE_VOCABULARY_URL_KEY, imdiLanguageVocabularyUrl);
        }
        return imdiLanguageVocabularyUrl;
    }

    public ImdiDocumentationLanguages(SessionStorage sessionStorage) {
        super(SELECTED_LANGUAGES_KEY, sessionStorage);
        this.sessionStorage = sessionStorage;
    }

    @Override
    public synchronized List<ArbilVocabularyItem> getAllLanguages() {
        return IMDIVocabularies.getSingleInstance().getVocabulary(null, this.getLanguageVocabularyUrlForImdi()).getVocabularyItemsUnfiltered();
    }

    @Override
    public List<ArbilVocabularyItem> getSortedLanguageListSubset() {
        List<ArbilVocabularyItem> languages = this.getLanguageListSubset(this.getAllLanguages());
        Collections.sort(languages);
        return languages;
    }

    @Override
    public List<ArbilVocabularyItem> filterVocabularyItems(List<ArbilVocabularyItem> items) {
        ArrayList<ArbilVocabularyItem> vocabClone = new ArrayList<ArbilVocabularyItem>(items);
        vocabClone.retainAll(this.getSortedLanguageListSubset());
        return vocabClone;
    }
}

