/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Transform;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMTransform
extends Transform {
    public List preprocess(List sources) throws XPathException {
        try {
            ArrayList<DocumentWrapper> domSources = new ArrayList<DocumentWrapper>(sources.size());
            for (Object source : sources) {
                StreamSource src = (StreamSource)source;
                InputSource ins = new InputSource(src.getSystemId());
                System.setProperty("javax.xml.parser.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(ins);
                DocumentWrapper dom = new DocumentWrapper((Node)doc, src.getSystemId(), this.getConfiguration());
                domSources.add(dom);
            }
            return domSources;
        }
        catch (ParserConfigurationException e) {
            throw new XPathException(e);
        }
        catch (SAXException e) {
            throw new XPathException(e);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static void main(String[] args) {
        new DOMTransform().doTransform(args, "DOMTransform");
    }
}

