/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.DumpHandlesCallback;
import net.handle.hdllib.DumpHandlesRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.SignedInputStream;
import net.handle.hdllib.SignedOutputStream;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.TransactionQueueInterface;

public class DumpHandlesResponse
extends AbstractResponse {
    public DumpHandlesRequest req = null;
    private HandleStorage storage = null;
    private TransactionQueueInterface queue = null;
    private PrivateKey sourcePrivKey = null;
    private static final byte END_TRANSMISSION_RECORD = 0;
    private static final byte HANDLE_RECORD = 1;
    private static final byte NAMING_AUTH_RECORD = 2;

    public DumpHandlesResponse(DumpHandlesRequest req, HandleStorage storage, TransactionQueueInterface queue, PrivateKey sourcePrivKey) throws HandleException {
        super(req, 1);
        this.req = req;
        this.storage = storage;
        this.queue = queue;
        this.streaming = true;
        this.sourcePrivKey = sourcePrivKey;
    }

    public DumpHandlesResponse() {
        super(1001, 1);
        this.streaming = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processStreamedPart(DumpHandlesCallback callback, PublicKey sourceKey) throws HandleException {
        block21: {
            if (this.stream == null) {
                throw new HandleException(1, "Response stream not found");
            }
            threadPriority = Thread.currentThread().getPriority();
            try {
                try {
                    sin = new SignedInputStream(sourceKey, this.stream);
                    in = new DataInputStream(sin);
                    dataVersion = in.readInt();
                    if (!sin.verifyBlock()) {
                        throw new HandleException(10, "Invalid signature on replication stream");
                    }
                    while (true) {
                        if ((recordType = in.readByte()) == 0) {
                            date = in.readLong();
                            txnId = in.readLong();
                            if (!sin.verifyBlock()) {
                                throw new HandleException(10, "Invalid signature on replication stream");
                            }
                            callback.finishProcessing(date, txnId);
                            var13_15 = null;
                            if (this.stream == null) break block21;
                            break;
                        }
                        if (recordType == 1) {
                            handleBytes = new byte[in.readInt()];
                            in.readFully(handleBytes);
                            values = new HandleValue[in.readInt()];
                            for (i = 0; i < values.length; ++i) {
                                valueBytes = new byte[in.readInt()];
                                in.readFully(valueBytes);
                                values[i] = new HandleValue();
                                Encoder.decodeHandleValue(valueBytes, 0, values[i]);
                            }
                            if (!sin.verifyBlock()) {
                                throw new HandleException(10, "Invalid signature on replication stream");
                            }
                            callback.addHandle(handleBytes, values);
                        } else {
                            if (recordType != 2) throw new HandleException(0, "Unknown transmission record type: " + recordType);
                            naHandle = new byte[in.readInt()];
                            in.readFully(naHandle);
                            if (!sin.verifyBlock()) {
                                throw new HandleException(10, "Invalid signature on replication stream");
                            }
                            callback.addNamingAuthority(naHandle);
                        }
                        Thread.yield();
                    }
                }
                catch (Exception e) {
                    System.err.println(">>> Exception receiving dump: " + e);
                    e.printStackTrace(System.err);
                    if (e instanceof HandleException == false) throw new HandleException(1, "Exception receiving handle dump: " + e);
                    throw (HandleException)e;
                }
            }
            catch (Throwable var12_19) {
                var13_16 = null;
                if (this.stream != null) {
                    try {
                        this.stream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    Thread.currentThread().setPriority(threadPriority);
                    throw var12_19;
                }
                catch (Exception e) {
                    System.err.println("Unable to upgrade thread priority: " + e);
                    throw var12_19;
                }
            }
            ** try [egrp 2[TRYBLOCK] [4 : 443->453)] { 
lbl68:
            // 1 sources

            this.stream.close();
            break block21;
lbl70:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        ** try [egrp 3[TRYBLOCK] [5 : 455->465)] { 
lbl74:
        // 1 sources

        Thread.currentThread().setPriority(threadPriority);
        return;
lbl76:
        // 1 sources

        catch (Exception e) {
            System.err.println("Unable to upgrade thread priority: " + e);
        }
    }

    /*
     * Loose catch block
     */
    public void streamResponse(OutputStream outStream) throws HandleException {
        block7: {
            int threadPriority = Thread.currentThread().getPriority();
            SignedOutputStream sout = new SignedOutputStream(this.sourcePrivKey, outStream);
            DataOutputStream out = new DataOutputStream(sout);
            out.writeInt(1);
            sout.signBlock();
            this.storage.scanHandles(new HdlForwarder(out, sout, false));
            this.storage.scanNAs(new HdlForwarder(out, sout, true));
            out.writeByte(0);
            out.writeLong(System.currentTimeMillis());
            out.writeLong(this.queue.getLastTxnId());
            sout.signBlock();
            out.flush();
            Thread.yield();
            Object var6_6 = null;
            try {
                Thread.currentThread().setPriority(threadPriority);
            }
            catch (Exception e) {
                System.err.println("Unable to upgrade thread priority: " + e);
            }
            break block7;
            {
                catch (Exception e) {
                    throw new HandleException(1, "Exception sending transactions: " + e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    Thread.currentThread().setPriority(threadPriority);
                }
                catch (Exception e) {
                    System.err.println("Unable to upgrade thread priority: " + e);
                }
                throw throwable;
            }
        }
    }

    private class HdlForwarder
    implements ScanCallback {
        private boolean scanningNAs;
        private DataOutputStream out;
        private SignedOutputStream sout;

        public HdlForwarder(DataOutputStream out, SignedOutputStream sout, boolean scanningNAs) {
            this.out = out;
            this.sout = sout;
            this.scanningNAs = scanningNAs;
        }

        public void scanHandle(byte[] handle) throws HandleException {
            if (!this.scanningNAs && DumpHandlesResponse.this.req.serverNum != SiteInfo.determineServerNum(handle, DumpHandlesResponse.this.req.rcvrHashType, DumpHandlesResponse.this.req.numServers)) {
                return;
            }
            try {
                if (this.scanningNAs) {
                    this.out.write(2);
                    this.out.writeInt(handle.length);
                    this.out.write(handle);
                } else {
                    this.out.write(1);
                    byte[][] values = DumpHandlesResponse.this.storage.getRawHandleValues(handle, null, null);
                    this.out.writeInt(handle.length);
                    this.out.write(handle);
                    this.out.writeInt(values.length);
                    for (int i = 0; i < values.length; ++i) {
                        this.out.writeInt(values[i].length);
                        this.out.write(values[i]);
                    }
                }
                this.sout.signBlock();
            }
            catch (Exception e) {
                if (e instanceof HandleException) {
                    throw (HandleException)e;
                }
                throw new HandleException(1, String.valueOf(e));
            }
        }
    }
}

