/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;
import nl.mpi.corpusstructure.AccessInfo;
import nl.mpi.corpusstructure.ArchiveAccessContext;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.util.DBConnection;
import nl.mpi.util.OurURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveObjectsDBImpl
implements ArchiveObjectsDB {
    private static Logger logger = LoggerFactory.getLogger(ArchiveObjectsDBImpl.class);
    protected static final Hashtable rootsHash = new Hashtable();
    private static String _dbname = null;
    protected static final String adminTableName = "IMDIADMIN";
    private static String _ARCHIVEOBJECTS = "ARCHIVEOBJECTS";
    protected static final Object staticSyncFlag = new Object();
    protected boolean status = false;
    protected DBConnection db = null;
    private static int _instance = 0;
    private final Object getByValueSync = new Object();
    private PreparedStatement getURLFromArchiveObjectsSTM = null;
    private PreparedStatement getURLFromArchiveObjectsForPIDSTM = null;
    private PreparedStatement getPIDFromArchiveObjectsSTM = null;
    private PreparedStatement getTimestampFromArchiveObjectsSTM = null;
    private PreparedStatement getFileTimeFromArchiveObjectsSTM = null;
    private PreparedStatement getAccessInfoFromArchiveObjectsSTM = null;
    private PreparedStatement getIdFromArchiveObjectsSTMurl = null;
    private PreparedStatement getIdFromArchiveObjectsSTMpid = null;
    private PreparedStatement getIdsFromArchiveObjectsChecksumSTM = null;
    private PreparedStatement getSizeFromArchiveObjectsSTM = null;
    private PreparedStatement getChecksumFromArchiveObjectsSTM = null;
    private PreparedStatement getOnSiteFromArchiveObjectsSTM = null;
    private static final String PROPERTYFILENAME = "CorpusStructure.props";

    protected ArchiveObjectsDBImpl(Exception e) {
    }

    public ArchiveObjectsDBImpl(String dbname) {
        this(dbname, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveObjectsDBImpl(String mydbname, String user, String passwd) {
        Object object = staticSyncFlag;
        synchronized (object) {
            this.db = new DBConnection(mydbname, user, passwd, "ArchiveObjectsDBImpl:constructor");
            if (this.db == null) {
                logger.error("constructor: NULL DB connection!");
                this.status = false;
                return;
            }
            if (!this.db.getStatus()) {
                logger.error("constructor: ERROR creating DB connection: " + this.db.getMessage());
                this.status = false;
                this.db = null;
                return;
            }
            this.status = true;
            ArchiveObjectsDBImpl.incrementInstance();
            ArchiveObjectsDBImpl.updateDbName(mydbname);
            try {
                this.initArchiveAccessRoots();
            }
            catch (MalformedURLException murle) {
                this.close();
                throw new RuntimeException("Cannot init AccessRoots: " + murle);
            }
            this.initPreparedStatements();
        }
    }

    protected static synchronized void updateDbName(String myDbName) {
        if (!myDbName.equals(ArchiveObjectsDBImpl.getDbName()) && ArchiveObjectsDBImpl.getDbName() != null) {
            logger.warn("Database name changed from: '" + ArchiveObjectsDBImpl.getDbName() + "' to: '" + myDbName + "'");
        }
        _dbname = myDbName;
    }

    protected static synchronized String getDbName() {
        return _dbname;
    }

    protected static String getARCHIVEOBJECTS() {
        return _ARCHIVEOBJECTS;
    }

    protected static void setARCHIVEOBJECTS(String tableName) {
        _ARCHIVEOBJECTS = tableName;
    }

    protected static synchronized void incrementInstance() {
        ++_instance;
    }

    protected static synchronized int getInstance() {
        return _instance;
    }

    protected void initArchiveAccessRoots() throws MalformedURLException {
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(ArchiveObjectsDBImpl.getDbName());
        if (aac != null) {
            return;
        }
        aac = new ArchiveAccessContext();
        int[] contexts = new int[]{1, 2, 3, 4, 5, 6};
        int j = 0;
        for (int i = 0; i < contexts.length; ++i) {
            String defValue = this.getAdminKey(ArchiveAccessContext.getPropName(contexts[i]));
            if (defValue != null && !defValue.equals("")) {
                try {
                    aac.updateRoot(contexts[i], defValue);
                    continue;
                }
                catch (MalformedURLException murle) {
                    logger.error("initArchiveAccessRoots: Error in ArchiveAccessContext roots: " + murle, (Throwable)murle);
                    throw murle;
                }
            }
            ++j;
            logger.warn("initArchiveAccessRoots: No root setup in DB yet, starting with dummy default for " + ArchiveAccessContext.getPropName(i));
            try {
                aac.updateRoot(contexts[i], null);
                continue;
            }
            catch (MalformedURLException murle) {
                logger.error("initArchiveAccessRoots: Error in ArchiveAccessContext roots: " + murle, (Throwable)murle);
                throw murle;
            }
        }
        Properties csProps = new Properties(System.getProperties());
        String propertyfile = csProps.getProperty("Properties", PROPERTYFILENAME);
        if (aac.loadPropertyFile("ArchiveRoots")) {
            logger.info("initArchiveAccessRoots: loaded ArchiveRoots file");
            j = 0;
        }
        if (aac.loadPropertyFile(propertyfile)) {
            logger.info("initArchiveAccessRoots: loaded " + propertyfile + " file");
            j = 0;
        }
        if (j > 0) {
            logger.error("initArchiveAccessRoots: Dummy default settings active (" + j + " items) and no user ArchiveRoots or properties setup file found!");
        }
        logger.info("Initialised archive access roots: " + aac.getRoot(1) + ", " + aac.getRoot(2) + ", " + aac.getRoot(3));
        logger.info("Initialised Handle System settings: " + aac.getHandleProxy() + ", " + aac.getHandlePrefix());
        logger.info("Initialised archive name: " + aac.getArchiveName());
        rootsHash.put(ArchiveObjectsDBImpl.getDbName(), aac);
    }

    protected synchronized void initPreparedStatements() {
        try {
            this.getURLFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT URL FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?");
            this.getURLFromArchiveObjectsForPIDSTM = this.db.getConnection().prepareStatement("SELECT URL FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE PID = ?");
            this.getPIDFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT PID FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?");
            this.getTimestampFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT CRAWLTIME FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?");
            this.getFileTimeFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT FILETIME FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?");
            this.getAccessInfoFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT (SELECT ACLSTRING FROM accessgroups WHERE MD5 = (SELECT READRIGHTS FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?))" + " AS READRIGHTS, " + "(SELECT ACLSTRING FROM " + "accessgroups" + " WHERE MD5 = " + "(SELECT WRITERIGHTS FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?))" + " AS WRITERIGHTS, " + "ACCESSLEVEL " + "FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?");
            this.getIdFromArchiveObjectsSTMurl = this.db.getConnection().prepareStatement("SELECT NODEID FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE URL = ?");
            this.getIdFromArchiveObjectsSTMpid = this.db.getConnection().prepareStatement("SELECT NODEID FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE PID = ?");
            this.getIdsFromArchiveObjectsChecksumSTM = this.db.getConnection().prepareStatement("SELECT NODEID FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE CHECKSUM = ?");
            this.getSizeFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT SIZE FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?");
            this.getChecksumFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT CHECKSUM FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?");
            this.getOnSiteFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT ONSITE FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?");
        }
        catch (SQLException sqle) {
            logger.error("initPreparedStatements: ", (Throwable)sqle);
            while ((sqle = sqle.getNextException()) != null) {
                logger.error("initPreparedStatements: " + sqle);
            }
        }
    }

    protected synchronized void closePreparedStatements() {
        try {
            if (this.getURLFromArchiveObjectsSTM != null) {
                this.getURLFromArchiveObjectsSTM.close();
            }
            if (this.getURLFromArchiveObjectsForPIDSTM != null) {
                this.getURLFromArchiveObjectsForPIDSTM.close();
            }
            if (this.getPIDFromArchiveObjectsSTM != null) {
                this.getPIDFromArchiveObjectsSTM.close();
            }
            if (this.getTimestampFromArchiveObjectsSTM != null) {
                this.getTimestampFromArchiveObjectsSTM.close();
            }
            if (this.getFileTimeFromArchiveObjectsSTM != null) {
                this.getFileTimeFromArchiveObjectsSTM.close();
            }
            if (this.getAccessInfoFromArchiveObjectsSTM != null) {
                this.getAccessInfoFromArchiveObjectsSTM.close();
            }
            if (this.getIdFromArchiveObjectsSTMurl != null) {
                this.getIdFromArchiveObjectsSTMurl.close();
            }
            if (this.getIdFromArchiveObjectsSTMpid != null) {
                this.getIdFromArchiveObjectsSTMpid.close();
            }
            if (this.getIdsFromArchiveObjectsChecksumSTM != null) {
                this.getIdsFromArchiveObjectsChecksumSTM.close();
            }
            if (this.getSizeFromArchiveObjectsSTM != null) {
                this.getSizeFromArchiveObjectsSTM.close();
            }
            if (this.getChecksumFromArchiveObjectsSTM != null) {
                this.getChecksumFromArchiveObjectsSTM.close();
            }
            if (this.getOnSiteFromArchiveObjectsSTM != null) {
                this.getOnSiteFromArchiveObjectsSTM.close();
            }
        }
        catch (SQLException sqle) {
            logger.error("closePreparedStatements: ", (Throwable)sqle);
        }
        this.getURLFromArchiveObjectsSTM = null;
        this.getURLFromArchiveObjectsForPIDSTM = null;
        this.getPIDFromArchiveObjectsSTM = null;
        this.getTimestampFromArchiveObjectsSTM = null;
        this.getFileTimeFromArchiveObjectsSTM = null;
        this.getAccessInfoFromArchiveObjectsSTM = null;
        this.getIdFromArchiveObjectsSTMurl = null;
        this.getIdFromArchiveObjectsSTMpid = null;
        this.getIdsFromArchiveObjectsChecksumSTM = null;
        this.getSizeFromArchiveObjectsSTM = null;
        this.getChecksumFromArchiveObjectsSTM = null;
        this.getOnSiteFromArchiveObjectsSTM = null;
    }

    @Override
    public synchronized void close() {
        this.closePreparedStatements();
        if (this.db != null) {
            this.db.close();
        }
        this.db = null;
        this.status = false;
    }

    @Override
    public synchronized boolean getStatus() {
        if (!this.status) {
            return this.status;
        }
        if (!this.db.getStatus()) {
            this.status = false;
        }
        return this.status;
    }

    public static void setLogger(Logger l) {
        logger = l;
        NodeIdUtils.setLogger(l);
    }

    public String getAdminKey(String name) {
        return this.getMultiAdminKey(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiAdminKey(String name, boolean multi) {
        PreparedStatement ps = null;
        String answer = null;
        ResultSet rs = null;
        try {
            Object o;
            ps = this.db.getConnection().prepareStatement("SELECT Value FROM IMDIADMIN WHERE NAME = ?");
            ps.clearParameters();
            ps.setString(1, name);
            rs = ps.executeQuery();
            while (rs.next()) {
                answer = answer == null ? "" : answer + ";";
                o = rs.getObject(1);
                if (o != null) {
                    answer = answer + o.toString();
                    if (multi) continue;
                    String string = answer;
                    return string;
                }
                logger.error("getAdminKey: " + name + " error Object is null");
            }
            o = answer;
            return o;
        }
        catch (SQLException sqle) {
            logger.warn("getAdminKey: cannot read key '" + name + "' - admin table not yet there? SQLException: " + sqle.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error("getAdminKey: Failed to close prepared statement: " + e);
                }
            }
            ps = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getAdminKey: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
    }

    @Override
    public void setArchiveRoots(ArchiveAccessContext aac) {
        if (ArchiveObjectsDBImpl.getDbName() == null) {
            logger.error("Cannot setArchiveRoots for null dbname");
            return;
        }
        rootsHash.put(ArchiveObjectsDBImpl.getDbName(), aac);
        logger.info("setArchiveRoots for database " + ArchiveObjectsDBImpl.getDbName());
    }

    @Override
    public ArchiveAccessContext getArchiveRoots() {
        if (ArchiveObjectsDBImpl.getDbName() == null) {
            logger.error("Cannot getArchiveRoots for null dbname");
            return null;
        }
        return (ArchiveAccessContext)rootsHash.get(ArchiveObjectsDBImpl.getDbName());
    }

    @Override
    public boolean hasReadAccess(String nodeId, String uid) throws UnknownNodeException {
        AccessInfo ai = this.getObjectAccessInfo(nodeId);
        if (ai == null) {
            return false;
        }
        return ai.hasReadAccess(uid);
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public OurURL getObjectURL(String id, int context) throws UnknownNodeException {
        String urlstr = null;
        URI objectURI = this.getObjectURI(id);
        if (objectURI == null) {
            return null;
        }
        try {
            ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(ArchiveObjectsDBImpl.getDbName());
            urlstr = aac.toClassicURL(objectURI.toString(), false, null).toString();
            URI result = aac.uriInContext(urlstr, context);
            if (result == null) {
                logger.error("getObjectURL: urlInContext error, context: " + context);
                return null;
            }
            return new OurURL(result.toString().replace("%20", " "));
        }
        catch (MalformedURLException mue) {
            logger.error("getObjectURL: error creating URL from " + objectURI, (Throwable)mue);
        }
        catch (URISyntaxException use) {
            logger.error("getObjectURL: error creating URI from " + urlstr, (Throwable)use);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OurURL getObjectURLForPid(String pid) throws UnknownNodeException {
        String methodSignature = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (pid == null) {
            throw new IllegalArgumentException("PID has to be specified. Null is not allowed.");
        }
        if (!this.statusLog(methodSignature)) {
            return null;
        }
        ResultSet rs = null;
        String urlstr = null;
        try {
            PreparedStatement preparedStatement = this.getURLFromArchiveObjectsForPIDSTM;
            synchronized (preparedStatement) {
                this.getURLFromArchiveObjectsForPIDSTM.clearParameters();
                this.getURLFromArchiveObjectsForPIDSTM.setString(1, pid);
                rs = this.getURLFromArchiveObjectsForPIDSTM.executeQuery();
                if (rs.next()) {
                    urlstr = rs.getString("URL");
                    if (rs.next()) {
                        throw new IllegalStateException("More than one URL found for the supplied PID.");
                    }
                } else {
                    this.throwUnknownObjectException(methodSignature, "", pid);
                }
            }
        }
        catch (SQLException e) {
            logger.error(methodSignature + ": SQL exception: pid=" + pid + " " + e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getObjectURLforPid: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
        if (urlstr != null) {
            try {
                return new OurURL(urlstr);
            }
            catch (MalformedURLException e) {
                logger.error(methodSignature + ": Failed to create OurURL object from url: " + urlstr, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized URI getObjectURI(String id) throws UnknownNodeException {
        if (!this.statusLog("getObjectURI")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(id)) {
            this.throwUnknownObjectException("getObjectURI", "", id);
        }
        ResultSet rs = null;
        String urlstr = "";
        try {
            PreparedStatement preparedStatement = this.getURLFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getURLFromArchiveObjectsSTM.clearParameters();
                this.getURLFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                rs = this.getURLFromArchiveObjectsSTM.executeQuery();
                while (rs.next()) {
                    urlstr = rs.getString("URL");
                    if (!rs.isLast()) {
                        logger.error("getObjectURI: ERROR more than one entry for object: " + id);
                    }
                    try {
                        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(ArchiveObjectsDBImpl.getDbName());
                        URI uRI = aac.stringToURI(urlstr);
                        return uRI;
                    }
                    catch (URISyntaxException use) {
                        logger.error("getObjectURI: DB contained invalid URI: " + urlstr);
                    }
                }
                this.throwUnknownObjectException("getObjectURI", "", id);
            }
        }
        catch (SQLException e) {
            logger.error("getObjectURI: SQL exception: nodeid=" + NodeIdUtils.TOINT(id) + " " + e);
            return null;
        }
        return null;
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getObjectURI: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
    }

    @Override
    public synchronized String getObjectId(OurURL urlin, int context) {
        if (!this.statusLog("getObjectId")) {
            return null;
        }
        if (urlin == null) {
            return null;
        }
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(ArchiveObjectsDBImpl.getDbName());
        URI uri = null;
        try {
            uri = aac.uriToTableContext(aac.stringToURI(urlin.toString()), context);
        }
        catch (URISyntaxException use) {
            uri = null;
        }
        if (uri == null) {
            logger.warn("getObjectId: urlToTableContext(" + urlin + ", " + context + ") failed");
            return null;
        }
        return this.getObjectId(uri);
    }

    @Override
    public synchronized String getObjectId(OurURL url) {
        if (!this.statusLog("getObjectId")) {
            return null;
        }
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(ArchiveObjectsDBImpl.getDbName());
        int context = aac.getAccessContextFromURI(url.toString());
        if (context == -1) {
            logger.error("getObjectId: Could not guess access context for URL: " + url);
            context = 0;
        }
        return this.getObjectId(url, context);
    }

    @Override
    public synchronized String getObjectId(URI uri) {
        if (uri == null || !uri.isAbsolute()) {
            logger.warn("getObjectId: Invalid URI, must specify schema/protocol: " + uri);
            return null;
        }
        if (!this.statusLog("getObjectId")) {
            return null;
        }
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(ArchiveObjectsDBImpl.getDbName());
        uri = aac.inTableContext(uri);
        return this.getObjectIDByValue("URL", uri.toString().replace("%20", " "));
    }

    @Override
    public synchronized String getObjectForPID(String pid) {
        return this.getObjectIDByValue("PID", "hdl:" + pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized String getObjectIDByValue(String name, String value) {
        block30: {
            block28: {
                block29: {
                    if (!this.statusLog("getObjectIDByValue")) {
                        return null;
                    }
                    rs = null;
                    var4_4 = this.getByValueSync;
                    // MONITORENTER : var4_4
                    getByValue = null;
                    if ("URL".equals(name)) {
                        getByValue = this.getIdFromArchiveObjectsSTMurl;
                    } else if ("PID".equals(name)) {
                        getByValue = this.getIdFromArchiveObjectsSTMpid;
                    } else {
                        ArchiveObjectsDBImpl.logger.error("You cannot getObjectIDByValue for name: " + name);
                    }
                    if (getByValue == null) {
                        ArchiveObjectsDBImpl.logger.error("getObjectIDByValue: Prepared statements not yet set!");
                        var6_9 = null;
                        // MONITOREXIT : var4_4
                        return var6_9;
                    }
                    ** try [egrp 3[TRYBLOCK] [8 : 156->254)] { 
lbl-1000:
                    // 1 sources

                    {
                        getByValue.clearParameters();
                        getByValue.setString(1, value);
                        rs = getByValue.executeQuery();
                        if (!rs.next()) break block28;
                        id = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                        if (!rs.isLast()) {
                            ArchiveObjectsDBImpl.logger.error("getObjectIDByValue: ERROR more than one id for name / value: " + name + " / " + value);
                        }
                        var7_12 = id;
                        // MONITOREXIT : var4_4
                        if (rs == null) break block29;
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        ArchiveObjectsDBImpl.logger.error("getObjectIDByValue: Failed to close result set: " + e);
                    }
                }
                rs = null;
                return var7_12;
            }
            // MONITOREXIT : var4_4
            ArchiveObjectsDBImpl.logger.debug("## getObjectIDByValue: NONE for name / value: " + name + " / " + value);
            var4_4 = null;
            if (rs == null) break block30;
            try {
                rs.close();
            }
            catch (SQLException e) {
                ArchiveObjectsDBImpl.logger.error("getObjectIDByValue: Failed to close result set: " + e);
            }
        }
        rs = null;
        return var4_4;
lbl53:
        // 3 sources

        catch (SQLException e) {
            ArchiveObjectsDBImpl.logger.error("getObjectIDByValue: SQL exception: " + e);
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    ArchiveObjectsDBImpl.logger.error("getObjectIDByValue: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getObjectsByChecksum(String checksum) {
        if (checksum == null || !checksum.matches("^[0-9a-f]*$")) {
            logger.warn("getObjectsByChecksum: Invalid checksum, must be lower case hex: " + checksum);
            return null;
        }
        if (!this.statusLog("getObjectsByChecksum")) {
            return null;
        }
        ResultSet rs = null;
        TreeSet<String> items = new TreeSet<String>(new NodeIdComparator());
        try {
            PreparedStatement preparedStatement = this.getIdsFromArchiveObjectsChecksumSTM;
            synchronized (preparedStatement) {
                this.getIdsFromArchiveObjectsChecksumSTM.clearParameters();
                this.getIdsFromArchiveObjectsChecksumSTM.setString(1, checksum);
                rs = this.getIdsFromArchiveObjectsChecksumSTM.executeQuery();
                while (rs.next()) {
                    String id = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                    if (!NodeIdUtils.isNodeId(id)) {
                        logger.warn("Could not put ID into Node ID syntax, skipped: " + rs.getInt("NODEID"));
                        continue;
                    }
                    items.add(id);
                }
            }
        }
        catch (SQLException e) {
            logger.error("getObjectsByChecksum: SQL exception: " + e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getObjectsByChecksum: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
        return items.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getObjectPID(String nodeId) throws UnknownNodeException {
        if (!this.statusLog("getObjectPID")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            this.throwUnknownObjectException("getObjectPID", "", nodeId);
        }
        ResultSet rs = null;
        String pid = null;
        try {
            PreparedStatement preparedStatement = this.getPIDFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getPIDFromArchiveObjectsSTM.clearParameters();
                this.getPIDFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                rs = this.getPIDFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    pid = rs.getString("PID");
                }
                if (rs.next()) {
                    logger.warn("getObjectPID: Multiple rows returned for nodeid: " + nodeId);
                }
            }
        }
        catch (SQLException e) {
            logger.error("getObjectPID: SQL exception: " + e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getObjectPID: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Timestamp getObjectTimestamp(String id) throws UnknownNodeException {
        if (!this.statusLog("getObjectTimestamp")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(id)) {
            this.throwUnknownObjectException("getObjectTimestamp", "", id);
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.getTimestampFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getTimestampFromArchiveObjectsSTM.clearParameters();
                this.getTimestampFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                rs = this.getTimestampFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    Timestamp timestamp = rs.getTimestamp("CRAWLTIME");
                    if (!rs.isLast()) {
                        logger.error("getTimestamp: ERROR more than one entry for object: " + id);
                    }
                    Timestamp timestamp2 = timestamp;
                    return timestamp2;
                }
            }
            this.throwUnknownObjectException("getObjectTimeStamp", "", id);
            return null;
        }
        catch (SQLException e) {
            logger.error("getObjectTimeStamp", (Throwable)e);
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getObjectTimestamp: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Timestamp getObjectFileTime(String id) throws UnknownNodeException {
        if (!this.statusLog("getObjectFileTime")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(id)) {
            this.throwUnknownObjectException("getObjectFileTime", "", id);
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.getFileTimeFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getFileTimeFromArchiveObjectsSTM.clearParameters();
                this.getFileTimeFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                rs = this.getFileTimeFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    Timestamp timestamp = rs.getTimestamp("FILETIME");
                    if (!rs.isLast()) {
                        logger.error("getObjectFileTime: ERROR more than one entry for object: " + id);
                    }
                    Timestamp timestamp2 = timestamp;
                    return timestamp2;
                }
            }
            this.throwUnknownObjectException("getObjectFileTime", "", id);
            return null;
        }
        catch (SQLException e) {
            logger.error("getObjectFileTime", (Throwable)e);
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getObjectFileTime: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized AccessInfo getObjectAccessInfo(String id) throws UnknownNodeException {
        if (!this.statusLog("getObjectAccessInfo")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(id)) {
            this.throwUnknownObjectException("getObjectAccessInfo", "", id);
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.getAccessInfoFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getAccessInfoFromArchiveObjectsSTM.clearParameters();
                this.getAccessInfoFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                this.getAccessInfoFromArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(id));
                this.getAccessInfoFromArchiveObjectsSTM.setInt(3, NodeIdUtils.TOINT(id));
                rs = this.getAccessInfoFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    AccessInfo ai = AccessInfo.createFromDatabaseInfo(rs.getString("READRIGHTS"), rs.getString("WRITERIGHTS"), rs.getInt("ACCESSLEVEL"));
                    if (!rs.isLast()) {
                        logger.error("getAccessInfo: ERROR more than one entry for object: " + id);
                    }
                    AccessInfo accessInfo = ai;
                    return accessInfo;
                }
            }
            this.throwUnknownObjectException("getObjectAccessInfo", "", id);
            return null;
        }
        catch (SQLException e) {
            logger.error("getObjectAccessInfo: ", (Throwable)e);
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getObjectAccessInfo: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized long getObjectSize(String nodeId) throws UnknownNodeException {
        if (!this.statusLog("getObjectSize")) {
            return -1L;
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            this.throwUnknownObjectException("getObjectSize", "", nodeId);
        }
        ResultSet rs = null;
        long size = 0L;
        try {
            PreparedStatement preparedStatement = this.getSizeFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getSizeFromArchiveObjectsSTM.clearParameters();
                this.getSizeFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                rs = this.getSizeFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    size = rs.getLong("SIZE");
                    if (!rs.isLast()) {
                        logger.error("getObjectSize: ERROR more than one entry for object: " + nodeId);
                    }
                    long l = size;
                    return l;
                }
            }
            this.throwUnknownObjectException("getObjectSize: ", "", nodeId);
            return -1L;
        }
        catch (SQLException e) {
            logger.error("getObjectSize: nodeid=" + NodeIdUtils.TOINT(nodeId) + " " + e);
            return -1L;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getObjectSize: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String getObjectChecksum(String nodeId) throws UnknownNodeException {
        if (!this.statusLog("getObjectChecksum")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            this.throwUnknownObjectException("getObjectChecksum", "", nodeId);
        }
        ResultSet rs = null;
        String checksum = null;
        try {
            PreparedStatement preparedStatement = this.getChecksumFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getChecksumFromArchiveObjectsSTM.clearParameters();
                this.getChecksumFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                rs = this.getChecksumFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    checksum = rs.getString("CHECKSUM");
                    if (!rs.isLast()) {
                        logger.error("getObjectChecksum: ERROR more than one entry for object: " + nodeId);
                    }
                    String string = checksum;
                    return string;
                }
            }
            this.throwUnknownObjectException("getObjectChecksum: ", "", nodeId);
            return null;
        }
        catch (SQLException e) {
            logger.error("getObjectChecksum: ", (Throwable)e);
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getObjectChecksum: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
    }

    @Override
    public synchronized boolean isAccessible(String nodeId) throws UnknownNodeException {
        return this.getObjectSize(nodeId) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean isOnSite(String nodeId) throws UnknownNodeException {
        if (!this.statusLog("isOnSite")) {
            return false;
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            this.throwUnknownObjectException("isOnSite", "", nodeId);
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.getOnSiteFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getOnSiteFromArchiveObjectsSTM.clearParameters();
                this.getOnSiteFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                rs = this.getOnSiteFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    boolean onSite = rs.getBoolean("ONSITE");
                    if (!rs.isLast()) {
                        logger.error("isOnSite: ERROR more than one entry for object: " + nodeId);
                    }
                    boolean bl = onSite;
                    return bl;
                }
            }
            this.throwUnknownObjectException("isOnSite: ", "", nodeId);
            return false;
        }
        catch (SQLException sqle) {
            logger.error("isOnSite(" + nodeId + ") : ", (Throwable)sqle);
            return false;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("isOnSite: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getNewArchiveObjectsSince(Timestamp timestamp, boolean onsiteonly, boolean urlformat, boolean usefiletime) {
        if (!this.statusLog("getNewArchiveObjectsSince")) {
            return null;
        }
        String format = urlformat ? "URL" : "NODEID";
        if (timestamp != null && timestamp.getTime() == 0L) {
            timestamp = null;
        }
        TreeSet<String> results = new TreeSet<String>(urlformat ? null : new NodeIdComparator());
        ResultSet rs = null;
        Statement statement = null;
        try {
            String cmd = "SELECT " + format + " FROM " + ArchiveObjectsDBImpl.getARCHIVEOBJECTS();
            if (timestamp != null || onsiteonly) {
                cmd = cmd + " WHERE ";
            }
            if (timestamp != null) {
                cmd = usefiletime ? cmd + "FILETIME" : cmd + "CRAWLTIME";
                cmd = cmd + " > ?";
                if (onsiteonly) {
                    cmd = cmd + " AND ";
                }
            }
            if (onsiteonly) {
                cmd = cmd + "ONSITE";
            }
            logger.info("getNewArchiveObjectsSince: " + cmd + " Timestamp: " + timestamp);
            statement = this.db.getConnection().prepareStatement(cmd);
            if (timestamp != null) {
                statement.setTimestamp(1, timestamp);
            }
            rs = statement.executeQuery();
            while (rs.next()) {
                String res = null;
                res = urlformat ? rs.getString(1) : NodeIdUtils.TONODEID(rs.getInt(1));
                results.add(res);
            }
            String[] stringArray = results.toArray(new String[0]);
            return stringArray;
        }
        catch (SQLException e) {
            logger.error("getNewArchiveObjectsSince: ", (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.error("getNewArchiveObjectsSince: Failed to close statement: " + e);
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("getNewArchiveObjectsSince: Failed to close result set: " + e);
                }
            }
            rs = null;
        }
        return null;
    }

    protected void throwUnknownNodeException(String method, String message, String nodeId) throws UnknownNodeException {
        throw new UnknownNodeException("" + method + ": no node with nodeId " + nodeId + ", " + message);
    }

    protected void throwUnknownObjectException(String method, String message, String id) throws UnknownNodeException {
        throw new UnknownNodeException("" + method + ": no object with Id " + id + ", " + message);
    }

    protected boolean statusLog(String method) {
        boolean okay = this.getStatus();
        if (!okay) {
            logger.error("ArchiveObjectsDBImpl." + method + ": DB / object status is false");
        }
        return okay;
    }

    protected static class NodeIdComparator
    implements Comparator,
    Serializable {
        protected NodeIdComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                int n1 = NodeIdUtils.TOINT((String)o1);
                int n2 = NodeIdUtils.TOINT((String)o2);
                return n1 < n2 ? -1 : (n1 > n2 ? 1 : 0);
            }
            catch (UnknownNodeException une) {
                return ((Comparable)o1).compareTo((Comparable)o2);
            }
            catch (ClassCastException cce) {
                return ((Comparable)o1).compareTo((Comparable)o2);
            }
        }
    }
}

