/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nl.mpi.arbil.ArbilDesktopInjector;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.CmdiProfilesPanel;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDialogue
extends JPanel {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private final WindowManager windowManager;
    private final MessageDialogHandler dialogHandler;
    private final JDialog parentFrame;
    public static final ActionListener templateSelectionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (((JCheckBox)e.getSource()).isSelected()) {
                ArbilTemplateManager.getSingleInstance().addSelectedTemplates(e.getActionCommand());
            } else {
                ArbilTemplateManager.getSingleInstance().removeSelectedTemplates(e.getActionCommand());
            }
        }
    };
    private JButton newTemplateButton;
    protected JPanel internalTemplatesPanel;
    protected JPanel internalTemplatesButtonPanel;
    private JScrollPane templatesScrollPane;
    protected JPanel templatesPanel;
    protected CmdiProfilesPanel cmdiProfilesPanel;

    public TemplateDialogue(WindowManager windowManager, MessageDialogHandler dialogHandler, JDialog parentFrame) {
        this.windowManager = windowManager;
        this.dialogHandler = dialogHandler;
        this.parentFrame = parentFrame;
        this.initComponents();
    }

    private void initComponents() {
        this.internalTemplatesPanel = new JPanel();
        this.internalTemplatesButtonPanel = new JPanel();
        this.newTemplateButton = new JButton();
        this.templatesScrollPane = new JScrollPane();
        this.templatesPanel = new JPanel();
        this.cmdiProfilesPanel = new CmdiProfilesPanel(this.parentFrame);
        this.internalTemplatesPanel.setBorder(BorderFactory.createTitledBorder(widgets.getString("IMDI TEMPLATES")));
        this.internalTemplatesPanel.setLayout(new BorderLayout());
        this.internalTemplatesButtonPanel.setLayout(new BoxLayout(this.internalTemplatesButtonPanel, 2));
        this.newTemplateButton.setText(widgets.getString("NEW TEMPLATE"));
        this.newTemplateButton.setToolTipText(widgets.getString("CREATE A NEW EDITABLE TEMPLATE"));
        this.newTemplateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplateDialogue.this.newTemplateButtonActionPerformed(evt);
            }
        });
        this.internalTemplatesButtonPanel.add(this.newTemplateButton);
        this.internalTemplatesPanel.add((Component)this.internalTemplatesButtonPanel, "Last");
        this.templatesScrollPane.setViewportView(this.templatesPanel);
        this.internalTemplatesPanel.add((Component)this.templatesScrollPane, "Center");
        this.cmdiProfilesPanel.setBorder(BorderFactory.createTitledBorder(widgets.getString("CLARIN PROFILES")));
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new GridLayout(1, 0));
        outerPanel.add(this.internalTemplatesPanel);
        outerPanel.add(this.cmdiProfilesPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)outerPanel, "Center");
        JButton closeButton = new JButton(widgets.getString("CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplateDialogue.this.parentFrame.setVisible(false);
            }
        });
        JPanel closeButtonPanel = new JPanel();
        closeButtonPanel.setLayout(new BorderLayout());
        closeButtonPanel.add((Component)closeButton, "After");
        this.add((Component)outerPanel, "Center");
        this.add((Component)closeButtonPanel, "Last");
    }

    private void newTemplateButtonActionPerformed(ActionEvent evt) {
        try {
            File freshTemplateFile;
            String newDirectoryName = JOptionPane.showInputDialog(this.windowManager.getMainFrame(), widgets.getString("ENTER THE NAME FOR THE NEW TEMPLATE"), this.windowManager.getMainFrame().getTitle(), -1, null, null, null).toString();
            if (ArbilTemplateManager.getSingleInstance().getTemplateFile(newDirectoryName).exists()) {
                this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("THE TEMPLATE {0} ALREADY EXISTS"), newDirectoryName), widgets.getString("TEMPLATES"));
            }
            if ((freshTemplateFile = ArbilTemplateManager.getSingleInstance().createTemplate(newDirectoryName)) != null) {
                this.windowManager.openFileInExternalApplication(freshTemplateFile.toURI());
                this.windowManager.openFileInExternalApplication(freshTemplateFile.getParentFile().toURI());
            } else {
                this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("THE TEMPLATE {0} COULD NOT BE CREATED."), newDirectoryName), widgets.getString("TEMPLATES"));
            }
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
        this.populateLists();
    }

    protected static void addSorted(JPanel targetPanel, List<JCheckBox> checkBoxArray) {
        targetPanel.removeAll();
        targetPanel.setLayout(new BoxLayout(targetPanel, 3));
        Collections.sort(checkBoxArray, new Comparator(){

            public int compare(Object firstItem, Object secondItem) {
                return ((JCheckBox)firstItem).getText().compareToIgnoreCase(((JCheckBox)secondItem).getText());
            }
        });
        for (JCheckBox checkBox : checkBoxArray) {
            targetPanel.add(checkBox);
        }
    }

    protected void populateLists() {
        JCheckBox templateCheckBox;
        List<String> selectedTamplates = ArbilTemplateManager.getSingleInstance().getSelectedTemplates();
        ArrayList<JCheckBox> checkBoxArray = new ArrayList<JCheckBox>();
        for (String[] stringArray : ArbilTemplateManager.getSingleInstance().getTemplate(null).getRootTemplatesArray()) {
            templateCheckBox = new JCheckBox();
            templateCheckBox.setText(MessageFormat.format(widgets.getString("%S (INTERNAL)"), stringArray[1]));
            templateCheckBox.setName(stringArray[1]);
            templateCheckBox.setActionCommand("builtin:" + stringArray[0]);
            templateCheckBox.setSelected(selectedTamplates.contains(templateCheckBox.getActionCommand()));
            templateCheckBox.setToolTipText(stringArray[1]);
            templateCheckBox.addActionListener(templateSelectionListener);
            checkBoxArray.add(templateCheckBox);
        }
        for (String[] stringArray : ArbilTemplateManager.getSingleInstance().getAvailableTemplates()) {
            templateCheckBox = new JCheckBox();
            templateCheckBox.setText((String)stringArray);
            templateCheckBox.setName((String)stringArray);
            templateCheckBox.setActionCommand("template:" + (String)stringArray);
            templateCheckBox.setSelected(selectedTamplates.contains(templateCheckBox.getActionCommand()));
            templateCheckBox.setToolTipText((String)stringArray);
            templateCheckBox.addActionListener(templateSelectionListener);
            checkBoxArray.add(templateCheckBox);
        }
        TemplateDialogue.addSorted(this.templatesPanel, checkBoxArray);
        if (this.cmdiProfilesPanel != null) {
            this.cmdiProfilesPanel.populateProfilesList();
        }
        this.parentFrame.pack();
    }

    public void loadProfiles(boolean forceUpdate) {
        if (this.cmdiProfilesPanel != null) {
            this.cmdiProfilesPanel.loadProfileDescriptions(forceUpdate);
        }
    }

    public static void showTemplatesDialogue(WindowManager windowManager, MessageDialogHandler dialogueHandler) {
        TemplateDialogue.showDialogue(widgets.getString("AVAILABLE TEMPLATES & PROFILES"), windowManager, dialogueHandler);
    }

    protected static void showDialogue(String titleStirng, WindowManager windowManager, MessageDialogHandler dialogueHandler) {
        JDialog dialog = new JDialog(windowManager.getMainFrame(), titleStirng, true);
        TemplateDialogue templateDialogue = new TemplateDialogue(windowManager, dialogueHandler, dialog);
        dialog.setContentPane(templateDialogue);
        templateDialogue.populateLists();
        templateDialogue.loadProfiles(false);
        dialog.pack();
        TemplateDialogue.setDialogHeight(dialog, windowManager);
        dialog.setVisible(true);
    }

    protected static void setDialogHeight(JDialog dialog, WindowManager windowManager) {
        Dimension dialogSize = dialog.getPreferredSize();
        double maxHeight = windowManager.getMainFrame().getSize().getHeight() - 10.0;
        if ((double)dialogSize.height >= maxHeight) {
            dialog.setSize((int)dialogSize.getWidth(), (int)maxHeight);
        }
    }

    public static void main(String[] args) {
        ArbilDesktopInjector injector = new ArbilDesktopInjector();
        injector.injectDefaultHandlers();
        TemplateDialogue.showTemplatesDialogue(injector.getWindowManager(), injector.getWindowManager());
        System.exit(0);
    }
}

