/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;
import net.handle.security.HdlSecurityProvider;

public abstract class AbstractMessage {
    public static final int OC_RESERVED = 0;
    public static final int OC_RESOLUTION = 1;
    public static final int OC_GET_SITE_INFO = 2;
    public static final int OC_CREATE_HANDLE = 100;
    public static final int OC_DELETE_HANDLE = 101;
    public static final int OC_ADD_VALUE = 102;
    public static final int OC_REMOVE_VALUE = 103;
    public static final int OC_MODIFY_VALUE = 104;
    public static final int OC_LIST_HANDLES = 105;
    public static final int OC_RESPONSE_TO_CHALLENGE = 200;
    public static final int OC_VERIFY_CHALLENGE = 201;
    public static final int OC_HOME_NA = 300;
    public static final int OC_UNHOME_NA = 301;
    public static final int OC_LIST_HOMED_NAS = 302;
    public static final int OC_SESSION_SETUP = 400;
    public static final int OC_SESSION_TERMINATE = 401;
    public static final int OC_SESSION_EXCHANGEKEY = 402;
    public static final int OC_GET_NEXT_TXN_ID = 1000;
    public static final int OC_RETRIEVE_TXN_LOG = 1001;
    public static final int OC_DUMP_HANDLES = 1002;
    public static final int OC_BACKUP_SERVER = 1003;
    public static final int RC_RESERVED = 0;
    public static final int RC_SUCCESS = 1;
    public static final int RC_ERROR = 2;
    public static final int RC_SERVER_TOO_BUSY = 3;
    public static final int RC_PROTOCOL_ERROR = 4;
    public static final int RC_OPERATION_NOT_SUPPORTED = 5;
    public static final int RC_RECURSION_COUNT_TOO_HIGH = 6;
    public static final int RC_HANDLE_NOT_FOUND = 100;
    public static final int RC_HANDLE_ALREADY_EXISTS = 101;
    public static final int RC_INVALID_HANDLE = 102;
    public static final int RC_VALUES_NOT_FOUND = 200;
    public static final int RC_VALUE_ALREADY_EXISTS = 201;
    public static final int RC_OUT_OF_DATE_SITE_INFO = 300;
    public static final int RC_SERVER_NOT_RESP = 301;
    public static final int RC_SERVICE_REFERRAL = 302;
    public static final int RC_SERVER_BACKUP = 303;
    public static final int RC_INVALID_ADMIN = 400;
    public static final int RC_INSUFFICIENT_PERMISSIONS = 401;
    public static final int RC_AUTHENTICATION_NEEDED = 402;
    public static final int RC_AUTHENTICATION_FAILED = 403;
    public static final int RC_INVALID_CREDENTIAL = 404;
    public static final int RC_AUTHEN_TIMEOUT = 405;
    public static final int RC_AUTHEN_ERROR = 406;
    public static final int RC_SESSION_TIMEOUT = 500;
    public static final int RC_SESSION_FAILED = 501;
    public static final int RC_INVALID_SESSION_KEY = 502;
    public static final int RC_NEED_RSAKEY_FOR_SESSIONEXCHANGE = 503;
    public static final int RC_INVALID_SESSIONSETUP_REQUEST = 504;
    public int requestId = -1;
    public int sessionId = 0;
    public byte majorProtocolVersion = (byte)-1;
    public byte minorProtocolVersion = (byte)-1;
    public int opCode;
    public int responseCode = 0;
    public int siteInfoSerial = -1;
    public int expiration;
    public short recursionCount = 0;
    public boolean certify = false;
    public boolean cacheCertify = true;
    public boolean authoritative = false;
    public boolean encrypt = false;
    public boolean ignoreRestrictedValues = true;
    public boolean returnRequestDigest = false;
    public boolean recursive = true;
    public boolean continuous = false;
    public boolean keepAlive = false;
    public byte[] signerHdl = null;
    public int signerHdlIdx = 0;
    public byte[] messageBody = null;
    public byte[] signature = null;
    public byte[] encodedMessage = null;
    public byte[] requestDigest = null;
    public byte rdHashType = (byte)2;

    public AbstractMessage() {
        this.expiration = (int)(System.currentTimeMillis() / 1000L) + 43200;
    }

    public AbstractMessage(int opCode) {
        this.opCode = opCode;
        this.expiration = (int)(System.currentTimeMillis() / 1000L) + 43200;
    }

    public final void takeValuesFrom(AbstractMessage msg) throws HandleException {
        this.certify = msg.certify;
        this.cacheCertify = msg.cacheCertify;
        this.authoritative = msg.authoritative;
        this.encrypt = msg.encrypt;
        this.ignoreRestrictedValues = msg.ignoreRestrictedValues;
        this.recursionCount = msg.recursionCount;
        this.returnRequestDigest = this.returnRequestDigest || msg.returnRequestDigest;
        this.majorProtocolVersion = msg.majorProtocolVersion;
        this.minorProtocolVersion = msg.minorProtocolVersion;
        if (this.returnRequestDigest && this instanceof AbstractResponse) {
            this.requestDigest = Util.doDigest((byte)2, msg.getEncodedMessageBody());
        }
    }

    public final void signMessage(byte[] secretKey) throws HandleException {
        byte[] messageHeaderAndBody = this.getEncodedMessageBody();
        byte[] sigType = Common.CREDENTIAL_TYPE_MAC;
        byte[] sigHashType = new byte[]{2};
        byte[] signatureBytes = null;
        byte[] tobeMACed = new byte[2 * secretKey.length + messageHeaderAndBody.length];
        System.arraycopy(secretKey, 0, tobeMACed, 0, secretKey.length);
        System.arraycopy(messageHeaderAndBody, 0, tobeMACed, secretKey.length, messageHeaderAndBody.length);
        System.arraycopy(secretKey, 0, tobeMACed, secretKey.length + messageHeaderAndBody.length, secretKey.length);
        signatureBytes = Util.doDigest(sigHashType[0], tobeMACed);
        int offset = 0;
        this.signature = new byte[8 + sigType.length + 4 + 8 + 4 + signatureBytes.length + 4 + sigHashType.length];
        this.signature[offset++] = 0;
        this.signature[offset++] = 0;
        offset += Encoder.writeInt2(this.signature, offset, 0);
        offset += Encoder.writeByteArray(this.signature, offset, Util.encodeString(""));
        offset += Encoder.writeInt(this.signature, offset, this.sessionId);
        offset += Encoder.writeByteArray(this.signature, offset, sigType);
        offset += Encoder.writeInt(this.signature, offset, sigHashType.length + 4 + signatureBytes.length + 4);
        offset += Encoder.writeByteArray(this.signature, offset, sigHashType);
        offset += Encoder.writeByteArray(this.signature, offset, signatureBytes);
        this.encodedMessage = null;
    }

    public final boolean signMessage(PrivateKey key) throws HandleException, SignatureException {
        byte[] toBeSigned = this.getEncodedMessageBody();
        byte[] sigType = Common.CREDENTIAL_TYPE_SIGNED;
        byte[] sigHashType = Common.HASH_ALG_SHA1;
        byte[] signatureBytes = null;
        try {
            Signature sig = Signature.getInstance(key.getAlgorithm());
            sig.initSign(key);
            sig.update(toBeSigned);
            signatureBytes = sig.sign();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new HandleException(13, "No such algorithm." + nsae.getMessage());
        }
        catch (InvalidKeyException ike) {
            throw new HandleException(13, "Can not sign the message." + ike.getMessage());
        }
        int offset = 0;
        this.signature = new byte[8 + sigType.length + 4 + 8 + 4 + signatureBytes.length + 4 + sigHashType.length];
        this.signature[offset++] = 0;
        this.signature[offset++] = 0;
        offset += Encoder.writeInt2(this.signature, offset, 0);
        offset += Encoder.writeByteArray(this.signature, offset, this.signerHdl);
        offset += Encoder.writeInt(this.signature, offset, this.signerHdlIdx);
        offset += Encoder.writeByteArray(this.signature, offset, sigType);
        offset += Encoder.writeInt(this.signature, offset, sigHashType.length + 4 + signatureBytes.length + 4);
        offset += Encoder.writeByteArray(this.signature, offset, sigHashType);
        offset += Encoder.writeByteArray(this.signature, offset, signatureBytes);
        this.encodedMessage = null;
        return true;
    }

    public final void signMessage(Signature signer) throws HandleException, SignatureException {
        signer.update(this.getEncodedMessageBody());
        byte[] sigType = Common.CREDENTIAL_TYPE_SIGNED;
        byte[] sigHashType = Util.getHashAlgIdFromSigId(signer.getAlgorithm());
        byte[] signatureBytes = signer.sign();
        int offset = 0;
        this.signature = new byte[8 + sigType.length + 4 + 8 + 4 + signatureBytes.length + 4 + sigHashType.length];
        this.signature[offset++] = 0;
        this.signature[offset++] = 0;
        offset += Encoder.writeInt2(this.signature, offset, 0);
        offset += Encoder.writeByteArray(this.signature, offset, this.signerHdl);
        offset += Encoder.writeInt(this.signature, offset, this.signerHdlIdx);
        offset += Encoder.writeByteArray(this.signature, offset, sigType);
        offset += Encoder.writeInt(this.signature, offset, sigHashType.length + 4 + signatureBytes.length + 4);
        offset += Encoder.writeByteArray(this.signature, offset, sigHashType);
        offset += Encoder.writeByteArray(this.signature, offset, signatureBytes);
        this.encodedMessage = null;
    }

    public final boolean verifyMessage(byte[] secretKey) throws Exception {
        if (this.signature == null || this.signature.length <= 0) {
            return false;
        }
        int offset = 0;
        byte sigVersion = this.signature[offset++];
        byte reserved = this.signature[offset++];
        int flags = Encoder.readInt2(this.signature, offset);
        byte[] emptyByte = Encoder.readByteArray(this.signature, offset += 2);
        int sessionid = Encoder.readInt(this.signature, offset += 4 + emptyByte.length);
        byte[] sigType = Encoder.readByteArray(this.signature, offset += 4);
        offset += 4 + sigType.length;
        if (!Util.equals(sigType, Common.CREDENTIAL_TYPE_MAC)) {
            throw new HandleException(16, "Unknown signature type: " + Util.decodeString(sigType));
        }
        int sigSectionLength = Encoder.readInt(this.signature, offset);
        byte[] hashAlgBytes = Encoder.readByteArray(this.signature, offset += 4);
        byte[] origDigestBytes = Encoder.readByteArray(this.signature, offset += 4 + hashAlgBytes.length);
        byte[] messageHeaderAndBody = this.getEncodedMessageBody();
        byte[] tobeMACed = new byte[2 * secretKey.length + messageHeaderAndBody.length];
        System.arraycopy(secretKey, 0, tobeMACed, 0, secretKey.length);
        System.arraycopy(messageHeaderAndBody, 0, tobeMACed, secretKey.length, messageHeaderAndBody.length);
        System.arraycopy(secretKey, 0, tobeMACed, secretKey.length + messageHeaderAndBody.length, secretKey.length);
        byte[] verifyDigest = Util.doDigest(hashAlgBytes[0], tobeMACed);
        return Util.equals(origDigestBytes, verifyDigest);
    }

    public final boolean verifyMessage(PublicKey pubKey) throws Exception {
        if (this.signature == null || this.signature.length <= 0) {
            return false;
        }
        int offset = 0;
        byte sigVersion = this.signature[offset++];
        byte reserved = this.signature[offset++];
        int flags = Encoder.readInt2(this.signature, offset);
        this.signerHdl = Encoder.readByteArray(this.signature, offset += 2);
        this.signerHdlIdx = Encoder.readInt(this.signature, offset += 4 + this.signerHdl.length);
        byte[] sigType = Encoder.readByteArray(this.signature, offset += 4);
        offset += 4 + sigType.length;
        if (!Util.equals(sigType, Common.CREDENTIAL_TYPE_SIGNED) && !Util.equals(sigType, Common.CREDENTIAL_TYPE_OLDSIGNED)) {
            throw new HandleException(16, "Unknown signature type: " + Util.decodeString(sigType));
        }
        int sigSectionLength = Encoder.readInt(this.signature, offset);
        byte[] hashAlgBytes = Encoder.readByteArray(this.signature, offset += 4);
        byte[] sigBytes = Encoder.readByteArray(this.signature, offset += 4 + hashAlgBytes.length);
        if (pubKey instanceof RSAPublicKey) {
            HdlSecurityProvider cryptoProvider = HdlSecurityProvider.getInstance();
            if (cryptoProvider == null) {
                throw new HandleException(14, "Encryption/Key generation engine missing");
            }
            byte[] toBeVerified = this.getEncodedMessageBody();
            if (Util.equals(hashAlgBytes, Common.HASH_ALG_SHA1)) {
                return cryptoProvider.verify_RSA_SHA1_PKCS1(toBeVerified, 0, toBeVerified.length, sigBytes, (RSAPublicKey)pubKey);
            }
            if (Util.equals(hashAlgBytes, Common.HASH_ALG_MD5)) {
                return cryptoProvider.verify_RSA_MD5_PKCS1(toBeVerified, 0, toBeVerified.length, sigBytes, (RSAPublicKey)pubKey);
            }
            throw new HandleException(16, "Unknown signature type or not supported: " + Util.decodeString(sigType));
        }
        Signature sig = Signature.getInstance(Util.getSigIdFromHashAlgId(hashAlgBytes, pubKey.getAlgorithm()));
        sig.initVerify(pubKey);
        sig.update(this.getEncodedMessageBody());
        return sig.verify(sigBytes);
    }

    public static final byte[] encryptMessage(byte[] clearmsg, byte[] secretKey) throws HandleException {
        HdlSecurityProvider cryptoProvider = HdlSecurityProvider.getInstance();
        if (cryptoProvider == null) {
            throw new HandleException(14, "Encryption/Key generation engine missing");
        }
        try {
            return cryptoProvider.encrypt_DES_ECB_PKCS5(clearmsg, 0, clearmsg.length, secretKey);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(10, "Can not encrypt mesage with session key. Message not encrypted!!");
        }
    }

    public static final byte[] decryptMessage(byte[] ciphermsg, byte[] secretKey) throws HandleException {
        HdlSecurityProvider cryptoProvider = HdlSecurityProvider.getInstance();
        if (cryptoProvider == null) {
            throw new HandleException(14, "Encryption/Key generation engine missing");
        }
        try {
            return cryptoProvider.decrypt_DES_ECB_PKCS5(ciphermsg, 0, ciphermsg.length, secretKey);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(10, "Can not decrypt message with session key. Message may not be encrypted!");
        }
    }

    public final void clearBuffers() {
        this.encodedMessage = null;
        this.signature = null;
        this.messageBody = null;
    }

    public final byte[] getEncodedMessageBody() throws HandleException {
        if (this.messageBody != null) {
            return this.messageBody;
        }
        this.messageBody = Encoder.encodeMessage(this);
        return this.messageBody;
    }

    public final byte[] getEncodedMessage() throws HandleException {
        if (this.encodedMessage != null) {
            return this.encodedMessage;
        }
        this.getEncodedMessageBody();
        this.encodedMessage = new byte[this.messageBody.length + 4 + (this.signature == null ? 0 : this.signature.length)];
        System.arraycopy(this.messageBody, 0, this.encodedMessage, 0, this.messageBody.length);
        if (this.signature == null) {
            Encoder.writeInt(this.encodedMessage, this.messageBody.length, 0);
        } else {
            Encoder.writeInt(this.encodedMessage, this.messageBody.length, this.signature.length);
            System.arraycopy(this.signature, 0, this.encodedMessage, this.messageBody.length + 4, this.signature.length);
        }
        return this.encodedMessage;
    }

    public String toString() {
        return "version=" + this.majorProtocolVersion + '.' + this.minorProtocolVersion + "; oc=" + this.opCode + "; rc=" + this.responseCode + "; snId=" + this.sessionId + (this.certify ? " crt" : "") + (this.cacheCertify ? " caCrt" : "") + (this.authoritative ? " auth" : "") + (this.continuous ? " cont'd" : "") + (this.encrypt ? " encrypt" : "") + (this.ignoreRestrictedValues ? " noAuth" : "");
    }

    public static final String getResponseCodeMessage(int responseCode) {
        switch (responseCode) {
            case 0: {
                return "RC_RESERVED";
            }
            case 1: {
                return "SUCCESS";
            }
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "SERVER TOO BUSY";
            }
            case 4: {
                return "PROTOCOL ERROR";
            }
            case 5: {
                return "OPERATION NOT SUPPORTED";
            }
            case 6: {
                return "RECURSION COUNT TOO HIGH";
            }
            case 100: {
                return "HANDLE NOT FOUND";
            }
            case 101: {
                return "HANDLE ALREADY EXISTS";
            }
            case 102: {
                return "INVALID HANDLE";
            }
            case 200: {
                return "VALUES NOT FOUND";
            }
            case 201: {
                return "VALUE ALREADY EXISTS";
            }
            case 300: {
                return "OUT OF DATE SITE INFO";
            }
            case 301: {
                return "SERVER NOT RESPONSIBLE FOR HANDLE";
            }
            case 302: {
                return "SERVICE REFERRAL";
            }
            case 400: {
                return "INVALID ADMIN";
            }
            case 401: {
                return "INSUFFICIENT PERMISSIONS";
            }
            case 402: {
                return "AUTHENTICATION NEEDED";
            }
            case 403: {
                return "AUTHENTICATION FAILED";
            }
            case 404: {
                return "INVALID CREDENTIAL";
            }
            case 405: {
                return "AUTHENTICATION TIMEOUT";
            }
            case 406: {
                return "AUTHENTICATION ERROR";
            }
            case 500: {
                return "SESSION TIMEOUT";
            }
            case 501: {
                return "SESSION FAILED";
            }
            case 502: {
                return "INVALID SESSION KEY";
            }
            case 303: {
                return "SERVER BACKUP/MAINTAIN";
            }
            case 503: {
                return "REQUIRE RSA KEY FOR SESSION EXCHANGE";
            }
            case 504: {
                return "INVALID SESSION REQUEST";
            }
        }
        return "??";
    }
}

