/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import net.handle.dnslib.DNSMessage;
import net.handle.dnslib.DNSQuestion;
import net.handle.dnslib.DNSResolver;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.Util;
import net.handle.server.AbstractServer;
import net.handle.server.DnsUdpConstants;
import net.handle.server.DnsUdpInterface;
import net.handle.server.Main;
import net.handle.server.RequestHandler;
import net.handle.server.RequestHandlerPool;

public class DnsUdpRequestHandler
implements Runnable,
RequestHandler,
DnsUdpConstants,
ResponseMessageCallback {
    public static final boolean DEBUG = true;
    private DatagramPacket packet;
    private byte[] currentHandle = null;
    private DNSMessage currentRequest = null;
    private ResolutionRequest hdlRequest = new ResolutionRequest(Util.encodeString(""), null, null, null);
    private DatagramSocket dsocket;
    private AbstractServer server;
    private Main main;
    private DnsUdpInterface listener;
    private Thread handlerThread;
    private int invocations = 0;
    private boolean isActive = true;
    private boolean isRunning = false;
    private boolean logAccesses = false;
    private long recvTime;
    private RequestHandlerPool handlerPool = null;
    private boolean lookForParent = false;
    private String dnsHandlePrefix;

    public DnsUdpRequestHandler(Main main, DatagramSocket dsock, RequestHandlerPool handlerPool, DnsUdpInterface listener, String dnsToHandlePrefix, boolean logAccesses) {
        this.main = main;
        this.server = main.getServer();
        this.dsocket = dsock;
        this.handlerPool = handlerPool;
        this.logAccesses = logAccesses;
        this.listener = listener;
        this.dnsHandlePrefix = dnsToHandlePrefix;
        this.handlerThread = new Thread(this);
        this.handlerThread.start();
    }

    public void resetThread() {
    }

    public synchronized void deactivate() {
        this.isActive = false;
        this.resetState();
    }

    public int getInvocationCount() {
        return this.invocations;
    }

    public void resetState() {
        this.isRunning = false;
    }

    public RequestHandler newHandler() {
        return new DnsUdpRequestHandler(this.main, this.dsocket, this.handlerPool, this.listener, this.dnsHandlePrefix, this.logAccesses);
    }

    public synchronized void serviceRequest(DatagramPacket packet, long recvTime) {
        this.packet = packet;
        this.recvTime = recvTime;
        this.isRunning = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.isActive) {
            Object pkt = null;
            boolean pktLen = false;
            boolean offset = false;
            DnsUdpRequestHandler dnsUdpRequestHandler = this;
            synchronized (dnsUdpRequestHandler) {
                while (!this.isRunning && this.isActive) {
                    try {
                        this.wait();
                        if (this.isRunning) continue;
                        this.main.logError(75, "hdl-udp error: invalid handler thread state");
                    }
                    catch (Exception e) {
                        this.main.logError(75, String.valueOf(this.getClass()) + "Got exception: " + e);
                    }
                }
                if (!this.isActive) continue;
            }
            try {
                this.handleRequest();
                continue;
            }
            catch (Exception e) {
                this.main.logError(75, String.valueOf(this.getClass()) + ": Exception processing request: " + e);
                continue;
            }
            finally {
                this.handlerPool.returnHandler(this);
                continue;
            }
            break;
        }
        return;
    }

    private String convertDNSNameToHandleStr(String[] dnsName) {
        StringBuffer handleName = new StringBuffer(this.dnsHandlePrefix);
        boolean lastName = false;
        for (int i = dnsName.length - 1; i >= 0; --i) {
            if (i != 0) {
                handleName.append('.');
            } else {
                handleName.append('/');
            }
            handleName.append(dnsName[i].toUpperCase());
        }
        return handleName.toString();
    }

    public byte[] dnsToHandleType(int dnsType, int dnsClass) {
        switch (dnsType) {
            case 1: {
                return DnsUdpConstants.HDL_DNS_TYPE_A;
            }
            case 2: {
                return DnsUdpConstants.HDL_DNS_TYPE_NS;
            }
            case 3: {
                return DnsUdpConstants.HDL_DNS_TYPE_MD;
            }
            case 4: {
                return DnsUdpConstants.HDL_DNS_TYPE_MF;
            }
            case 5: {
                return DnsUdpConstants.HDL_DNS_TYPE_CNAME;
            }
            case 6: {
                return DnsUdpConstants.HDL_DNS_TYPE_SOA;
            }
            case 7: {
                return DnsUdpConstants.HDL_DNS_TYPE_MB;
            }
            case 8: {
                return DnsUdpConstants.HDL_DNS_TYPE_MG;
            }
            case 9: {
                return DnsUdpConstants.HDL_DNS_TYPE_MR;
            }
            case 10: {
                return DnsUdpConstants.HDL_DNS_TYPE_NULL;
            }
            case 11: {
                return DnsUdpConstants.HDL_DNS_TYPE_WKS;
            }
            case 12: {
                return DnsUdpConstants.HDL_DNS_TYPE_PTR;
            }
            case 13: {
                return DnsUdpConstants.HDL_DNS_TYPE_HINFO;
            }
            case 14: {
                return DnsUdpConstants.HDL_DNS_TYPE_MINFO;
            }
            case 15: {
                return DnsUdpConstants.HDL_DNS_TYPE_MX;
            }
            case 16: {
                return DnsUdpConstants.HDL_DNS_TYPE_TXT;
            }
        }
        return null;
    }

    private void handleRequest() {
        ++this.invocations;
        this.currentRequest = new DNSMessage(this.packet.getData(), 0, this.packet.getLength());
        System.err.print("\n>>>Got Request: ");
        for (int i = 0; i < this.currentRequest.questions.length; ++i) {
            if (i != 0) {
                System.err.print("; ");
            }
            this.currentRequest.questions[i].printValues(System.err);
        }
        DNSResolver.DEBUG = false;
        this.currentRequest.recursionAvailable = false;
        if (this.currentRequest.opcode == 0) {
            if (this.currentRequest.questions == null || this.currentRequest.questions.length <= 0) {
                this.currentRequest.opcode = (byte)2;
                this.currentRequest.authAnswer = true;
                this.currentRequest.setDirty();
                this.sendResponse(this.currentRequest);
            } else {
                byte[][] hdlTypeList = new byte[this.currentRequest.questions.length][];
                String hdlName = null;
                for (int i = 0; i < hdlTypeList.length; ++i) {
                    DNSQuestion dnsQ = this.currentRequest.questions[i];
                    hdlTypeList[i] = this.dnsToHandleType(dnsQ.qType, dnsQ.qClass);
                    if (i != 0) continue;
                    hdlName = this.convertDNSNameToHandleStr(dnsQ.qName);
                }
                this.hdlRequest.handle = Util.encodeString(hdlName);
                this.hdlRequest.requestedTypes = hdlTypeList;
                this.hdlRequest.requestedIndexes = null;
                try {
                    this.server.processRequest(this.hdlRequest, null);
                }
                catch (HandleException e) {
                    this.main.logError(75, String.valueOf(this.getClass()) + ": Exception processing request: " + e);
                }
                System.err.println("no records found.  returning error");
                this.currentRequest.responseCode = (byte)3;
                this.currentRequest.setDirty();
                this.sendResponse(this.currentRequest);
            }
        } else if (this.currentRequest.opcode == 1) {
            System.err.println("Got unexpected OPCODE: OP_IQUERY");
            this.currentRequest.responseCode = (byte)4;
            this.currentRequest.setDirty();
            this.sendResponse(this.currentRequest);
        } else if (this.currentRequest.opcode == 2) {
            System.err.println("Got unexpected OPCODE: OP_STATYUS");
            this.currentRequest.responseCode = (byte)4;
            this.currentRequest.setDirty();
            this.sendResponse(this.currentRequest);
        } else {
            System.err.println("Got unknown OPCODE: " + this.currentRequest.opcode);
            this.currentRequest.responseCode = (byte)4;
            this.currentRequest.setDirty();
            this.sendResponse(this.currentRequest);
        }
    }

    public void printPacket(DatagramPacket pkt) {
        byte[] buf = pkt.getData();
        for (int i = 0; i < pkt.getLength(); ++i) {
            if (i % 16 == 0 && i != 0) {
                System.err.print("\n");
            }
            if (buf[i] >= 97 && buf[i] <= 122 || buf[i] >= 65 && buf[i] <= 90 || buf[i] == 46) {
                System.err.print(" " + (char)buf[i]);
                continue;
            }
            System.err.print(" \\" + (buf[i] & 0xFF));
        }
        System.err.print("\n");
    }

    public void handleResponse(AbstractResponse response) {
        System.err.println("Need to send DNS response: " + response);
        if (this.logAccesses) {
            long time = System.currentTimeMillis() - this.recvTime;
            if (response == null) {
                this.main.logAccess("UDP:DNS", this.packet.getAddress(), 0, 0, "?", time);
            } else {
                this.main.logAccess("UDP:DNS", this.packet.getAddress(), response.opCode, response.responseCode, Util.decodeString(this.hdlRequest.handle), time);
            }
        }
    }

    private void sendResponse(DNSMessage dnsMessage) {
        InetAddress addr = this.packet.getAddress();
        int port = this.packet.getPort();
        byte[] buf = dnsMessage.getPacketBuffer();
        try {
            this.dsocket.send(new DatagramPacket(buf, buf.length, addr, port));
            System.err.print("<<<Sending Response with " + dnsMessage.answers.length + " answers, " + dnsMessage.nameServers.length + " nameservers, and " + dnsMessage.additionalResources.length + " addt'l resrcs to: ");
            dnsMessage.questions[0].printValues(System.err);
        }
        catch (IOException e) {
            this.main.logError(75, String.valueOf(this.getClass()) + ": unable to send response packet to " + addr + ":" + port);
        }
    }
}

