/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.SteppingNode;

public class SteppingNavigator {
    public static SteppingNode getFollowingNode(SteppingNode start, SteppingNode anchor) {
        Object nodei = start.getFirstChild();
        if (nodei != null) {
            return nodei;
        }
        if (start.isSameNodeInfo(anchor)) {
            return null;
        }
        nodei = start;
        Object parenti = start.getParent();
        do {
            if ((nodei = nodei.getNextSibling()) != null) {
                return nodei;
            }
            if (parenti.isSameNodeInfo(anchor)) {
                return null;
            }
            nodei = parenti;
        } while ((parenti = parenti.getParent()) != null);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescendantAxisIterator
    implements AxisIterator<NodeInfo> {
        private SteppingNode start;
        private boolean includeSelf;
        private NodeTest test;
        private SteppingNode current;
        private int position;
        private Stepper stepper;

        public DescendantAxisIterator(SteppingNode start, boolean includeSelf, NodeTest test) {
            this.start = start;
            this.includeSelf = includeSelf;
            this.test = test;
            if (!includeSelf || !test.matches(start)) {
                this.current = start;
            }
            if (test == null || test == AnyNodeTest.getInstance()) {
                this.stepper = new FollowingNodeStepper(start);
            } else if (test instanceof NameTest) {
                if (test.getPrimitiveType() == 1) {
                    NameTest nt = (NameTest)test;
                    this.stepper = start instanceof FingerprintedNode ? new FollowingFingerprintedElementStepper(start, nt.getFingerprint()) : new FollowingElementStepper(start, nt.getNamespaceURI(), nt.getLocalPart());
                } else {
                    this.stepper = new FollowingFilteredNodeStepper(start, test);
                }
            } else if (test instanceof NodeKindTest) {
                this.stepper = test.getPrimitiveType() == 1 ? new FollowingElementStepper(start, null, null) : new FollowingFilteredNodeStepper(start, test);
            } else if (test instanceof LocalNameTest) {
                if (test.getPrimitiveType() == 1) {
                    LocalNameTest nt = (LocalNameTest)test;
                    this.stepper = new FollowingElementStepper(start, null, nt.getLocalName());
                } else {
                    this.stepper = new FollowingFilteredNodeStepper(start, test);
                }
            } else if (test instanceof NamespaceTest) {
                if (test.getPrimitiveType() == 1) {
                    NamespaceTest nt = (NamespaceTest)test;
                    this.stepper = new FollowingElementStepper(start, nt.getNamespaceURI(), null);
                } else {
                    this.stepper = new FollowingFilteredNodeStepper(start, test);
                }
            } else {
                this.stepper = new FollowingFilteredNodeStepper(start, test);
            }
            this.position = 0;
        }

        @Override
        public boolean moveNext() {
            return this.next() != null;
        }

        @Override
        public SteppingNode next() {
            if (this.current == null) {
                this.current = this.start;
                this.position = 1;
                return this.start;
            }
            SteppingNode curr = this.stepper.step(this.current);
            this.position = curr != null ? ++this.position : -1;
            this.current = curr;
            return this.current;
        }

        @Override
        public SteppingNode current() {
            return this.position() == 0 ? null : this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
        }

        @Override
        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        @Override
        public Sequence atomize() throws XPathException {
            return this.current.atomize();
        }

        @Override
        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        @Override
        public AxisIterator<NodeInfo> getAnother() {
            return new DescendantAxisIterator(this.start, this.includeSelf, this.test);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }

    private static class FollowingFingerprintedElementStepper
    implements Stepper {
        SteppingNode anchor;
        int fingerprint;

        public FollowingFingerprintedElementStepper(SteppingNode anchor, int fingerprint) {
            this.anchor = anchor;
            this.fingerprint = fingerprint;
        }

        public SteppingNode step(SteppingNode node) {
            while ((node = SteppingNavigator.getFollowingNode(node, this.anchor)) != null && node.getFingerprint() != this.fingerprint) {
            }
            return node;
        }
    }

    private static class FollowingElementStepper
    implements Stepper {
        SteppingNode anchor;
        String uri;
        String local;

        public FollowingElementStepper(SteppingNode anchor, String uri, String local) {
            this.anchor = anchor;
            this.uri = uri;
            this.local = local;
        }

        public SteppingNode step(SteppingNode node) {
            return node.getSuccessorElement(this.anchor, this.uri, this.local);
        }
    }

    private static class FollowingFilteredNodeStepper
    implements Stepper {
        SteppingNode anchor;
        NodeTest test;

        public FollowingFilteredNodeStepper(SteppingNode anchor, NodeTest test) {
            this.anchor = anchor;
            this.test = test;
        }

        public SteppingNode step(SteppingNode node) {
            while ((node = SteppingNavigator.getFollowingNode(node, this.anchor)) != null && !this.test.matches(node)) {
            }
            return node;
        }
    }

    private static class FollowingNodeStepper
    implements Stepper {
        SteppingNode anchor;

        public FollowingNodeStepper(SteppingNode anchor) {
            this.anchor = anchor;
        }

        public SteppingNode step(SteppingNode node) {
            return SteppingNavigator.getFollowingNode(node, this.anchor);
        }
    }

    private static interface Stepper {
        public SteppingNode step(SteppingNode var1);
    }
}

