/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import net.handle.hdllib4.HandleException;
import net.handle.hdllib4.HashBucket;
import net.handle.hdllib4.HashtableRetriever;
import net.handle.hdllib4.ServerHashtable;

public class HandleConfiguration {
    private static ServerHashtable globalHashtable = null;
    private static File globalHashtableFile = null;
    private static boolean globalTableIsOutOfDate = false;
    private static ServerHashtable specificServiceTable = null;
    private static File specificServiceTableFile = null;
    private static HashBucket specificServerInfo = null;
    private static long udpMaxRetries = 4L;
    private static long udpTimeout = 2000L;
    private static long tcpTimeout = 5000L;
    private static int preferredProtocol = 0;
    private static int preferredResolutionMethod = 1;
    static /* synthetic */ Class class$net$handle$hdllib4$HashBucket;

    public static File getGlobalHashTableFile() {
        return globalHashtableFile;
    }

    public static ServerHashtable getGlobalHashTable() {
        return globalHashtable;
    }

    public static void setGlobalHashTable(ServerHashtable table) {
        globalHashtableFile = null;
        globalHashtable = table;
    }

    public static synchronized void updateGlobalHashTableFile() throws Exception {
        File globalFile = globalHashtableFile;
        if (globalHashtableFile == null) {
            throw new Exception("No global file to update!");
        }
        ServerHashtable newGlobalTable = null;
        HashBucket[] allBuckets = globalHashtable.getAllServers();
        for (int i = 0; i < allBuckets.length; ++i) {
            try {
                newGlobalTable = HashtableRetriever.getHashtableFromServer(allBuckets[i], 1);
                if (newGlobalTable == null) continue;
                break;
            }
            catch (Exception e) {
                System.err.println("Exception trying to update hashtable from server: " + allBuckets[i] + "; exception: " + e);
            }
        }
        if (newGlobalTable == null) {
            throw new Exception("Unable to retrieve updated global hashtable");
        }
        System.err.println("Got updated hashtable...");
        newGlobalTable.printValues(System.err);
        byte[] newTableBuf = newGlobalTable.getEncodedValueWithChecksum();
        if (newTableBuf == null) {
            throw new Exception("Unable to re-encode updated global hashtable");
        }
        try {
            System.err.println("Global hash table update not implemented yet!");
        }
        catch (Exception e) {
            System.err.println("Unable to backup old global hashtable file (So I'm not saving the new version): " + e);
        }
        globalHashtable = newGlobalTable;
        globalTableIsOutOfDate = false;
    }

    public static void setGlobalHashTable(File tableFile) throws HandleException, IOException {
        globalHashtable = new ServerHashtable(tableFile);
        globalHashtableFile = tableFile;
    }

    public static ServerHashtable getSpecificServiceTable() {
        return specificServiceTable;
    }

    public static File getSpecificServiceTableFile() {
        return specificServiceTableFile;
    }

    public static void setSpecificServiceTable(File tableFile) throws HandleException, IOException {
        specificServiceTableFile = tableFile;
        HandleConfiguration.setSpecificServiceTable(new ServerHashtable(tableFile));
    }

    public static void setSpecificServiceTable(ServerHashtable table) {
        specificServiceTable = table;
    }

    public static HashBucket getSpecificServerInfo() {
        return specificServerInfo;
    }

    public static void setSpecificServerInfo(InetAddress addr, int port) {
        HashBucket serverInfo = new HashBucket();
        serverInfo.ipAddress = addr.getAddress();
        serverInfo.tcpQueryPort = port;
        serverInfo.udpQueryPort = port;
        specificServerInfo = serverInfo;
    }

    public static int getPreferredResolutionMethod() {
        return preferredResolutionMethod;
    }

    public static void setPreferredResolutionMethod(int method) {
        if (method == 1 || method == 0 || method == 2) {
            preferredResolutionMethod = method;
        }
    }

    public static int getPreferredProtocol() {
        return preferredProtocol;
    }

    public static void setPreferredProtocol(int protocol) {
        if (protocol == 1 || protocol == 0) {
            preferredProtocol = protocol;
        }
    }

    public static long getUdpTimeout() {
        return udpTimeout;
    }

    public static void setUdpTimeout(long value) {
        udpTimeout = value;
    }

    public static long getUdpMaxRetries() {
        return udpMaxRetries;
    }

    public static void setUdpMaxRetries(long value) {
        udpMaxRetries = value;
    }

    public static long getTcpTimeout() {
        return tcpTimeout;
    }

    public static void setTcpTimeout(long value) {
        tcpTimeout = value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            InputStream globalTableIn = (class$net$handle$hdllib4$HashBucket == null ? (class$net$handle$hdllib4$HashBucket = HandleConfiguration.class$("net.handle.hdllib4.HashBucket")) : class$net$handle$hdllib4$HashBucket).getResourceAsStream("/net/handle/etc/hdl_glb.tbl");
            if (globalTableIn == null) {
                globalTableIn = (class$net$handle$hdllib4$HashBucket == null ? (class$net$handle$hdllib4$HashBucket = HandleConfiguration.class$("net.handle.hdllib4.HashBucket")) : class$net$handle$hdllib4$HashBucket).getResourceAsStream("hdl_glb.tbl");
            }
            if (globalTableIn == null) {
                System.err.println("Couldn't find global table 'hdl_glb.tbl' resource");
            } else {
                int r;
                byte[] buf = new byte[65536];
                int n = 0;
                while ((r = globalTableIn.read(buf, n, 65536 - n)) >= 0) {
                    n += r;
                }
                HandleConfiguration.setGlobalHashTable(new ServerHashtable(buf, 0, n));
            }
        }
        catch (Exception e) {
            System.err.println("Unable to find global hash table: " + e);
            e.printStackTrace(System.err);
        }
    }
}

