/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.bdbje;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.server.DBTransactionLog;
import net.handle.util.StreamTable;

public final class BDBJEHandleStorage
implements HandleStorage {
    private Object CREATE_LOCK = new Object();
    private boolean logTxns = false;
    private File serverDir;
    private Environment environment = null;
    private DBTransactionLog txnLog;
    private static final String HANDLE_DB_NAME = "handles";
    private static final String NA_DB_NAME = "nas";
    private DBWrapper db = null;
    private DBWrapper naDB = null;
    private boolean readOnly = false;
    private static final byte[] BLANK_BYTES = new byte[0];

    public void init(StreamTable config) throws Exception {
        this.serverDir = new File(config.getStr("serverDir", null));
        if (!this.serverDir.exists()) {
            this.serverDir.mkdirs();
        }
        this.logTxns = config.getBoolean("enable_recovery_log", false);
        if (this.logTxns) {
            this.txnLog = new DBTransactionLog(new File(this.serverDir, "dbtxns.log"));
        }
        System.err.println("Opening Berkeley database in " + this.serverDir.getAbsolutePath());
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        this.environment = new Environment(this.serverDir, envConfig);
        this.db = new DBWrapper(HANDLE_DB_NAME);
        this.naDB = new DBWrapper(NA_DB_NAME);
    }

    public final boolean haveNA(byte[] authHandle) throws HandleException {
        try {
            return this.naDB.get(Util.upperCaseInPlace(authHandle)) != null;
        }
        catch (Exception e) {
            throw new HandleException(1, "Error accessing NA data");
        }
    }

    public final void setHaveNA(byte[] authHandle, boolean flag) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18);
        }
        try {
            byte[] handle = Util.upperCaseInPlace(authHandle);
            if (flag) {
                if (this.logTxns) {
                    this.txnLog.log((byte)2, handle, BLANK_BYTES);
                }
                this.naDB.put(handle, BLANK_BYTES);
            } else {
                if (this.logTxns) {
                    this.txnLog.log((byte)3, handle, BLANK_BYTES);
                }
                this.naDB.del(handle);
            }
        }
        catch (Exception e) {
            throw new HandleException(1, "Error recording NA status");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createHandle(byte[] inHandle, HandleValue[] values) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18);
        }
        int totalSize = 4;
        for (int i = 0; i < values.length; ++i) {
            totalSize += Encoder.calcStorageSize(values[i]) + 4;
        }
        byte[] data = new byte[totalSize];
        int offst = 0;
        offst += Encoder.writeInt(data, offst, values.length);
        for (int i = 0; i < values.length; ++i) {
            int clumpLen = Encoder.encodeHandleValue(data, offst + 4, values[i]);
            offst += Encoder.writeInt(data, offst, clumpLen);
            offst += clumpLen;
        }
        Object object = this.CREATE_LOCK;
        synchronized (object) {
            byte[] handle = inHandle;
            byte[] existingHandle = null;
            try {
                existingHandle = this.db.get(handle);
            }
            catch (Exception e) {
                throw new HandleException(1, "Error checking for existing handle");
            }
            if (existingHandle != null) {
                throw new HandleException(5, "Handle already exists");
            }
            try {
                if (this.logTxns) {
                    this.txnLog.log((byte)0, handle, data);
                }
                this.db.put(handle, data);
            }
            catch (HandleException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new HandleException(1, "Error creating handle");
            }
        }
    }

    public final boolean deleteHandle(byte[] handle) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18);
        }
        try {
            if (this.logTxns) {
                this.txnLog.log((byte)1, handle, BLANK_BYTES);
            }
            return this.db.del(handle);
        }
        catch (HandleException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw new HandleException(1, "Error deleting handle");
        }
    }

    public final byte[][] getRawHandleValues(byte[] handle, int[] indexList, byte[][] typeList) throws HandleException {
        int clumpIndex;
        byte[] clumpType;
        int clumpLen;
        byte[] value = null;
        try {
            value = this.db.get(handle);
        }
        catch (Exception e) {
            throw new HandleException(1, "Error retrieving handle");
        }
        if (value == null) {
            return null;
        }
        int bufPos = 0;
        boolean allValues = !(indexList != null && indexList.length != 0 || typeList != null && typeList.length != 0);
        int numValues = Encoder.readInt(value, bufPos);
        int origBufPos = bufPos += 4;
        int matches = 0;
        if (allValues) {
            matches = numValues;
        } else {
            for (int i = 0; i < numValues; ++i) {
                clumpLen = Encoder.readInt(value, bufPos);
                clumpType = Encoder.getHandleValueType(value, bufPos += 4);
                clumpIndex = Encoder.getHandleValueIndex(value, bufPos);
                if (Util.isParentTypeInArray(typeList, clumpType) || Util.isInArray(indexList, clumpIndex)) {
                    ++matches;
                }
                bufPos += clumpLen;
            }
        }
        byte[][] clumps = new byte[matches][];
        int clumpNum = 0;
        bufPos = origBufPos;
        for (int i = 0; i < numValues; ++i) {
            clumpLen = Encoder.readInt(value, bufPos);
            clumpType = Encoder.getHandleValueType(value, bufPos += 4);
            clumpIndex = Encoder.getHandleValueIndex(value, bufPos);
            if (allValues || Util.isParentTypeInArray(typeList, clumpType) || Util.isInArray(indexList, clumpIndex)) {
                clumps[clumpNum] = new byte[clumpLen];
                System.arraycopy(value, bufPos, clumps[clumpNum], 0, clumpLen);
                ++clumpNum;
            }
            bufPos += clumpLen;
        }
        return clumps;
    }

    public final void updateValue(byte[] handle, HandleValue[] values) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18);
        }
        byte[] existingHandle = null;
        try {
            existingHandle = this.db.get(handle);
        }
        catch (Exception e) {
            throw new HandleException(1, "Error checking for existing handle");
        }
        if (existingHandle == null) {
            throw new HandleException(9, "Cannot modify non-existent handle");
        }
        int totalSize = 4;
        for (int i = 0; i < values.length; ++i) {
            totalSize += Encoder.calcStorageSize(values[i]) + 4;
        }
        byte[] data = new byte[totalSize];
        int offst = 0;
        offst += Encoder.writeInt(data, offst, values.length);
        for (int i = 0; i < values.length; ++i) {
            int clumpLen = Encoder.encodeHandleValue(data, offst + 4, values[i]);
            offst += Encoder.writeInt(data, offst, clumpLen);
            offst += clumpLen;
        }
        try {
            if (this.logTxns) {
                this.txnLog.log((byte)0, handle, data);
            }
            this.db.put(handle, data);
        }
        catch (HandleException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw new HandleException(1, "Error updating handle");
        }
    }

    public final void scanHandles(ScanCallback callback) throws HandleException {
        Enumeration e = this.db.getEnumerator();
        while (e.hasMoreElements()) {
            byte[][] record = (byte[][])e.nextElement();
            callback.scanHandle(record[0]);
        }
    }

    public void scanNAs(ScanCallback callback) throws HandleException {
        Enumeration e = this.naDB.getEnumerator();
        while (e.hasMoreElements()) {
            byte[][] record = (byte[][])e.nextElement();
            callback.scanHandle(record[0]);
        }
    }

    public final Enumeration getHandlesForNA(byte[] naHdl) throws HandleException {
        if (!this.haveNA(naHdl)) {
            throw new HandleException(0, "The requested naming authority doesn't live here");
        }
        return new HdlsForNAEnum(this.db.getEnumerator(), Util.getIDPart(naHdl));
    }

    public final void deleteAllRecords() throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18);
        }
        try {
            if (this.logTxns) {
                this.txnLog.log((byte)4, BLANK_BYTES, BLANK_BYTES);
            }
            this.db.deleteAllRecords();
            this.naDB.deleteAllRecords();
        }
        catch (HandleException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw new HandleException(1, String.valueOf(e));
        }
    }

    public final void checkpointDatabase() throws HandleException {
        throw new HandleException(15, "Checkpoint not available in this server");
    }

    public final void shutdown() {
        try {
            this.db.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.naDB.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (this.logTxns) {
                this.txnLog.shutdown();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.environment.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void finalize() {
        this.shutdown();
    }

    private class DBWrapper {
        private Database db;
        private String dbName;

        public DBWrapper(String dbName) throws Exception {
            this.dbName = dbName;
            this.openDB();
        }

        private void openDB() throws Exception {
            Transaction openTxn = BDBJEHandleStorage.this.environment.beginTransaction(null, null);
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setTransactional(true);
            dbConfig.setAllowCreate(true);
            dbConfig.setSortedDuplicates(false);
            this.db = BDBJEHandleStorage.this.environment.openDatabase(openTxn, this.dbName, dbConfig);
            openTxn.commitSync();
        }

        public byte[] get(byte[] key) throws IOException, DatabaseException {
            DatabaseEntry dbVal = new DatabaseEntry();
            if (this.db.get(null, new DatabaseEntry(key), dbVal, null) == OperationStatus.SUCCESS) {
                return dbVal.getData();
            }
            return null;
        }

        public void put(byte[] key, byte[] data) throws IOException, DatabaseException {
            Transaction putTxn = BDBJEHandleStorage.this.environment.beginTransaction(null, null);
            if (this.db.put(putTxn, new DatabaseEntry(key), new DatabaseEntry(data)) != OperationStatus.SUCCESS) {
                try {
                    putTxn.abort();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw new DatabaseException("Unknown exception upon database 'put'");
            }
            putTxn.commitSync();
        }

        public void close() throws IOException, DatabaseException {
            this.db.close();
        }

        public boolean del(byte[] key) throws IOException, DatabaseException {
            Transaction delTxn = BDBJEHandleStorage.this.environment.beginTransaction(null, null);
            boolean result = this.db.delete(delTxn, new DatabaseEntry(key)) == OperationStatus.SUCCESS;
            delTxn.commitSync();
            return result;
        }

        public Enumeration getEnumerator() {
            return new DBIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteAllRecords() throws Exception {
            Database tmpDB = this.db;
            try {
                this.db = null;
                tmpDB.close();
                tmpDB = null;
                Transaction killTxn = BDBJEHandleStorage.this.environment.beginTransaction(null, null);
                BDBJEHandleStorage.this.environment.truncateDatabase(killTxn, this.dbName, false);
                killTxn.commitSync();
            }
            finally {
                if (this.db == null) {
                    this.openDB();
                }
            }
        }

        class DBIterator
        implements Enumeration {
            private Cursor cursor = null;
            private DatabaseEntry keyEntry = new DatabaseEntry();
            private DatabaseEntry valEntry = new DatabaseEntry();
            private OperationStatus lastStatus = null;

            public DBIterator() {
                try {
                    this.cursor = DBWrapper.this.db.openCursor(null, null);
                    this.lastStatus = this.cursor.getFirst(this.keyEntry, this.valEntry, null);
                }
                catch (Exception e) {
                    System.err.println("Error in DBIterator(): " + e);
                    this.cursor = null;
                    this.lastStatus = null;
                }
            }

            public synchronized boolean hasMoreElements() {
                return this.lastStatus == OperationStatus.SUCCESS;
            }

            public synchronized Object nextElement() throws NoSuchElementException {
                if (this.cursor == null || this.lastStatus == null || this.lastStatus != OperationStatus.SUCCESS) {
                    throw new NoSuchElementException();
                }
                byte[][] b = new byte[][]{new byte[this.keyEntry.getSize()], new byte[this.valEntry.getSize()]};
                System.arraycopy(this.keyEntry.getData(), 0, b[0], 0, b[0].length);
                System.arraycopy(this.valEntry.getData(), 0, b[1], 0, b[1].length);
                try {
                    this.lastStatus = this.cursor.getNext(this.keyEntry, this.valEntry, null);
                }
                catch (Exception e) {
                    this.cursor = null;
                    this.lastStatus = null;
                }
                return b;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finalize() {
                try {
                    if (this.cursor != null) {
                        this.cursor.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Error in db cursor finalize: " + e);
                    DBIterator dBIterator = this;
                    synchronized (dBIterator) {
                        this.cursor = null;
                    }
                }
            }
        }
    }

    private final class HdlsForNAEnum
    implements Enumeration {
        private byte[] prefix;
        private byte[] nextHdl = null;
        private Enumeration dbEnum;

        HdlsForNAEnum(Enumeration dbEnum, byte[] na) {
            this.prefix = Util.encodeString(Util.decodeString(na) + '/');
            this.dbEnum = dbEnum;
            this.seekNextValue();
        }

        private final void seekNextValue() {
            this.nextHdl = null;
            while (this.dbEnum.hasMoreElements()) {
                byte[][] tmpRecord = (byte[][])this.dbEnum.nextElement();
                if (!Util.startsWithCI(tmpRecord[0], this.prefix)) continue;
                this.nextHdl = tmpRecord[0];
                return;
            }
        }

        public final boolean hasMoreElements() {
            return this.nextHdl != null;
        }

        public final Object nextElement() {
            byte[] thisHdl = this.nextHdl;
            this.seekNextValue();
            return thisHdl;
        }
    }
}

