/*
 * Decompiled with CFR 0.152.
 */
package net.handle.awt;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.handle.awt.AwtUtil;

public class TaskIndicator
extends JDialog
implements Runnable,
ActionListener {
    private Runnable task = null;
    private Thread taskThread = null;
    private JLabel label;
    private Component parent;
    private static JFrame testFrame;

    public static void main(String[] argv) {
        testFrame = new JFrame("test");
        JButton testButton = new JButton("Click Me");
        testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TaskIndicator ti = new TaskIndicator((Component)testFrame);
                Runnable runner = new Runnable(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        try {
                            Thread.currentThread();
                            Thread.sleep(10000L);
                        }
                        catch (Throwable e) {
                            System.err.println("Runner got exception: " + e);
                            e.printStackTrace(System.err);
                        }
                    }
                };
                ti.invokeTask(runner, "Sleeping a bit...");
            }
        });
        testFrame.getContentPane().add(testButton);
        testFrame.setSize(200, 100);
        testFrame.setVisible(true);
    }

    public TaskIndicator(Component parent) {
        super(AwtUtil.getFrame(parent), "", true);
        this.parent = parent;
        JPanel p = new JPanel(new GridBagLayout());
        this.label = new JLabel(" ", 0);
        JButton cancelButton = new JButton("Cancel");
        p.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)this.label, AwtUtil.getConstraints(1, 1, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)new JLabel(" "), AwtUtil.getConstraints(2, 2, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)cancelButton, AwtUtil.getConstraints(0, 3, 1.0, 0.0, 3, 1, false, false));
        cancelButton.addActionListener(this);
        this.getContentPane().add(p);
    }

    public void invokeTask(Runnable task, String taskLabel) {
        this.label.setText(taskLabel);
        this.pack();
        this.setSize(this.getPreferredSize());
        AwtUtil.setWindowPosition((Window)this, this.parent);
        this.task = task;
        this.taskThread = new Thread(this);
        this.taskThread.start();
        this.setVisible(true);
        this.task = null;
        this.taskThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isVisible()) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Throwable e) {}
        }
        try {
            this.task.run();
        }
        catch (Throwable e) {
            System.err.println("Exception running task: " + e);
            e.printStackTrace(System.err);
        }
        finally {
            this.taskFinished();
        }
    }

    private synchronized void taskFinished() {
        this.task = null;
        this.taskThread = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TaskIndicator.this.setVisible(false);
                TaskIndicator.this.dispose();
            }
        });
    }

    private void cancelPressed() {
        try {
            System.err.println("cancel process...");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TaskIndicator.this.setVisible(false);
                    TaskIndicator.this.dispose();
                }
            });
            this.taskThread.interrupt();
        }
        catch (Exception e) {
            System.err.println("Exception interrupting task: " + e);
            e.printStackTrace(System.err);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        this.cancelPressed();
    }
}

