/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.translation.tools;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import nl.mpi.translation.tools.UrlStreamResolver;
import nl.mpi.translation.tools.UrlStreamResolverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileAwareUrlStreamResolver
implements UrlStreamResolver {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileAwareUrlStreamResolver.class);
    private final UrlStreamResolver baseResolver;
    private final String baseUrl;
    private final File basePath;

    public LocalFileAwareUrlStreamResolver(UrlStreamResolver baseResolver, String baseUrl, String basePath) {
        this.baseResolver = baseResolver;
        this.baseUrl = Strings.emptyToNull((String)baseUrl);
        this.basePath = Strings.isNullOrEmpty((String)basePath) ? null : new File(basePath);
    }

    public LocalFileAwareUrlStreamResolver(String baseUrl, String basePath) {
        this(new UrlStreamResolverImpl(), baseUrl, basePath);
    }

    @Override
    public InputStream getStream(URL url) throws IOException {
        String urlString;
        if (this.baseUrl != null && this.basePath != null && (urlString = url.toString()).startsWith(this.baseUrl)) {
            String child = urlString.substring(this.baseUrl.length());
            File localFile = new File(this.basePath, child);
            if (localFile.exists()) {
                logger.debug("Resolved {} to {}", (Object)url, (Object)localFile);
                return new FileInputStream(localFile);
            }
            logger.warn("Requested resource '{}' was not found at expected location '{}'. Falling back to requested external URL.", (Object)url, (Object)localFile.getAbsolutePath());
        }
        logger.debug("Falling back to base resolver for {}", (Object)url);
        return this.baseResolver.getStream(url);
    }
}

