/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.translation.tools.util;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;

public class TranslationServiceErrorListener
implements ErrorListener {
    private final Logger logger;

    public TranslationServiceErrorListener(Logger logger) {
        this.logger = logger;
        logger.debug("Redirecting XSLT warnings and errors to this logger");
    }

    @Override
    public void warning(TransformerException te) throws TransformerException {
        this.logger.warn("Transformer warning: {}", (Object)te.getMessageAndLocation());
        this.logger.debug("Transformation warning stacktrace", (Throwable)te);
    }

    @Override
    public void error(TransformerException te) throws TransformerException {
        this.logger.debug("Transformation error", (Throwable)te);
    }

    @Override
    public void fatalError(TransformerException te) throws TransformerException {
        this.logger.debug("Transformation fatal error", (Throwable)te);
    }
}

