/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class OurURL
implements Serializable {
    private URL url;

    public OurURL(URL url) throws MalformedURLException {
        this.url = new URL(url.getProtocol(), url.getHost(), url.getPort(), OurURL.absDevLet(url.getFile()).replace('\\', '/'));
    }

    public OurURL(URL url, boolean transformSlashes, boolean transformSpaces, boolean transformDrives) throws MalformedURLException {
        String file = url.getFile();
        if (!(transformDrives || transformSlashes || transformSpaces)) {
            this.url = url;
            return;
        }
        if (transformDrives) {
            file = OurURL.absDevLet(file);
        }
        if (transformSlashes) {
            file = file.replace('\\', '/');
        }
        if (transformSpaces) {
            file = OurURL.encode(file);
        }
        this.url = new URL(url.getProtocol(), url.getHost(), url.getPort(), OurURL.absDevLet(url.getFile()).replace('\\', '/'));
    }

    public OurURL(String spec) throws MalformedURLException {
        spec = spec.replace('\\', '/');
        if (spec.startsWith("file:")) {
            this.url = new URL("file", "", -1, OurURL.absDevLet(spec.substring(5)));
        } else {
            this.url = new URL(OurURL.encode(spec));
        }
    }

    public OurURL(String protocol, String host, int port, String file) throws MalformedURLException {
        file = file.replace('\\', '/');
        file = OurURL.absDevLet(file);
        if ("http".equals(protocol)) {
            file = OurURL.encode(file);
        }
        this.url = new URL(protocol, host, port, file);
    }

    public OurURL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        file = file.replace('\\', '/');
        file = OurURL.absDevLet(file);
        if ("http".equals(protocol)) {
            file = OurURL.encode(file);
        }
        this.url = new URL(protocol, host, port, file, handler);
    }

    public OurURL(String protocol, String host, String file) throws MalformedURLException {
        file = file.replace('\\', '/');
        file = OurURL.absDevLet(file);
        if ("http".equals(protocol)) {
            file = OurURL.encode(file);
        }
        this.url = new URL(protocol, host, file);
    }

    public OurURL(URL context, String spec) throws MalformedURLException {
        if (context != null) {
            spec = OurURL.encode(spec.replace('\\', '/'));
            this.url = new URL(context, OurURL.absDevLet(spec));
        } else {
            this.url = new OurURL(spec).toURL();
        }
    }

    public OurURL(OurURL context, String spec) throws MalformedURLException {
        if (context != null) {
            spec = OurURL.encode(spec.replace('\\', '/'));
            this.url = new URL(context.toURL(), OurURL.absDevLet(spec));
        } else {
            this.url = new OurURL(spec).toURL();
        }
    }

    public URL toURL() {
        return this.url;
    }

    public String getProtocol() {
        return this.toURL().getProtocol();
    }

    public int getPort() {
        return this.toURL().getPort();
    }

    public String getPath() {
        String path = this.toURL().getPath();
        if (path.length() > 1 && path.charAt(0) == '/' && path.charAt(2) == ':') {
            return path.substring(1);
        }
        return path;
    }

    public String getHost() {
        return this.toURL().getHost();
    }

    public String getFile() {
        if (this.toURL().getQuery() == null) {
            return this.getPath();
        }
        return this.getPath() + this.toURL().getQuery();
    }

    public boolean sameFile(OurURL other) {
        return this.toURL().sameFile(other.toURL());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        OurURL other = (OurURL)obj;
        if (!this.getFile().equals(other.getFile())) {
            return false;
        }
        if (!this.getProtocol().equals(other.getProtocol())) {
            return false;
        }
        if (!this.getHost().equals(other.getHost())) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getUserInfo() != null && !this.getUserInfo().equals(other.getUserInfo())) {
            return false;
        }
        if (this.getUserInfo() == null && other.getUserInfo() != null) {
            return false;
        }
        if (this.getRef() != null && !this.getRef().equals(other.getRef())) {
            return false;
        }
        return this.getRef() != null || other.getRef() == null;
    }

    public int hashCode() {
        String textual = "" + this.getProtocol() + this.getUserInfo() + ":" + this.getAuthority() + this.getFile() + "#" + this.getRef();
        return textual.hashCode();
    }

    public Object getContent() throws IOException {
        return this.toURL().getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.toURL().getContent(classes);
    }

    public String getAuthority() {
        return this.toURL().getAuthority();
    }

    public String getUserInfo() {
        return this.toURL().getUserInfo();
    }

    public String getRef() {
        return this.toURL().getRef();
    }

    public URLConnection openConnection() throws IOException {
        return this.toURL().openConnection();
    }

    public InputStream openStream() throws IOException {
        return this.toURL().openStream();
    }

    public String toString() {
        return OurURL.decode(this.toURL().toString());
    }

    public String toEncodedString() {
        return this.toURL().toString();
    }

    public String toDecodedString() {
        return this.toString();
    }

    private static String absDevLet(String s) {
        if (s == null) {
            return s;
        }
        if (s.length() > 2 && s.charAt(1) == ':') {
            s = "/" + s;
        }
        if (s.startsWith("file:") && s.length() > 6 && s.charAt(6) == ':') {
            s = "file:/" + s.substring(5);
        }
        return s;
    }

    private static String encode(String s) {
        return s.replaceAll(" ", "%20");
    }

    private static String decode(String s) {
        return s.replaceAll("%20", " ");
    }
}

