/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.favourites;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.metadatafile.MetadataUtils;
import nl.mpi.arbil.favourites.FavouritesExporter;
import nl.mpi.arbil.favourites.FavouritesImportExportException;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavouritesExporterImpl
implements FavouritesExporter {
    private final SessionStorage sessionStorage;
    private final ApplicationVersion applicationVersion;

    public FavouritesExporterImpl(SessionStorage sessionStorage, ApplicationVersion applicationVersion) {
        this.sessionStorage = sessionStorage;
        this.applicationVersion = applicationVersion;
    }

    @Override
    public void exportFavourites(File exportLocation, ArbilDataNode[] favouriteNodes) throws FavouritesImportExportException {
        List<URI> favouriteNodeUris = this.copyNodes(exportLocation, favouriteNodes);
        try {
            this.writeFavouritesList(favouriteNodeUris, new File(exportLocation, "favourites.config"));
        }
        catch (IOException ioEx) {
            throw new FavouritesImportExportException("An I/O exception occurred while exporting favourites", ioEx);
        }
    }

    private List<URI> copyNodes(File exportLocation, ArbilDataNode[] favouriteNodes) throws FavouritesImportExportException {
        URI favouritesBaseUri = this.sessionStorage.getFavouritesDir().toURI();
        URI exportUri = exportLocation.toURI();
        ArrayList<URI> favouriteNodeUris = new ArrayList<URI>(favouriteNodes.length);
        for (ArbilDataNode favouriteNode : favouriteNodes) {
            URI nodeUri = favouriteNode.getURI();
            URI relativeNodeUri = favouritesBaseUri.relativize(nodeUri);
            favouriteNodeUris.add(relativeNodeUri);
            URI targetUri = exportUri.resolve(relativeNodeUri);
            this.copyNode(nodeUri, targetUri);
        }
        return favouriteNodeUris;
    }

    private void copyNode(URI sourceUri, URI targetUri) throws FavouritesImportExportException {
        try {
            URI sourceFileUri = new URI(sourceUri.getScheme(), sourceUri.getSchemeSpecificPart(), null);
            URI targetFileUri = new URI(targetUri.getScheme(), targetUri.getSchemeSpecificPart(), null);
            MetadataUtils mdUtils = ArbilDataNode.getMetadataUtils(targetFileUri.toString());
            mdUtils.copyMetadataFile(sourceFileUri, new File(targetFileUri), null, false);
        }
        catch (IOException ex) {
            throw new FavouritesImportExportException("Could not copy metadata file", ex);
        }
        catch (ArbilMetadataException ex) {
            throw new FavouritesImportExportException("Could not process metadata file", ex);
        }
        catch (URISyntaxException ex) {
            throw new FavouritesImportExportException("Invalid target URI", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFavouritesList(List<URI> favouriteNodeUris, File listFile) throws FavouritesImportExportException, IOException {
        if (listFile.exists()) {
            throw new FavouritesImportExportException("Target list file already exists");
        }
        FileOutputStream os = new FileOutputStream(listFile);
        OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)os, "UTF-8");
        BufferedWriter writer = new BufferedWriter(osWriter);
        writer.write(this.getPreamble());
        try {
            for (URI favouriteNodeUri : favouriteNodeUris) {
                writer.write(favouriteNodeUri.toString());
                writer.write("\n");
            }
        }
        finally {
            writer.close();
        }
    }

    private String getPreamble() {
        return String.format("# The files in this directory are the result of an export that was created by Arbil.\n# You can re-import them into Arbil on another computer. \n# \n# Arbil can be downloaded for free at http://tla.mpi.nl/tools/arbil\n# \n# Arbil version: %s version %s.%sr%s\n# Export date: %s\n# \n", this.applicationVersion.applicationTitle, this.applicationVersion.currentMajor, this.applicationVersion.currentMinor, this.applicationVersion.currentRevision, DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime()));
    }
}

