/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ImageBoxRenderer;
import nl.mpi.arbil.ui.TableController;
import nl.mpi.arbil.util.ArbilActionBuffer;

public class ArbilSubnodesPanel
extends JPanel
implements ArbilDataNodeContainer {
    private static Border levelBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 2, 2, 0, Color.LIGHT_GRAY), new EmptyBorder(0, 5, 0, 0));
    private static Border labelPadding = new EmptyBorder(2, 0, 2, 0);
    private final ImageBoxRenderer imageBoxRenderer;
    private final TableController tableController;
    private ArbilActionBuffer reloadRunner = new ArbilActionBuffer("SubnodePanelReload-" + this.hashCode(), 150){

        public void executeAction() {
            ArbilSubnodesPanel.this.reloadAll();
        }
    };
    private JPanel contentPanel;
    private ArbilTable table;
    private JLabel titleLabel;
    protected ArbilDataNode dataNode;
    protected ArbilSubnodesPanel parent;
    protected final ArrayList<ArbilSubnodesPanel> children = new ArrayList();

    public ArbilDataNode getDataNode() {
        return this.dataNode;
    }

    public ArbilSubnodesPanel(ArbilDataNode dataNode, TableController tableController, ImageBoxRenderer imageBoxRenderer) {
        this(dataNode, null, tableController, imageBoxRenderer);
    }

    public String toString() {
        if (this.dataNode != null) {
            return "ArbilSubnodesPanel " + this.dataNode.toString();
        }
        return super.toString();
    }

    public boolean isTopLevelPanel() {
        return this.parent == null;
    }

    private ArbilSubnodesPanel(ArbilDataNode dataNode, ArbilSubnodesPanel parent, TableController tableController, ImageBoxRenderer imageBoxRenderer) {
        this.imageBoxRenderer = imageBoxRenderer;
        this.dataNode = dataNode;
        this.parent = parent;
        this.tableController = tableController;
        this.setLayout(new BoxLayout(this, 2));
        this.setAlignmentX(0.0f);
        this.setOpaque(false);
        this.addContents();
    }

    protected final void addContents() {
        this.add(Box.createRigidArea(new Dimension(this.parent == null ? 2 : 5, 0)));
        this.contentPanel = this.createContentPanel(this.dataNode);
        this.add(this.contentPanel);
        this.dataNode.registerContainer(this.getTopLevelPanel());
    }

    public void stopAllEditing() {
        TableCellEditor cellEditor;
        if (this.table != null && (cellEditor = this.table.getCellEditor()) != null) {
            cellEditor.stopCellEditing();
        }
        for (ArbilSubnodesPanel child : this.children) {
            child.stopAllEditing();
        }
    }

    public void clear() {
        for (ArbilSubnodesPanel child : this.children) {
            child.clear();
        }
        this.children.clear();
        this.dataNode.removeContainer(this.getTopLevelPanel());
        if (this.table != null) {
            this.table.getArbilTableModel().removeArbilDataNodes(new ArbilDataNode[]{this.dataNode});
        }
        if (this.contentPanel != null) {
            this.contentPanel.removeAll();
        }
        this.removeAll();
    }

    private JPanel createContentPanel(ArbilDataNode dataNode) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setAlignmentX(0.0f);
        panel.setBorder(levelBorder);
        this.titleLabel = new JLabel(dataNode.toString(), ArbilIcons.getSingleInstance().getIconForNode(dataNode), 10);
        this.titleLabel.setBorder(labelPadding);
        panel.add(this.titleLabel);
        if (!dataNode.isEmptyMetaNode()) {
            this.addTable(panel);
        }
        for (ArbilDataNode child : dataNode.getChildArray()) {
            this.addChildPanel(panel, child);
        }
        return panel;
    }

    private void updateTitleLabel() {
        this.titleLabel.setText(this.dataNode.toString());
        this.titleLabel.setIcon(ArbilIcons.getSingleInstance().getIconForNode(this.dataNode));
    }

    private void addTable(JPanel panel) {
        ArbilTableModel arbilTableModel = new ArbilTableModel(this.imageBoxRenderer);
        arbilTableModel.addArbilDataNodes(new ArbilDataNode[]{this.dataNode});
        this.table = new ArbilTable(arbilTableModel, this.tableController, this.dataNode.toString());
        this.table.getTableHeader().setAlignmentX(0.0f);
        this.table.setAlignmentX(0.0f);
        panel.add(this.table.getTableHeader());
        panel.add(this.table);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
    }

    private void addChildPanel(JPanel panel, ArbilDataNode child) {
        ArbilSubnodesPanel childPanel = new ArbilSubnodesPanel(child, this, this.tableController, this.imageBoxRenderer);
        this.children.add(childPanel);
        panel.add(childPanel);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    public boolean isFullyLoadedNodeRequired() {
        return true;
    }

    public void dataNodeRemoved(ArbilNode dataNode) {
        if (dataNode == this.dataNode) {
            this.clear();
            this.revalidate();
            this.repaint();
        } else {
            this.reloadRunner.requestActionAndNotify();
        }
    }

    public void dataNodeIconCleared(ArbilNode dataNode) {
        this.reloadRunner.requestActionAndNotify();
    }

    public void dataNodeChildAdded(ArbilNode destination, ArbilNode newNode) {
    }

    protected synchronized void reload() {
        List<ArbilDataNode> nodeChildren = Arrays.asList(this.dataNode.getChildArray());
        LinkedList<ArbilDataNode> nodesToAdd = new LinkedList<ArbilDataNode>(nodeChildren);
        boolean nodesRemoved = false;
        for (ArbilSubnodesPanel arbilSubnodesPanel : this.children) {
            if (nodeChildren.contains(arbilSubnodesPanel.getDataNode())) {
                nodesToAdd.remove(arbilSubnodesPanel.getDataNode());
                arbilSubnodesPanel.reload();
                continue;
            }
            nodesRemoved = true;
            break;
        }
        if (nodesRemoved) {
            this.clear();
            this.addContents();
        } else {
            if (this.table == null && !this.dataNode.isEmptyMetaNode()) {
                this.addTable(this.contentPanel);
            }
            if (!nodesToAdd.isEmpty()) {
                for (ArbilDataNode arbilDataNode : nodesToAdd) {
                    this.addChildPanel(this.contentPanel, arbilDataNode);
                }
            }
        }
        this.updateTitleLabel();
        if (this.isTopLevelPanel()) {
            this.revalidate();
        }
    }

    protected final ArbilSubnodesPanel getTopLevelPanel() {
        if (this.parent == null) {
            return this;
        }
        if (this.parent.isTopLevelPanel()) {
            return this.parent;
        }
        return this.parent.getTopLevelPanel();
    }

    private void reloadAll() {
        if (EventQueue.isDispatchThread()) {
            this.reload();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        ArbilSubnodesPanel.this.reload();
                    }
                });
            }
            catch (InterruptedException ex) {
                return;
            }
            catch (InvocationTargetException ex) {
                return;
            }
        }
    }
}

