/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.fieldeditors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import nl.mpi.arbil.data.ArbilVocabularyItem;

public class ControlledVocabularyComboBoxRenderer
extends JPanel
implements ListCellRenderer {
    public static final Color CODE_LABEL_FOREGROUND = Color.GRAY;
    public static final Color CODE_LABEL_SELECTED_FOREGROUND = Color.DARK_GRAY;
    private final JLabel displayValueLabel;
    private final JLabel codeLabel;

    public ControlledVocabularyComboBoxRenderer() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.displayValueLabel = new JLabel("value");
        this.displayValueLabel.setOpaque(false);
        this.add((Component)this.displayValueLabel, "Center");
        this.codeLabel = new JLabel("code");
        this.codeLabel.setOpaque(false);
        this.codeLabel.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.codeLabel.setHorizontalAlignment(11);
        this.add((Component)this.codeLabel, "After");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setPreferredSize(new Dimension(list.getWidth(), this.getPreferredSize().height));
        if (value instanceof ArbilVocabularyItem) {
            ArbilVocabularyItem item = (ArbilVocabularyItem)value;
            this.displayValueLabel.setText(item.getDisplayValue());
            if (item.hasItemCode()) {
                this.codeLabel.setText(item.getValue());
            }
            this.codeLabel.setVisible(item.hasItemCode());
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.displayValueLabel.setForeground(list.getSelectionForeground());
            this.codeLabel.setForeground(CODE_LABEL_SELECTED_FOREGROUND);
        } else {
            this.setBackground(list.getBackground());
            this.displayValueLabel.setForeground(list.getForeground());
            this.codeLabel.setForeground(CODE_LABEL_FOREGROUND);
        }
        this.displayValueLabel.setFont(list.getFont());
        this.codeLabel.setFont(list.getFont());
        return this;
    }
}

