/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.crypto;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMWriter;

public class CSR
extends PKCS10CertificationRequest {
    protected static final String DUMMY_DN = "C=X, O=Y, CN=Z";

    public CSR(String string, PublicKey publicKey, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        super("SHA1WithRSA", new X509Name(string), publicKey, (ASN1Set)new DERSet(), privateKey);
    }

    public CSR(PublicKey publicKey, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(DUMMY_DN, publicKey, privateKey);
    }

    public String pemString() throws IOException {
        String string = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PEMWriter pEMWriter = new PEMWriter((Writer)stringWriter);
            pEMWriter.writeObject((Object)this);
            pEMWriter.close();
            string = URLEncoder.encode(stringWriter.toString(), "UTF-8");
        }
        catch (Exception exception) {
            throw new IOException("Cannot construct pemstring from CSR: " + exception.getMessage());
        }
        return string;
    }

    public String hash() throws IOException {
        String string = null;
        try {
            byte[] byArray = this.getEncoded();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1", "BC");
            byte[] byArray2 = messageDigest.digest(byArray);
            string = this.bytetoString(byArray2);
        }
        catch (Exception exception) {
            throw new IOException("Cannot construct SHA1 hash from CSR: " + exception.getMessage());
        }
        return string;
    }

    private String bytetoString(byte[] byArray) {
        char[] cArray = new char[2 * byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] >= 0 ? byArray[i] : byArray[i] + 256;
            int n2 = n >> 4;
            int n3 = n - (n2 << 4);
            cArray[2 * i] = "0123456789abcdef".charAt(n2);
            cArray[2 * i + 1] = "0123456789abcdef".charAt(n3);
        }
        return new String(cArray);
    }
}

