/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.util.Hashtable;
import java.util.Vector;
import net.handle.dnslib.DNSResolver;
import net.handle.dnslib.DNSResourceData;
import net.handle.dnslib.DNSResourceRecord;

public class DNSResourceMXData
extends DNSResourceData {
    protected String[] exchangeName;
    protected int preference;

    public DNSResourceMXData() {
        this.exchangeName = new String[0];
        this.preference = 0;
    }

    public DNSResourceMXData(byte[] data, int offset, int length) {
        this.decodeData(data, offset, length);
    }

    public void decodeData(byte[] data, int offset, int length) {
        this.preference = (data[offset++] & 0xFF) << 8;
        this.preference |= data[offset++] & 0xFF;
        Vector names = new Vector();
        offset += DNSResourceRecord.readNameFromPointer(data, offset, names);
        this.exchangeName = new String[names.size()];
        for (int i = 0; i < this.exchangeName.length; ++i) {
            this.exchangeName[i] = (String)names.elementAt(i);
        }
    }

    public int encodeData(byte[] data, int location, Hashtable nameTable) {
        int origLoc = location;
        data[location++] = (byte)((this.preference & 0xFF00) >> 8);
        data[location++] = (byte)(this.preference & 0xFF);
        location += DNSResourceRecord.writeNameToPointer(this.exchangeName, data, location, nameTable);
        return location - origLoc;
    }

    public String toString() {
        return "  exchange: " + DNSResolver.convertDNSNameToString(this.exchangeName) + ";  preference: " + this.preference;
    }
}

