/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.api.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class HeaderInfo {
    private final String name;
    private final String value;
    private final Map<String, String> attributes;

    public HeaderInfo(String name, String value) {
        this(name, value, null);
    }

    public HeaderInfo(String name, String value, Map<String, String> attributes) {
        this.name = name;
        this.value = value;
        this.attributes = attributes == null ? null : new HashMap<String, String>(attributes);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public String toString() {
        return String.format("[%1$s: %2$s]", this.getName(), this.getValue());
    }
}

