/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.pluginloader.ui;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import nl.mpi.flap.module.BaseModule;
import nl.mpi.pluginloader.PluginManager;
import nl.mpi.pluginloader.PluginService;
import nl.mpi.pluginloader.ui.PluginMenuAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginMenu
extends JMenu {
    private static final Logger logger = LoggerFactory.getLogger(PluginMenu.class);
    final PluginService pluginService;

    public PluginMenu(PluginService pluginService, PluginManager pluginManager, boolean hideIfNoPluginsFound) {
        super("Plugins");
        this.pluginService = pluginService;
        Iterator<BaseModule> pluginIterator = pluginService.getPlugins();
        boolean hasPlugins = false;
        while (pluginIterator.hasNext()) {
            try {
                hasPlugins = true;
                BaseModule kinOathPlugin = pluginIterator.next();
                logger.debug("Plugin: " + kinOathPlugin.getName());
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(new PluginMenuAction(pluginManager, kinOathPlugin));
                menuItem.setSelected(pluginManager.isActivated(kinOathPlugin));
                this.add(menuItem);
            }
            catch (ServiceConfigurationError serviceError) {
                logger.error("Error while listing plugins", (Throwable)serviceError);
                this.add(new JLabel("<failed to load plugin>"));
            }
        }
        if (!hasPlugins) {
            this.add(new JLabel("<no plugins found>"));
            this.setVisible(!hideIfNoPluginsFound);
        }
    }
}

