/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleResolver;

public abstract class GetSiteInfo {
    public static final void main(String[] argv) throws Exception {
        if (argv.length < 3) {
            System.err.println("usage: java net.handle.apps.tools.GetSiteInfo <server> <port> <output-file>");
            System.exit(1);
        }
        String addrStr = argv[0];
        String portStr = argv[1];
        String outputFileStr = argv[2];
        InetAddress addr = InetAddress.getByName(addrStr);
        int port = Integer.parseInt(portStr);
        File outputFile = new File(outputFileStr);
        GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 2, null);
        AbstractResponse aresponse = new HandleResolver().sendHdlTcpRequest(req, addr, port, null);
        FileOutputStream out = null;
        if (aresponse.responseCode == 1) {
            GetSiteInfoResponse response = (GetSiteInfoResponse)aresponse;
            out = new FileOutputStream(outputFileStr);
            out.write(Encoder.encodeSiteInfoRecord(response.siteInfo));
            out.close();
        } else {
            System.err.println("Error: got unexpected response: " + aresponse);
        }
    }
}

